/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model.managers.impl;

import com.atlassian.crucible.activity.lucene.DefaultReviewItemIndexerTestFixture;
import com.atlassian.crucible.activity.lucene.ReviewItemIndexer;
import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.managers.impl.DefaultReviewManager;
import com.cenqua.crucible.view.reviewfilters.ReviewFilterDef;
import com.cenqua.crucible.view.reviewfilters.ReviewFilters;
import com.cenqua.dbutils.ModelUtils;
import com.cenqua.fisheye.lucene.LuceneHelper;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.lang.time.FastDateFormat;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermRangeQuery;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsCollectionContaining;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;

public class DefaultReviewManagerTest {
    private DefaultReviewManager defaultReviewManager;
    private ReviewItemIndexer reviewItemIndexerMock;
    private FastDateFormat sdf = LuceneHelper.getTimestampFormat();

    @Before
    public void setUp() throws Exception {
        this.reviewItemIndexerMock = (ReviewItemIndexer)Mockito.mock(ReviewItemIndexer.class);
        this.defaultReviewManager = ModelUtils.getReviewManagerWithMockedManagersAndRealDAOs();
        this.defaultReviewManager.setReviewItemIndexer(this.reviewItemIndexerMock);
    }

    @Test
    public void testGetReviewIdsAsRolesInStatesWithFromAndToDate() {
        ReviewFilterDef filterDef = new ReviewFilterDef(ReviewFilters.FilterKey.INBOX);
        filterDef.fromDate = 1363863913758L;
        filterDef.toDate = 1363869913758L;
        this.defaultReviewManager.getMatchingReviewIds(filterDef, "");
        ArgumentCaptor argument = ArgumentCaptor.forClass(BooleanQuery.class);
        ((ReviewItemIndexer)Mockito.verify((Object)this.reviewItemIndexerMock)).findIds((Query)argument.capture(), org.mockito.Matchers.anyString());
        BooleanClause expected = new BooleanClause((Query)new TermRangeQuery("dTimeMillis", this.sdf.format(new Date(filterDef.fromDate)), this.sdf.format(new Date(filterDef.toDate)), true, true), BooleanClause.Occur.MUST);
        MatcherAssert.assertThat((Object)((BooleanQuery)argument.getValue()).clauses(), (Matcher)IsCollectionContaining.hasItem((Object)expected));
    }

    @Test
    public void testGetReviewIdsAsRolesInStatesWithFromDateOnly() {
        ReviewFilterDef filterDef = new ReviewFilterDef(ReviewFilters.FilterKey.INBOX);
        filterDef.fromDate = 1363863913758L;
        this.defaultReviewManager.getMatchingReviewIds(filterDef, "");
        ArgumentCaptor argument = ArgumentCaptor.forClass(BooleanQuery.class);
        ((ReviewItemIndexer)Mockito.verify((Object)this.reviewItemIndexerMock)).findIds((Query)argument.capture(), org.mockito.Matchers.anyString());
        BooleanClause expected = new BooleanClause((Query)new TermRangeQuery("dTimeMillis", this.sdf.format(new Date(filterDef.fromDate)), null, true, true), BooleanClause.Occur.MUST);
        MatcherAssert.assertThat((Object)((BooleanQuery)argument.getValue()).clauses(), (Matcher)IsCollectionContaining.hasItem((Object)expected));
    }

    @Test
    public void testGetReviewIdsAsRolesInStatesWithToDateOnly() {
        ReviewFilterDef filterDef = new ReviewFilterDef(ReviewFilters.FilterKey.INBOX);
        filterDef.toDate = 1363869913758L;
        this.defaultReviewManager.getMatchingReviewIds(filterDef, "");
        ArgumentCaptor argument = ArgumentCaptor.forClass(BooleanQuery.class);
        ((ReviewItemIndexer)Mockito.verify((Object)this.reviewItemIndexerMock)).findIds((Query)argument.capture(), org.mockito.Matchers.anyString());
        BooleanClause expected = new BooleanClause((Query)new TermRangeQuery("dTimeMillis", null, this.sdf.format(new Date(filterDef.toDate)), true, true), BooleanClause.Occur.MUST);
        MatcherAssert.assertThat((Object)((BooleanQuery)argument.getValue()).clauses(), (Matcher)IsCollectionContaining.hasItem((Object)expected));
    }

    @Test
    public void testGetReviewIdsAsRolesInStatesWithNoDate() {
        ReviewFilterDef filterDef = new ReviewFilterDef(ReviewFilters.FilterKey.INBOX);
        this.defaultReviewManager.getMatchingReviewIds(filterDef, "");
        ArgumentCaptor argument = ArgumentCaptor.forClass(BooleanQuery.class);
        ((ReviewItemIndexer)Mockito.verify((Object)this.reviewItemIndexerMock)).findIds((Query)argument.capture(), org.mockito.Matchers.anyString());
        Matcher isATermRangeQuery = Matchers.instanceOf(TermRangeQuery.class);
        MatcherAssert.assertThat((Object)((BooleanQuery)argument.getValue()).clauses(), (Matcher)Matchers.not((Matcher)IsCollectionContaining.hasItem((Matcher)isATermRangeQuery)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOutForReviewResults() throws Exception {
        DefaultReviewItemIndexerTestFixture fixture = new DefaultReviewItemIndexerTestFixture();
        try {
            Project proj = fixture.addProject(10, "PROJ");
            Review approval = fixture.addReview(proj, 1, "npellow", "mquail", "waiting for mod to approve", "", "", "", "Approval", new Date(), "fred");
            Review allComplete = fixture.addReview(proj, 2, "npellow", "mquail", "waiting for mod to summarise", "", "", "", "Review", new Date(), new String[]{"fred"}, new boolean[]{true}, "npellow");
            Review allCompleteNoModerator = fixture.addReview(proj, 3, "npellow", null, "waiting for me to summarise", "", "", "", "Review", new Date(), new String[]{"fred"}, new boolean[]{true}, "npellow");
            Review notComplete = fixture.addReview(proj, 4, "npellow", "mquail", "waiting for reviewers to complete", "", "", "", "Review", new Date(), new String[]{"fred", "jim"}, new boolean[]{true, false}, "npellow");
            Review notCompleteNoModerator = fixture.addReview(proj, 5, "npellow", null, "waiting for reviewers to complete", "", "", "", "Review", new Date(), new String[]{"fred", "jim"}, new boolean[]{true, false}, "npellow");
            this.defaultReviewManager.setReviewItemIndexer((ReviewItemIndexer)fixture.start());
            ReviewFilters filters = new ReviewFilters(new FecruUser("npellow"));
            Collection reviews = this.defaultReviewManager.getMatchingReviewIds(filters.getFilterDefByKey(ReviewFilters.FilterKey.OUT_FOR_REVIEW), null);
            Assert.assertEquals((long)4L, (long)reviews.size());
            Assert.assertTrue((!reviews.contains(3) ? 1 : 0) != 0);
        }
        finally {
            fixture.stop();
        }
    }

    @After
    public void tearDown() throws Exception {
    }
}

