/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model.managers.impl;

import com.atlassian.crucible.activity.review.ActivityItemTestBase;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.model.Comment;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.managers.CrucibleActivityItemManager;
import com.cenqua.crucible.model.managers.CrucibleActivityItemParameter;
import com.cenqua.crucible.model.managers.LogManager;
import com.cenqua.crucible.model.managers.Order;
import com.cenqua.crucible.model.managers.UserActionManager;
import com.cenqua.crucible.model.managers.impl.DefaultCrucibleActivityItemManager;
import com.cenqua.crucible.notification.NotificationManager;
import com.cenqua.crucible.util.ReviewCreationHelper;
import com.cenqua.crucible.util.ReviewCreationTestHelper;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class DefaultCrucibleActivityItemManagerTest
extends ActivityItemTestBase {
    private static final String REVIEW1_CSID = "MAIN:matt:20041205010425";
    private static final String REVIEW2_CSID = "MAIN:matt:20050113032653";
    private Review review1;
    private Review review2;
    private Comment comment1;
    private Comment comment2;
    private Comment comment3;
    private Comment comment4;
    private CrucibleActivityItemManager mgr;
    private Project fooProject;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.fooProject = this.pm.createProject("Foo", "FOO");
        HibernateUtil.beginTransaction();
        this.review1 = this.reviewManager.createReview(this.pm, this.pm.getDefaultProject(), "test review1", this.currentUser);
        this.review1.setModerator(this.currentUser);
        this.review1.setAuthor(this.currentUser);
        this.review1.setCreator(this.currentUser);
        this.reviewManager.addReviewer(this.review1, this.reviewer);
        HibernateUtil.commitTransaction();
        ReviewCreationHelper cvsRch1 = new ReviewCreationHelper(this.cvsSource, this.review1, this.contentManager, (NotificationManager)Mockito.mock(NotificationManager.class), this.spiUtils, this.commentManager, this.eventPublisher);
        HibernateUtil.beginTransaction();
        this.review2 = this.reviewManager.createReview(this.pm, this.fooProject, "test review1 2", this.currentUser);
        this.review2.setModerator(this.currentUser);
        this.review2.setAuthor(this.currentUser);
        this.review2.setCreator(this.currentUser);
        this.reviewManager.addReviewer(this.review2, this.reviewer);
        HibernateUtil.commitTransaction();
        ReviewCreationHelper cvsRch2 = new ReviewCreationHelper(this.cvsSource, this.review2, this.contentManager, (NotificationManager)Mockito.mock(NotificationManager.class), this.spiUtils, this.commentManager, this.eventPublisher);
        HibernateUtil.beginTransaction();
        ReviewCreationTestHelper.addChangeSet(cvsRch1, this.cvsSource, this.currentUser, REVIEW1_CSID, null, null, ReviewCreationHelper.MetadataFilter.NONE);
        this.comment1 = this.commentManager.createComment("comment1 on MAIN:matt:20041205010425", this.review1, this.currentUser);
        this.review1.addComment(this.comment1);
        LogManager.logCommentAdded((Review)this.review1, (Comment)this.comment1);
        this.reviewManager.changeState(this.review1, UserActionManager.ACTION_APPROVE, this.currentUser);
        HibernateUtil.commitTransaction();
        HibernateUtil.beginTransaction();
        ReviewCreationTestHelper.addChangeSet(cvsRch2, this.cvsSource, this.currentUser, REVIEW2_CSID, null, null, ReviewCreationHelper.MetadataFilter.NONE);
        this.comment2 = this.commentManager.createComment("comment2 on MAIN:matt:20050113032653", this.review2, this.currentUser);
        this.review2.addComment(this.comment2);
        LogManager.logCommentAdded((Review)this.review2, (Comment)this.comment2);
        this.reviewManager.changeState(this.review2, UserActionManager.ACTION_APPROVE, this.currentUser);
        HibernateUtil.commitTransaction();
        HibernateUtil.beginTransaction();
        this.comment3 = this.commentManager.createComment("comment 3 on MAIN:matt:20041205010425", this.review1, this.reviewer);
        LogManager.logCommentAdded((Review)this.review1, (Comment)this.comment3);
        HibernateUtil.commitTransaction();
        HibernateUtil.beginTransaction();
        this.review1.setReviewerComplete(this.reviewer);
        HibernateUtil.commitTransaction();
        HibernateUtil.beginTransaction();
        this.comment4 = this.commentManager.createComment("comment 4 on MAIN:matt:20050113032653", this.review2, this.reviewer);
        this.review2.addComment(this.comment4);
        LogManager.logCommentAdded((Review)this.review2, (Comment)this.comment4);
        HibernateUtil.commitTransaction();
        HibernateUtil.beginTransaction();
        this.review2.setReviewerComplete(this.reviewer);
        HibernateUtil.commitTransaction();
        this.mgr = new DefaultCrucibleActivityItemManager();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.fooProject = null;
        this.review1 = null;
        this.review2 = null;
        this.comment1 = null;
        this.comment2 = null;
        this.comment3 = null;
        this.comment4 = null;
        this.mgr = null;
        super.tearDown();
    }

    @Test
    public void testWithNoParams() {
        List activityItems = this.mgr.getActivityForReviewsAndUsers((Iterable)ImmutableList.of(), Order.ASC);
        Assert.assertEquals((long)13L, (long)activityItems.size());
    }

    @Test
    public void testForActivityNotInKnownUsernames() {
        CrucibleActivityItemParameter param = CrucibleActivityItemParameter.builder((CrucibleActivityItemParameter.ActivityItemKey)CrucibleActivityItemParameter.ActivityItemKey.USERNAME, (CrucibleActivityItemParameter.Operator)CrucibleActivityItemParameter.Operator.NOT_IN).values((Iterable)ImmutableList.of((Object)"creator", (Object)"reviewer")).build();
        List activityItems = this.mgr.getActivityForReviewsAndUsers((Iterable)ImmutableList.of((Object)param), Order.DESC);
        Assert.assertEquals((long)0L, (long)activityItems.size());
    }

    @Test
    public void testForActivityByReviewer() {
        CrucibleActivityItemParameter param = CrucibleActivityItemParameter.builder((CrucibleActivityItemParameter.ActivityItemKey)CrucibleActivityItemParameter.ActivityItemKey.USERNAME, (CrucibleActivityItemParameter.Operator)CrucibleActivityItemParameter.Operator.IN).value((Object)"reviewer").build();
        List activityItems = this.mgr.getActivityForReviewsAndUsers((Iterable)ImmutableList.of((Object)param), Order.DESC);
        Assert.assertEquals((long)4L, (long)activityItems.size());
    }

    @Test
    public void testForCommentsByCreator() {
        ImmutableList params = ImmutableList.of((Object)CrucibleActivityItemParameter.builder((CrucibleActivityItemParameter.ActivityItemKey)CrucibleActivityItemParameter.ActivityItemKey.USERNAME, (CrucibleActivityItemParameter.Operator)CrucibleActivityItemParameter.Operator.IN).value((Object)"creator").build(), (Object)CrucibleActivityItemParameter.builder((CrucibleActivityItemParameter.ActivityItemKey)CrucibleActivityItemParameter.ActivityItemKey.ACTION, (CrucibleActivityItemParameter.Operator)CrucibleActivityItemParameter.Operator.IN).value((Object)"COMMENT_ADDED").build());
        List activityItems = this.mgr.getActivityForReviewsAndUsers((Iterable)params, Order.DESC);
        Assert.assertEquals((long)2L, (long)activityItems.size());
    }

    @Test
    public void testForActivityBeforeDate() {
        CrucibleActivityItemParameter param = CrucibleActivityItemParameter.builder((CrucibleActivityItemParameter.ActivityItemKey)CrucibleActivityItemParameter.ActivityItemKey.CREATE_DATE, (CrucibleActivityItemParameter.Operator)CrucibleActivityItemParameter.Operator.LT).value((Object)this.review2.getCreateDate()).build();
        List activityItems = this.mgr.getActivityForReviewsAndUsers((Iterable)ImmutableList.of((Object)param), Order.DESC);
        Assert.assertEquals((long)1L, (long)activityItems.size());
    }

    @Test
    public void testForActivityInProject() {
        CrucibleActivityItemParameter param = CrucibleActivityItemParameter.builder((CrucibleActivityItemParameter.ActivityItemKey)CrucibleActivityItemParameter.ActivityItemKey.PROJECT_KEY, (CrucibleActivityItemParameter.Operator)CrucibleActivityItemParameter.Operator.EQ).value((Object)this.fooProject.getProjKey()).build();
        List activityItems = this.mgr.getActivityForReviewsAndUsers((Iterable)ImmutableList.of((Object)param), Order.DESC);
        Assert.assertEquals((long)6L, (long)activityItems.size());
    }
}

