/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model.managers;

import com.atlassian.crucible.activity.lucene.ReviewItemIndexer;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fisheye.user.permissions.GlobalPermissionManager;
import com.atlassian.fisheye.user.permissions.GlobalPermissionType;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.model.PermissionScheme;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.model.PrincipalTestSupport;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.managers.PermissionManager;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.model.managers.UserActionManager;
import com.cenqua.crucible.model.managers.impl.DefaultReviewManager;
import com.cenqua.crucible.util.DummyConfig;
import com.cenqua.crucible.util.DummyConfigDocument;
import com.cenqua.crucible.util.DummyReviewItemIndexer;
import com.cenqua.crucible.util.DummySecurityType;
import com.cenqua.dbutils.ModelUtils;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.rep.TestFishEyeInstances;
import com.cenqua.fisheye.user.GroupMembershipManager;
import com.cenqua.fisheye.user.UserManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class UserActionManagerTest
extends PrincipalTestSupport {
    private Set<String> cruDisabledUsers;
    private Map<String, FecruUser> addedUsers = new HashMap<String, FecruUser>();
    private RootConfig oldRootConfig;
    private PermissionManager permissionManager;

    protected void setUp() throws Exception {
        super.setUp();
        TestFishEyeInstances.loadSanity1();
        DefaultReviewManager reviewManager = ModelUtils.getReviewManagerWithMockedManagersAndRealDAOs();
        reviewManager.setReviewItemIndexer((ReviewItemIndexer)new DummyReviewItemIndexer());
        DefaultReviewManager.set((ReviewManager)reviewManager);
        this.cruDisabledUsers = new HashSet<String>();
        DummySecurityType securityType = new DummySecurityType(true, true);
        DummyConfigDocument config = new DummyConfigDocument(new DummyConfig(securityType));
        final UserManager userManager = (UserManager)Mockito.mock(UserManager.class);
        Mockito.when((Object)userManager.isCrucibleEnabled(Mockito.anyString())).thenAnswer((Answer)new Answer<Boolean>(){

            public Boolean answer(InvocationOnMock invocation) throws Throwable {
                return !UserActionManagerTest.this.cruDisabledUsers.contains(invocation.getArguments()[0]);
            }
        });
        RootConfig root = new RootConfig(){

            public UserManager getUserManager() {
                return userManager;
            }
        };
        root.setConfig((ConfigDocument)config);
        this.oldRootConfig = AppConfig.getsConfig();
        AppConfig.resetConfig((RootConfig)root);
        UserActionManager.resetForTests();
        this.permissionManager = ModelUtils.getPermissionManager();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        HibernateUtil.commitTransaction();
        AppConfig.resetConfig((RootConfig)this.oldRootConfig);
        HibernateUtil.closeSession();
        TestFishEyeInstances.stop();
    }

    public void testDefaultPS() throws Exception {
        HibernateUtil.beginTransaction();
        PrincipalTestSupport.MockGroupManager gm = new PrincipalTestSupport.MockGroupManager();
        Review r = ModelUtils.createBlankTestReview("testreview");
        FecruUser mod = this.addUser("fred");
        FecruUser auth = this.addUser("jim");
        FecruUser rev = this.addUser("jane");
        FecruUser creator = this.addUser("morris");
        FecruUser punter = this.addUser("dudex");
        FecruUser notCruUser = this.addUser("notCruUser");
        this.cruDisabledUsers.add(notCruUser.getUsername());
        r.setModerator(mod);
        r.setAuthor(auth);
        r.setCreator(creator);
        DefaultReviewManager.get().addReviewer(r, rev);
        PrincipalTestSupport.MockPrincipal modp = new PrincipalTestSupport.MockPrincipal(mod.getUsername());
        gm.addPrincipalToGroup(modp, "random");
        PrincipalTestSupport.MockPrincipal authp = new PrincipalTestSupport.MockPrincipal(auth.getUsername());
        PrincipalTestSupport.MockPrincipal revp = new PrincipalTestSupport.MockPrincipal(rev.getUsername());
        PrincipalTestSupport.MockPrincipal punterp = new PrincipalTestSupport.MockPrincipal(punter.getUsername());
        PrincipalTestSupport.MockPrincipal notCruUserp = new PrincipalTestSupport.MockPrincipal(notCruUser.getUsername());
        PermissionScheme ps = this.permissionManager.getDefaultPermissionScheme();
        UserActionManagerTest.assertNotNull((Object)ps);
        UserManager userManager = (UserManager)Mockito.mock(UserManager.class);
        Mockito.when((Object)userManager.isCrucibleEnabled(Mockito.anyString())).thenAnswer((Answer)new Answer<Boolean>(){

            public Boolean answer(InvocationOnMock invocation) throws Throwable {
                return !UserActionManagerTest.this.cruDisabledUsers.contains((String)invocation.getArguments()[0]);
            }
        });
        Mockito.when((Object)userManager.getLicensedUser(Mockito.anyString())).thenAnswer((Answer)new Answer<FecruUser>(){

            public FecruUser answer(InvocationOnMock invocation) throws Throwable {
                return (FecruUser)UserActionManagerTest.this.addedUsers.get((String)invocation.getArguments()[0]);
            }
        });
        GlobalPermissionManager globalPermissionManager = (GlobalPermissionManager)Mockito.mock(GlobalPermissionManager.class);
        Mockito.when((Object)globalPermissionManager.hasPermission((String)Matchers.argThat((Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)notCruUserp.getUserName()))), (GlobalPermissionType)Matchers.any(GlobalPermissionType.class))).thenReturn((Object)true);
        PermissionManager permissionManager = ModelUtils.getPermissionManager(userManager, (GroupMembershipManager)Mockito.mock(GroupMembershipManager.class), globalPermissionManager);
        UserActionManagerTest.assertTrue((boolean)permissionManager.canPrincipalDoAction(ps, (Principal)modp, null, "action:createReview", r));
        UserActionManagerTest.assertTrue((boolean)permissionManager.canPrincipalDoAction(ps, (Principal)modp, null, "action:approveReview", r));
        UserActionManagerTest.assertTrue((boolean)permissionManager.canPrincipalDoAction(ps, (Principal)modp, null, "action:rejectReview", r));
        UserActionManagerTest.assertFalse((boolean)permissionManager.canPrincipalDoAction(ps, (Principal)modp, null, "action:summarizeReview", r));
        UserActionManagerTest.assertTrue((boolean)permissionManager.canPrincipalDoAction(ps, (Principal)modp, null, "action:closeReview", r));
        UserActionManagerTest.assertTrue((boolean)permissionManager.canPrincipalDoAction(ps, (Principal)modp, null, "action:reopenReview", r));
        UserActionManagerTest.assertFalse((boolean)permissionManager.canPrincipalDoAction(ps, (Principal)modp, null, "action:completeReview", r));
        UserActionManagerTest.assertTrue((boolean)permissionManager.canPrincipalDoAction(ps, (Principal)revp, null, "action:createReview", r));
        UserActionManagerTest.assertTrue((boolean)permissionManager.canPrincipalDoAction(ps, (Principal)revp, null, "action:completeReview", r));
        UserActionManagerTest.assertFalse((boolean)permissionManager.canPrincipalDoAction(ps, (Principal)revp, null, "action:approveReview", r));
        UserActionManagerTest.assertFalse((boolean)permissionManager.canPrincipalDoAction(ps, (Principal)revp, null, "action:rejectReview", r));
        UserActionManagerTest.assertFalse((boolean)permissionManager.canPrincipalDoAction(ps, (Principal)revp, null, "action:summarizeReview", r));
        UserActionManagerTest.assertTrue((boolean)permissionManager.canPrincipalDoAction(ps, (Principal)revp, null, "action:closeReview", r));
        UserActionManagerTest.assertTrue((boolean)permissionManager.canPrincipalDoAction(ps, (Principal)revp, null, "action:reopenReview", r));
        UserActionManagerTest.assertTrue((boolean)permissionManager.canPrincipalDoAction(ps, (Principal)authp, null, "action:createReview", r));
        UserActionManagerTest.assertTrue((boolean)permissionManager.canPrincipalDoAction(ps, (Principal)authp, null, "action:approveReview", r));
        UserActionManagerTest.assertTrue((boolean)permissionManager.canPrincipalDoAction(ps, (Principal)authp, null, "action:rejectReview", r));
        UserActionManagerTest.assertFalse((boolean)permissionManager.canPrincipalDoAction(ps, (Principal)authp, null, "action:summarizeReview", r));
        UserActionManagerTest.assertTrue((boolean)permissionManager.canPrincipalDoAction(ps, (Principal)authp, null, "action:closeReview", r));
        UserActionManagerTest.assertTrue((boolean)permissionManager.canPrincipalDoAction(ps, (Principal)authp, null, "action:reopenReview", r));
        UserActionManagerTest.assertFalse((boolean)permissionManager.canPrincipalDoAction(ps, (Principal)authp, null, "action:completeReview", r));
        UserActionManagerTest.assertTrue((boolean)permissionManager.canPrincipalDoAction(ps, (Principal)punterp, null, "action:createReview", r));
        UserActionManagerTest.assertFalse((boolean)permissionManager.canPrincipalDoAction(ps, (Principal)punterp, null, "action:approveReview", r));
        UserActionManagerTest.assertFalse((boolean)permissionManager.canPrincipalDoAction(ps, (Principal)punterp, null, "action:rejectReview", r));
        UserActionManagerTest.assertFalse((boolean)permissionManager.canPrincipalDoAction(ps, (Principal)punterp, null, "action:summarizeReview", r));
        UserActionManagerTest.assertFalse((boolean)permissionManager.canPrincipalDoAction(ps, (Principal)punterp, null, "action:closeReview", r));
        UserActionManagerTest.assertFalse((boolean)permissionManager.canPrincipalDoAction(ps, (Principal)punterp, null, "action:reopenReview", r));
        UserActionManagerTest.assertFalse((boolean)permissionManager.canPrincipalDoAction(ps, (Principal)punterp, null, "action:completeReview", r));
        UserActionManagerTest.assertFalse((boolean)permissionManager.canPrincipalDoAction(ps, (Principal)notCruUserp, null, "action:createReview", r));
        UserActionManagerTest.assertFalse((boolean)permissionManager.canPrincipalDoAction(ps, (Principal)notCruUserp, null, "action:approveReview", r));
        UserActionManagerTest.assertFalse((boolean)permissionManager.canPrincipalDoAction(ps, (Principal)notCruUserp, null, "action:rejectReview", r));
        UserActionManagerTest.assertFalse((boolean)permissionManager.canPrincipalDoAction(ps, (Principal)notCruUserp, null, "action:summarizeReview", r));
        UserActionManagerTest.assertFalse((boolean)permissionManager.canPrincipalDoAction(ps, (Principal)notCruUserp, null, "action:closeReview", r));
        UserActionManagerTest.assertFalse((boolean)permissionManager.canPrincipalDoAction(ps, (Principal)notCruUserp, null, "action:reopenReview", r));
        UserActionManagerTest.assertFalse((boolean)permissionManager.canPrincipalDoAction(ps, (Principal)notCruUserp, null, "action:completeReview", r));
        HibernateUtil.commitTransaction();
    }

    private FecruUser addUser(String username) throws Exception {
        FecruUser user = ModelUtils.makeAndSaveUser(username);
        this.addedUsers.put(username, user);
        return user;
    }
}

