/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model.managers;

import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.CrucibleSysProps;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.model.Comment;
import com.cenqua.crucible.model.CrucibleRevision;
import com.cenqua.crucible.model.FRXComment;
import com.cenqua.crucible.model.FileRevisionExtraInfo;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.StateChangeLog;
import com.cenqua.crucible.model.managers.CommentManager;
import com.cenqua.crucible.model.managers.FRXCommentManager;
import com.cenqua.crucible.model.managers.FRXManager;
import com.cenqua.crucible.model.managers.FileRevisionManager;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.model.managers.ReviewPropertiesManager;
import com.cenqua.crucible.model.managers.impl.DefaultReviewManager;
import com.cenqua.crucible.util.UseTestSpringContextTestCase;
import com.cenqua.dbutils.ModelUtils;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.rep.TestFishEyeInstances;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.hibernate.CacheMode;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ReviewManagerTest
extends UseTestSpringContextTestCase {
    private Review review1;
    private Review review2;
    private Review review3;
    private Project defaultProject;
    private Project otherProject;
    private ReviewManager reviewManager;
    private CommentManager commentManager;
    private FecruUser user1;
    private FecruUser user2;
    private FecruUser user3;
    private int oldSqlInClauseSizeLimit;

    @Before
    public void setUp() throws Exception {
        TestFishEyeInstances.loadSanity1();
        this.commentManager = (CommentManager)SpringContext.getComponent((String)"commentManager");
        HibernateUtil.beginTransaction();
        this.review1 = ModelUtils.createBlankTestReview("review1");
        this.review2 = ModelUtils.createBlankTestReview("review2");
        this.review3 = ModelUtils.createBlankTestReview("review3");
        HibernateUtil.bounceTransaction();
        this.defaultProject = ModelUtils.getProjectManager().getDefaultProject();
        this.otherProject = ModelUtils.getProjectManager().createProject("project 2", "PROJ2");
        ModelUtils.getProjectManager().moveReviewToProject(this.review3, this.otherProject);
        this.user1 = ModelUtils.makeAndSaveUser("user1");
        this.user2 = ModelUtils.makeAndSaveUser("user2");
        this.user3 = ModelUtils.makeAndSaveUser("user3");
        HibernateUtil.commitTransaction();
        this.reviewManager = DefaultReviewManager.get();
        this.oldSqlInClauseSizeLimit = CrucibleSysProps.SQL_IN_CLAUSE_SIZE_LIMIT;
    }

    @After
    public void tearDown() throws Exception {
        this.setSqlInClauseSizeLimit(this.oldSqlInClauseSizeLimit);
        HibernateUtil.commitTransaction();
        HibernateUtil.closeSession();
        TestFishEyeInstances.stop();
    }

    @Test
    public void testReviewExists() throws Exception {
        Assert.assertTrue((boolean)this.reviewManager.reviewExists(this.review1.getPermaId()));
        Assert.assertTrue((boolean)this.reviewManager.reviewExists(this.review2.getPermaId()));
        Assert.assertTrue((boolean)this.reviewManager.reviewExists(this.review3.getPermaId()));
        Assert.assertFalse((boolean)this.reviewManager.reviewExists("CR-5678"));
        Assert.assertFalse((boolean)this.reviewManager.reviewExists("FOO-666"));
        Assert.assertFalse((boolean)this.reviewManager.reviewExists("non matching non existent"));
    }

    @Test
    public void testReviewsAreActuallyReviewsAndNotSomethingElseLikeSnippets() throws Exception {
        Assert.assertEquals((Object)Review.ReviewType.REVIEW, (Object)this.review1.getType());
        Assert.assertEquals((Object)Review.ReviewType.REVIEW, (Object)this.review2.getType());
        Assert.assertEquals((Object)Review.ReviewType.REVIEW, (Object)this.review3.getType());
    }

    @Test
    public void testCountStatesOn() {
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        cal.set(2008, 0, 20, 0, 0, 0);
        HibernateUtil.beginTransaction();
        StateChangeLog changeLog = new StateChangeLog("Draft", this.review1.getId(), this.review1.getCreator());
        changeLog.setTimeStamp(cal.getTime());
        HibernateUtil.currentSession().save((Object)changeLog);
        ((Calendar)cal).add(12, 6);
        changeLog = new StateChangeLog("Draft", this.review2.getId(), this.review2.getCreator());
        changeLog.setTimeStamp(cal.getTime());
        HibernateUtil.currentSession().save((Object)changeLog);
        ((Calendar)cal).add(12, 2);
        changeLog = new StateChangeLog("Approval", this.review1.getId(), this.review1.getCreator());
        changeLog.setTimeStamp(cal.getTime());
        HibernateUtil.currentSession().save((Object)changeLog);
        ((Calendar)cal).add(12, 15);
        changeLog = new StateChangeLog("Review", this.review1.getId(), this.review1.getCreator());
        changeLog.setTimeStamp(cal.getTime());
        HibernateUtil.currentSession().save((Object)changeLog);
        changeLog = new StateChangeLog("Review", this.review3.getId(), this.review3.getCreator());
        changeLog.setTimeStamp(cal.getTime());
        HibernateUtil.currentSession().save((Object)changeLog);
        ((Calendar)cal).add(12, 4);
        changeLog = new StateChangeLog("Approval", this.review2.getId(), this.review2.getCreator());
        changeLog.setTimeStamp(cal.getTime());
        HibernateUtil.currentSession().save((Object)changeLog);
        ((Calendar)cal).add(12, 1);
        changeLog = new StateChangeLog("Review", this.review2.getId(), this.review2.getCreator());
        changeLog.setTimeStamp(cal.getTime());
        HibernateUtil.currentSession().save((Object)changeLog);
        ((Calendar)cal).add(12, 15);
        changeLog = new StateChangeLog("Summarize", this.review1.getId(), this.review1.getCreator());
        changeLog.setTimeStamp(cal.getTime());
        HibernateUtil.currentSession().save((Object)changeLog);
        HibernateUtil.commitTransaction();
        ((Calendar)cal).add(12, 1);
        long started = System.currentTimeMillis();
        Map stateCounts = this.reviewManager.countStatesOn(cal.getTime(), this.defaultProject);
        long count = stateCounts.get("Review") == null ? 0L : (Long)stateCounts.get("Review");
        System.out.println("Query took " + (System.currentTimeMillis() - started) + " ms");
        Assert.assertEquals((long)count, (long)1L);
        started = System.currentTimeMillis();
        stateCounts = this.reviewManager.countStatesOn(cal.getTime(), this.otherProject);
        count = stateCounts.get("Review") == null ? 0L : (Long)stateCounts.get("Review");
        System.out.println("Query took " + (System.currentTimeMillis() - started) + " ms");
        Assert.assertEquals((long)count, (long)1L);
        started = System.currentTimeMillis();
        stateCounts = this.reviewManager.countStatesOn(cal.getTime(), this.defaultProject);
        count = stateCounts.get("Summarize") == null ? 0L : (Long)stateCounts.get("Summarize");
        System.out.println("Query took " + (System.currentTimeMillis() - started) + " ms");
        Assert.assertEquals((long)count, (long)1L);
        started = System.currentTimeMillis();
        stateCounts = this.reviewManager.countStatesOn(cal.getTime(), this.otherProject);
        count = stateCounts.get("Summarize") == null ? 0L : (Long)stateCounts.get("Summarize");
        System.out.println("Query took " + (System.currentTimeMillis() - started) + " ms");
        Assert.assertEquals((long)count, (long)0L);
        started = System.currentTimeMillis();
        stateCounts = this.reviewManager.countStatesOn(cal.getTime(), this.defaultProject);
        count = stateCounts.get("Approval") == null ? 0L : (Long)stateCounts.get("Approval");
        System.out.println("Query took " + (System.currentTimeMillis() - started) + " ms");
        Assert.assertEquals((long)count, (long)0L);
        ((Calendar)cal).add(12, -15);
        started = System.currentTimeMillis();
        stateCounts = this.reviewManager.countStatesOn(cal.getTime(), this.defaultProject);
        count = stateCounts.get("Review") == null ? 0L : (Long)stateCounts.get("Review");
        System.out.println("Query took " + (System.currentTimeMillis() - started) + " ms");
        Assert.assertEquals((long)count, (long)2L);
        ((Calendar)cal).add(12, -1);
        started = System.currentTimeMillis();
        stateCounts = this.reviewManager.countStatesOn(cal.getTime(), this.defaultProject);
        count = stateCounts.get("Review") == null ? 0L : (Long)stateCounts.get("Review");
        System.out.println("Query took " + (System.currentTimeMillis() - started) + " ms");
        Assert.assertEquals((long)count, (long)1L);
        started = System.currentTimeMillis();
        stateCounts = this.reviewManager.countStatesOn(cal.getTime(), this.defaultProject);
        count = stateCounts.get("Approval") == null ? 0L : (Long)stateCounts.get("Approval");
        System.out.println("Query took " + (System.currentTimeMillis() - started) + " ms");
        Assert.assertEquals((long)count, (long)1L);
        cal = new GregorianCalendar(TimeZone.getTimeZone("UTC - 10"));
        cal.set(2008, 0, 20, 0, 0, 0);
        started = System.currentTimeMillis();
        stateCounts = this.reviewManager.countStatesOn(cal.getTime(), this.defaultProject);
        count = stateCounts.get("Approval") == null ? 0L : (Long)stateCounts.get("Approval");
        System.out.println("Query took " + (System.currentTimeMillis() - started) + " ms");
        Assert.assertFalse((count == 1L ? 1 : 0) != 0);
    }

    @Test
    public void testDeleteReview() throws Exception {
        ReviewPropertiesManager reviewPropertiesManager = ModelUtils.getReviewPropertiesManager();
        String propertyName = "prop1";
        HibernateUtil.beginTransaction();
        FecruUser fred = ModelUtils.makeAndSaveUser("fred");
        Comment reviewComment = this.commentManager.createComment("A test comment", this.review1, fred);
        Comment reply = this.commentManager.createComment("A reply", this.review1, fred);
        reviewComment.addComment(reply);
        this.review1.addComment(reviewComment);
        CrucibleRevision cruRev = FileRevisionManager.createRevision((String)"fred", (String)"/foo/bar.java", (String)"1.1", (String)"1.1", (Date)new Date());
        FileRevisionExtraInfo frx = this.review1.addRevision(cruRev);
        Comment revisionComment = this.commentManager.createComment("Revision comment", this.review1, fred);
        FRXComment rc = FRXCommentManager.createAndAddFrxComment((Comment)revisionComment, (FileRevisionExtraInfo)frx);
        reviewPropertiesManager.put(this.review1.getPermaId(), propertyName, "value1");
        HibernateUtil.commitTransaction();
        HibernateUtil.beginTransaction();
        Assert.assertEquals((long)2L, (long)ModelUtils.getProjectManager().countReviewsInProject(this.defaultProject));
        this.reviewManager.deleteReview(this.review1, this.review1.getCreator());
        Assert.assertEquals((long)1L, (long)ModelUtils.getProjectManager().countReviewsInProject(this.defaultProject));
        HibernateUtil.commitTransaction();
        HibernateUtil.closeSession();
        HibernateUtil.beginTransaction();
        Assert.assertNull((Object)this.commentManager.getById(revisionComment.getId()));
        Assert.assertNull((Object)this.commentManager.getById(reply.getId()));
        Assert.assertNull((Object)FRXCommentManager.getById((Integer)rc.getId()));
        Assert.assertNull((Object)this.commentManager.getById(reviewComment.getId()));
        Assert.assertNull((Object)FRXManager.getById((Integer)frx.getId()));
        Assert.assertNull((Object)this.reviewManager.getReviewById(this.review1.getId()));
        Assert.assertNull((Object)reviewPropertiesManager.get(this.review1.getPermaId(), propertyName));
        Assert.assertEquals((long)1L, (long)ModelUtils.getProjectManager().countReviewsInProject(this.defaultProject));
        HibernateUtil.commitTransaction();
    }

    @Test
    public void testReview2ndLevelCaching() throws Exception {
        Integer review1Id = this.review1.getId();
        Integer review2Id = this.review2.getId();
        Integer review3Id = this.review3.getId();
        HibernateUtil.closeSession();
        long hitCount = HibernateUtil.getSessionFactory().getStatistics().getSecondLevelCacheStatistics(Review.class.getName()).getHitCount();
        Assert.assertEquals((Object)CacheMode.NORMAL, (Object)HibernateUtil.currentSession().getCacheMode());
        Assert.assertNotNull((Object)this.reviewManager.getReviewById(review1Id));
        Assert.assertNotNull((Object)this.reviewManager.getReviewById(review2Id));
        Assert.assertNotNull((Object)this.reviewManager.getReviewById(review3Id));
        Assert.assertEquals((long)(hitCount + 3L), (long)HibernateUtil.getSessionFactory().getStatistics().getSecondLevelCacheStatistics(Review.class.getName()).getHitCount());
    }

    @Test
    public void testGetReviewCountForUsersInBatch() throws Exception {
        HibernateUtil.beginTransaction();
        this.reviewManager.addReviewer(this.review1, this.user1);
        this.reviewManager.addReviewer(this.review1, this.user2);
        this.reviewManager.addReviewer(this.review1, this.user3);
        this.review1.setStateName("Review");
        HibernateUtil.commitTransaction();
        HibernateUtil.beginTransaction();
        this.setSqlInClauseSizeLimit(2);
        Object2LongMap result = this.reviewManager.getReviewCountForUsers(null, null, (Set)Sets.newHashSet((Object[])new String[]{this.user1.getUsername(), this.user2.getUsername(), this.user3.getUsername()}));
        Object2LongOpenHashMap expected = new Object2LongOpenHashMap();
        expected.put((Object)this.user1.getUsername(), 1L);
        expected.put((Object)this.user2.getUsername(), 1L);
        expected.put((Object)this.user3.getUsername(), 1L);
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testSearchReviewForTermsIsSafeFromHQLInjection() throws Exception {
        ModelUtils.createBlankTestReview("'foo");
        HibernateUtil.bounceTransaction();
        List results = this.reviewManager.searchReviewForTerms(Arrays.asList("'foo", "Draft"), "review.id", null, Integer.valueOf(1), null);
        Assert.assertEquals((String)"Expected to find review with name 'foo", (long)1L, (long)results.size());
    }

    private void setSqlInClauseSizeLimit(int sqlInClauseSizeLimit) {
        System.setProperty("crucible.sql.inclause.limit", String.valueOf(sqlInClauseSizeLimit));
        CrucibleSysProps.reloadProperties();
    }
}

