/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model.managers;

import com.cenqua.crucible.hibernate.CurrentSessionProvider;
import com.cenqua.crucible.model.PermissionScheme;
import com.cenqua.crucible.model.managers.PermissionManager;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.model.managers.UserActionManager;

public class PermissionManagerTestUtil {
    public static void checkAndCreateDefaultPS(CurrentSessionProvider currentSessionProvider, PermissionManager permissionManager) {
        PermissionScheme ps = permissionManager.getDefaultPermissionScheme();
        if (ps != null) {
            return;
        }
        ps = permissionManager.getDefaultPermissionScheme();
        if (ps == null) {
            ps = new PermissionScheme("default");
            ps.setId(Integer.valueOf(1));
            currentSessionProvider.currentSession().save((Object)ps);
        }
        String[] authorActions = new String[]{UserActionManager.ACTION_COMMENT, UserActionManager.ACTION_VIEW};
        String[] creatorActions = new String[]{UserActionManager.ACTION_ABANDON, UserActionManager.ACTION_CLOSE, UserActionManager.ACTION_DELETE, UserActionManager.ACTION_MOD_FILES, UserActionManager.ACTION_RECOVER, UserActionManager.ACTION_SUBMIT, UserActionManager.ACTION_VIEW};
        String[] moderatorActions = new String[]{UserActionManager.ACTION_APPROVE, UserActionManager.ACTION_COMMENT, UserActionManager.ACTION_CLOSE, UserActionManager.ACTION_MOD_FILES, UserActionManager.ACTION_RECOVER, UserActionManager.ACTION_REJECT, UserActionManager.ACTION_REOPEN, UserActionManager.ACTION_SUMMARIZE, UserActionManager.ACTION_VIEW};
        String[] reviewerActions = new String[]{UserActionManager.ACTION_COMMENT, UserActionManager.ACTION_COMPLETE, UserActionManager.ACTION_UNCOMPLETE, UserActionManager.ACTION_VIEW};
        PermissionManagerTestUtil.addReviewRoleActions(ps, ReviewManager.AUTHOR.getName(), authorActions);
        PermissionManagerTestUtil.addReviewRoleActions(ps, ReviewManager.CREATOR.getName(), creatorActions);
        PermissionManagerTestUtil.addReviewRoleActions(ps, ReviewManager.MODERATOR.getName(), moderatorActions);
        PermissionManagerTestUtil.addReviewRoleActions(ps, ReviewManager.REVIEWER.getName(), reviewerActions);
        ps.addAllUsersAction(UserActionManager.ACTION_VIEW);
        ps.addAllUsersAction(UserActionManager.ACTION_CREATE);
    }

    private static void addReviewRoleActions(PermissionScheme ps, String pid, String[] actions) {
        for (String action : actions) {
            ps.addReviewRoleAction(pid, action);
        }
    }
}

