/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model.managers;

import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fecru.user.UserProfile;
import com.cenqua.crucible.hibernate.CurrentSessionProvider;
import com.cenqua.crucible.model.CrucibleRevision;
import com.cenqua.crucible.model.FRXRevision;
import com.cenqua.crucible.model.FileReadStatus;
import com.cenqua.crucible.model.FileRevisionExtraInfo;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.ReviewParticipant;
import com.cenqua.crucible.model.StoredPath;
import com.cenqua.crucible.model.managers.FRXRevisionManager;
import com.cenqua.crucible.model.managers.UnreadFileManager;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Date;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hibernate.Session;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class FRXRevisionManagerTest {
    @Mock
    private UnreadFileManager unreadFileManager;
    @Mock
    private CurrentSessionProvider currentSessionProvider;
    @Mock
    private Session session;
    @Mock
    private FileRevisionExtraInfo frx;
    @Mock
    private Review review;

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.currentSessionProvider.currentSession()).thenReturn((Object)this.session);
        Mockito.when((Object)this.frx.getReview()).thenReturn((Object)this.review);
    }

    @Test
    public void testCreateAndAddFRXRevision_skipsOnExistingRevision() throws Exception {
        CrucibleRevision fr = new CrucibleRevision();
        Mockito.when((Object)this.frx.getFRXRevision((CrucibleRevision)org.mockito.Matchers.eq((Object)fr))).thenReturn((Object)new FRXRevision());
        Mockito.when((Object)this.frx.getFrxRevisions()).thenReturn(Collections.emptyList());
        FRXRevisionManager frxRevisionManager = this.createFRXRevisionManager();
        FRXRevision result = frxRevisionManager.createFRXRevisionAndUnread(this.frx, 0, fr);
        Assert.assertThat((Object)result, (Matcher)Matchers.nullValue());
        ((Session)Mockito.verify((Object)this.session, (VerificationMode)Mockito.never())).save(org.mockito.Matchers.anyObject());
        ((UnreadFileManager)Mockito.verify((Object)this.unreadFileManager, (VerificationMode)Mockito.never())).markAsUnread((ReviewParticipant)org.mockito.Matchers.any(ReviewParticipant.class), (FileRevisionExtraInfo)org.mockito.Matchers.any(FileRevisionExtraInfo.class), (Date)org.mockito.Matchers.any(Date.class), org.mockito.Matchers.anyBoolean());
    }

    @Test
    public void testUnreadFrx_noForce() throws Exception {
        FRXRevisionManager frxRevisionManager = this.createFRXRevisionManager();
        Date unreadDate = new Date();
        ReviewParticipant participantA = this.mockParticipant("A", true);
        Mockito.when((Object)participantA.getReadStatus((FileRevisionExtraInfo)org.mockito.Matchers.eq((Object)this.frx))).thenReturn(null);
        ReviewParticipant participantB = this.mockParticipant("B", true);
        Mockito.when((Object)participantB.getReadStatus((FileRevisionExtraInfo)org.mockito.Matchers.eq((Object)this.frx))).thenReturn((Object)new FileReadStatus());
        ReviewParticipant participantC = this.mockParticipant("C", false);
        Mockito.when((Object)participantC.getReadStatus((FileRevisionExtraInfo)org.mockito.Matchers.eq((Object)this.frx))).thenReturn((Object)new FileReadStatus());
        Mockito.when((Object)this.review.getParticipants()).thenReturn((Object)ImmutableSet.of((Object)participantA, (Object)participantB, (Object)participantC));
        frxRevisionManager.markAsUnread(this.frx, unreadDate, false);
        ((UnreadFileManager)Mockito.verify((Object)this.unreadFileManager, (VerificationMode)Mockito.times((int)1))).markAsUnread((ReviewParticipant)org.mockito.Matchers.eq((Object)participantA), (FileRevisionExtraInfo)org.mockito.Matchers.eq((Object)this.frx), (Date)org.mockito.Matchers.eq((Object)unreadDate), org.mockito.Matchers.eq((boolean)false));
        ((UnreadFileManager)Mockito.verify((Object)this.unreadFileManager, (VerificationMode)Mockito.times((int)1))).markAsUnread((ReviewParticipant)org.mockito.Matchers.eq((Object)participantB), (FileRevisionExtraInfo)org.mockito.Matchers.eq((Object)this.frx), (Date)org.mockito.Matchers.eq((Object)unreadDate), org.mockito.Matchers.eq((boolean)false));
        ((UnreadFileManager)Mockito.verify((Object)this.unreadFileManager, (VerificationMode)Mockito.never())).markAsUnread((ReviewParticipant)org.mockito.Matchers.eq((Object)participantC), (FileRevisionExtraInfo)org.mockito.Matchers.eq((Object)this.frx), (Date)org.mockito.Matchers.eq((Object)unreadDate), org.mockito.Matchers.eq((boolean)false));
    }

    @Test
    public void testUnreadFrx_force() throws Exception {
        FRXRevisionManager frxRevisionManager = this.createFRXRevisionManager();
        Date unreadDate = new Date();
        ReviewParticipant participantA = this.mockParticipant("A", true);
        Mockito.when((Object)participantA.getReadStatus((FileRevisionExtraInfo)org.mockito.Matchers.eq((Object)this.frx))).thenReturn(null);
        ReviewParticipant participantB = this.mockParticipant("B", true);
        Mockito.when((Object)participantB.getReadStatus((FileRevisionExtraInfo)org.mockito.Matchers.eq((Object)this.frx))).thenReturn((Object)new FileReadStatus());
        ReviewParticipant participantC = this.mockParticipant("C", false);
        Mockito.when((Object)participantC.getReadStatus((FileRevisionExtraInfo)org.mockito.Matchers.eq((Object)this.frx))).thenReturn((Object)new FileReadStatus());
        Mockito.when((Object)this.review.getParticipants()).thenReturn((Object)ImmutableSet.of((Object)participantA, (Object)participantB, (Object)participantC));
        frxRevisionManager.markAsUnread(this.frx, unreadDate, true);
        ((UnreadFileManager)Mockito.verify((Object)this.unreadFileManager, (VerificationMode)Mockito.times((int)1))).markAsUnread((ReviewParticipant)org.mockito.Matchers.eq((Object)participantA), (FileRevisionExtraInfo)org.mockito.Matchers.eq((Object)this.frx), (Date)org.mockito.Matchers.eq((Object)unreadDate), org.mockito.Matchers.eq((boolean)true));
        ((UnreadFileManager)Mockito.verify((Object)this.unreadFileManager, (VerificationMode)Mockito.times((int)1))).markAsUnread((ReviewParticipant)org.mockito.Matchers.eq((Object)participantB), (FileRevisionExtraInfo)org.mockito.Matchers.eq((Object)this.frx), (Date)org.mockito.Matchers.eq((Object)unreadDate), org.mockito.Matchers.eq((boolean)true));
        ((UnreadFileManager)Mockito.verify((Object)this.unreadFileManager, (VerificationMode)Mockito.times((int)1))).markAsUnread((ReviewParticipant)org.mockito.Matchers.eq((Object)participantC), (FileRevisionExtraInfo)org.mockito.Matchers.eq((Object)this.frx), (Date)org.mockito.Matchers.eq((Object)unreadDate), org.mockito.Matchers.eq((boolean)true));
    }

    @Test
    public void testUnreadFrxFromRevisionExcluding() throws Exception {
        FRXRevisionManager frxRevisionManager = this.createFRXRevisionManager();
        ImmutableList frxRevisions = ImmutableList.of((Object)this.mockFrxRevision(1000L), (Object)this.mockFrxRevision(3000L), (Object)this.mockFrxRevision(2000L));
        Mockito.when((Object)this.frx.getFrxRevisions()).thenReturn((Object)frxRevisions);
        ReviewParticipant participantC = this.mockParticipant("C", false);
        Mockito.when((Object)participantC.getReadStatus((FileRevisionExtraInfo)org.mockito.Matchers.eq((Object)this.frx))).thenReturn((Object)new FileReadStatus());
        Mockito.when((Object)this.review.getParticipants()).thenReturn((Object)ImmutableSet.of((Object)participantC));
        frxRevisionManager.markAsUnreadFromRevision((FRXRevision)frxRevisions.get(1), false);
        ((Session)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)1))).save(org.mockito.Matchers.argThat(this.matchFrxRevision(2000L, (Matcher<Date>)Matchers.greaterThan((Comparable)new Date(3000L)))));
        ((UnreadFileManager)Mockito.verify((Object)this.unreadFileManager, (VerificationMode)Mockito.times((int)1))).markAsUnread((ReviewParticipant)org.mockito.Matchers.eq((Object)participantC), (FileRevisionExtraInfo)org.mockito.Matchers.eq((Object)this.frx), (Date)org.mockito.Matchers.argThat((Matcher)Matchers.greaterThan((Comparable)new Date(3000L))), org.mockito.Matchers.eq((boolean)true));
    }

    @Test
    public void testUnreadFrxFromRevisionIncluding() throws Exception {
        FRXRevisionManager frxRevisionManager = this.createFRXRevisionManager();
        ImmutableList frxRevisions = ImmutableList.of((Object)this.mockFrxRevision(1000L), (Object)this.mockFrxRevision(3000L), (Object)this.mockFrxRevision(2000L));
        Mockito.when((Object)this.frx.getFrxRevisions()).thenReturn((Object)frxRevisions);
        ReviewParticipant participantC = this.mockParticipant("C", false);
        Mockito.when((Object)participantC.getReadStatus((FileRevisionExtraInfo)org.mockito.Matchers.eq((Object)this.frx))).thenReturn((Object)new FileReadStatus());
        Mockito.when((Object)this.review.getParticipants()).thenReturn((Object)ImmutableSet.of((Object)participantC));
        frxRevisionManager.markAsUnreadFromRevision((FRXRevision)frxRevisions.get(1), true);
        ((UnreadFileManager)Mockito.verify((Object)this.unreadFileManager, (VerificationMode)Mockito.times((int)1))).markAsUnread((ReviewParticipant)org.mockito.Matchers.eq((Object)participantC), (FileRevisionExtraInfo)org.mockito.Matchers.eq((Object)this.frx), (Date)org.mockito.Matchers.argThat((Matcher)Matchers.is((Object)new Date(3000L))), org.mockito.Matchers.eq((boolean)true));
        ((Session)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)1))).save(org.mockito.Matchers.argThat(this.matchFrxRevision(2000L, (Matcher<Date>)Matchers.is((Object)new Date(3000L)))));
    }

    @Test
    public void testResetDueDateIfOld() throws Exception {
        long reviewDuration = 1000000L;
        long currentTimeMillis = System.currentTimeMillis();
        this.testUpdateDueDate(reviewDuration, currentTimeMillis - reviewDuration / 2L, Mockito.never(), (Matcher<Long>)Matchers.any(Long.class));
        this.testUpdateDueDate(reviewDuration, currentTimeMillis - 2L * reviewDuration, Mockito.times((int)1), (Matcher<Long>)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(currentTimeMillis + reviewDuration)));
        this.testUpdateDueDate(reviewDuration, currentTimeMillis + reviewDuration / 2L, Mockito.never(), (Matcher<Long>)Matchers.any(Long.class));
        this.testUpdateDueDate(reviewDuration, currentTimeMillis + 2L * reviewDuration, Mockito.never(), (Matcher<Long>)Matchers.any(Long.class));
    }

    private void testUpdateDueDate(long reviewDuration, long reviewDueDate, VerificationMode setDueDateTimeVerification, Matcher<Long> setDueDateTime) throws Exception {
        Review review = (Review)Mockito.mock(Review.class);
        Project project = (Project)Mockito.mock(Project.class);
        Mockito.when((Object)project.getDefaultDurationInMillis()).thenReturn((Object)reviewDuration);
        FRXRevisionManager frxRevisionManager = this.createFRXRevisionManager();
        Mockito.when((Object)review.getProject()).thenReturn((Object)project);
        Mockito.when((Object)review.getDueDateTime()).thenReturn((Object)reviewDueDate);
        frxRevisionManager.resetDueDateIfOld(review);
        ((Review)Mockito.verify((Object)review, (VerificationMode)setDueDateTimeVerification)).setDueDateTime((Long)org.mockito.Matchers.argThat(setDueDateTime));
    }

    private ReviewParticipant mockParticipant(String username, boolean uncompleteOnRevisionAdded) {
        ReviewParticipant participant = (ReviewParticipant)Mockito.mock(ReviewParticipant.class);
        Mockito.when((Object)participant.getUser()).thenReturn((Object)this.createUser(username, uncompleteOnRevisionAdded));
        return participant;
    }

    private FRXRevision mockFrxRevision(long dateAdded) {
        CrucibleRevision fr = new CrucibleRevision("sourceA", new StoredPath("a.txt", ""), String.valueOf(dateAdded), String.valueOf(dateAdded), new Date(dateAdded));
        return new FRXRevision(this.frx, fr, new Date(dateAdded));
    }

    private Matcher<FRXRevision> matchFrxRevision(long revision, Matcher<Date> dateAddedMatcher) {
        return Matchers.allOf((Matcher)Matchers.instanceOf(FRXRevision.class), (Matcher)Matchers.hasProperty((String)"revision", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{Matchers.hasProperty((String)"revision", (Matcher)Matchers.is((Object)String.valueOf(revision)))})), (Matcher)Matchers.hasProperty((String)"dateAdded", dateAddedMatcher));
    }

    private FecruUser createUser(String username, boolean uncompleteOnRevisionAdded) {
        FecruUser user = new FecruUser(username);
        UserProfile profile = new UserProfile(user);
        profile.setUncompleteOnRevisionAdded(uncompleteOnRevisionAdded);
        user.setUserProfile(profile);
        return user;
    }

    private FRXRevisionManager createFRXRevisionManager() {
        return new FRXRevisionManager(){

            Session session() {
                return FRXRevisionManagerTest.this.session;
            }

            UnreadFileManager getUnreadFileManager() {
                return FRXRevisionManagerTest.this.unreadFileManager;
            }
        };
    }
}

