/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model.managers;

import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fecru.user.FecruUserDAO;
import com.cenqua.crucible.hibernate.CurrentSessionProvider;
import com.cenqua.crucible.model.PermissionScheme;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.StateChangeLog;
import com.cenqua.crucible.model.dao.Generators;
import com.cenqua.crucible.model.dao.HibernatePermissionSchemeDAO;
import com.cenqua.crucible.model.dao.HibernateProjectDAO;
import com.cenqua.crucible.model.dao.HibernateReviewDAO;
import com.cenqua.crucible.model.managers.StateChangeLogManager;
import com.cenqua.crucible.model.managers.UserActionManager;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.transaction.TransactionConfiguration;
import org.springframework.transaction.annotation.Transactional;

@TransactionConfiguration(defaultRollback=true)
@ContextConfiguration
@Transactional
@RunWith(value=SpringJUnit4ClassRunner.class)
@DirtiesContext
public class DefaultStateChangeLogManagerTest {
    @Autowired
    private HibernateReviewDAO reviewDAO;
    @Autowired
    private FecruUserDAO userDAO;
    @Autowired
    private HibernateProjectDAO projectDAO;
    @Autowired
    private HibernatePermissionSchemeDAO permissionSchemeDAO;
    @Autowired
    private CurrentSessionProvider currentSessionProvider;
    @Autowired
    private StateChangeLogManager stateChangeLogManager;
    private PermissionScheme permissionScheme;
    private Project project;
    private FecruUser user1;
    private Review review1;

    @Before
    public void setUp() throws Exception {
        this.permissionScheme = Generators.generatePermissionScheme();
        this.permissionSchemeDAO.add(this.permissionScheme);
        this.project = Generators.generateProject(this.permissionScheme);
        this.projectDAO.add(this.project);
        this.user1 = Generators.generateUser();
        this.userDAO.create(this.user1);
        this.review1 = Generators.generateReview(this.project, this.user1);
        this.reviewDAO.add(this.review1);
    }

    @Test
    public void testGetStateChangeByIds() throws Exception {
        StateChangeLog stateChangeLog1 = this.stateChangeLogManager.addStateChange(UserActionManager.Action.ACTION_CREATE.getName(), this.review1.getId(), this.user1);
        StateChangeLog stateChangeLog2 = this.stateChangeLogManager.addStateChange(UserActionManager.Action.ACTION_CLOSE.getName(), this.review1.getId(), this.user1);
        StateChangeLog stateChangeLog3 = this.stateChangeLogManager.addStateChange(UserActionManager.Action.ACTION_REOPEN.getName(), this.review1.getId(), this.user1);
        List result = this.stateChangeLogManager.getStateChangeByIds((Collection)ImmutableList.of((Object)stateChangeLog1.getId(), (Object)stateChangeLog2.getId()));
        Assert.assertThat((Object)Iterables.transform((Iterable)result, (Function)StateChangeLog.TO_ID), (Matcher)Matchers.containsInAnyOrder((Object[])new Integer[]{stateChangeLog1.getId(), stateChangeLog2.getId()}));
    }
}

