/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model.managers;

import com.cenqua.crucible.model.managers.DefaultSnippetManager;
import junit.framework.Assert;
import org.junit.Test;

public final class DefaultSnippetManagerTest {
    private final DefaultSnippetManager snippetManager = new DefaultSnippetManager();

    @Test
    public void testSnippetNaming() throws Exception {
        String title = "This is a title";
        String constructed = this.snippetManager.constructSnippetName(title, "java", "Java", "upload text");
        Assert.assertEquals((String)title, (String)constructed);
        constructed = this.snippetManager.constructSnippetName(null, "java", "Java", "upload text");
        Assert.assertEquals((String)"1 line of Java", (String)constructed);
        constructed = this.snippetManager.constructSnippetName(null, "java", "Java", "upload text\nupload text");
        Assert.assertEquals((String)"2 lines of Java", (String)constructed);
        constructed = this.snippetManager.constructSnippetName(null, null, null, "upload text\nupload text");
        Assert.assertEquals((String)"Untitled", (String)constructed);
    }

    @Test
    public void testSnippetRenaming() throws Exception {
        String constructed = this.snippetManager.reconstructSnippetName("1 line of Java", "Java", "C++");
        Assert.assertEquals((String)"1 line of C++", (String)constructed);
        constructed = this.snippetManager.reconstructSnippetName("2 lines of Java", "Java", "C++");
        Assert.assertEquals((String)"2 lines of C++", (String)constructed);
        constructed = this.snippetManager.reconstructSnippetName("2 lines of code", "Java", "C++");
        Assert.assertEquals((String)"2 lines of code", (String)constructed);
        constructed = this.snippetManager.reconstructSnippetName(null, "Java", "C++");
        Assert.assertEquals(null, (String)constructed);
        constructed = this.snippetManager.reconstructSnippetName("Untitled", "Java", "C++");
        Assert.assertEquals((String)"Untitled", (String)constructed);
        constructed = this.snippetManager.reconstructSnippetName("2 lines of Java that have blah", "Java", "C++");
        Assert.assertEquals((String)"2 lines of Java that have blah", (String)constructed);
    }

    @Test
    public void testNoneRenaming() throws Exception {
        String constructed = this.snippetManager.reconstructSnippetName("1 line", "None", "C++");
        Assert.assertEquals((String)"1 line of C++", (String)constructed);
        constructed = this.snippetManager.reconstructSnippetName("1 line of C++", "C++", "None");
        Assert.assertEquals((String)"1 line", (String)constructed);
        constructed = this.snippetManager.reconstructSnippetName("2 lines", "None", "C++");
        Assert.assertEquals((String)"2 lines of C++", (String)constructed);
        constructed = this.snippetManager.reconstructSnippetName("2 lines of C++", "C++", "None");
        Assert.assertEquals((String)"2 lines", (String)constructed);
    }

    @Test
    public void testBadReplacement() throws Exception {
        String constructed = this.snippetManager.reconstructSnippetName("3 lines of crazy blah", "Java", "C++");
        Assert.assertEquals((String)"3 lines of crazy blah", (String)constructed);
        constructed = this.snippetManager.reconstructSnippetName("1 line of crazy blah", "None", "C++");
        Assert.assertEquals((String)"1 line of crazy blah", (String)constructed);
    }
}

