/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model.managers;

import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.model.PermaIdKey;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.ReviewPermaId;
import com.cenqua.crucible.model.managers.ProjectManager;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.spi.MultithreadedServiceTestBase;
import com.cenqua.fisheye.config.SpringContext;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.Random;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hibernate.Session;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DefaultProjectManagerTest
extends MultithreadedServiceTestBase {
    private ProjectManager projectManager;
    private Project project;
    private IntOpenHashSet allIds;
    private final int NUMBER_OF_PERMAIDS = 1000;

    @Before
    public void setUp() throws Exception {
        this.projectManager = (ProjectManager)SpringContext.getComponent((String)"projectManager");
        this.project = this.projectManager.getDefaultProject();
    }

    @Test
    public void testGetNextPermaId() throws Exception {
        String TEST_PROJ_KEY = "TEST";
        HibernateUtil.ensureTransaction();
        this.checkPermaId("expecting initial value to be 1", this.project, 1);
        this.checkPermaId("value should increase by 1 on each call", this.project, 2);
        this.projectManager.changeProjectKey(this.project, "TEST");
        Project testProj = this.projectManager.createProject("Test", "TEST");
        this.checkPermaId("after project key change new project key continues as well as the old key", testProj, 3);
        this.project = this.projectManager.createProject("New CR", "CR");
        this.checkPermaId("new project with old key created, numeration should continue from next number after last used", this.project, 3);
    }

    @Test
    public void testGetNextPermaId_NewProject() throws Exception {
        String TEST_PROJ_KEY = "TEST-NP";
        HibernateUtil.ensureTransaction();
        Project testProj = this.projectManager.createProject("Test2", "TEST-NP");
        this.projectManager.createProject("Test 2", "TEST-NP");
        this.checkPermaId("new projects should be initialised by 1", testProj, 1);
        this.checkPermaId("next value increses by 1", testProj, 2);
        this.projectManager.deleteAllReviews(testProj, this.currentCrucibleUser, (ReviewManager)this.reviewManager);
        this.projectManager.deleteProject(testProj);
        testProj = this.projectManager.createProject("Test2", "TEST-NP");
        this.checkPermaId("After deleting, review perma Id seem to remain in the database, so when we create new proj with same key, it will continue", testProj, 3);
    }

    @Test
    public void testGetNextPermaId_NewProjectOnExistentKey() throws Exception {
        String TEST_PROJ_KEY = "TEST-NPOEK";
        HibernateUtil.ensureTransaction();
        this.session().save((Object)new ReviewPermaId(null, "TEST-NPOEK", 32));
        Project testProj = this.projectManager.createProject("Test2", "TEST-NPOEK");
        this.projectManager.createProject("Test 2", "TEST-NPOEK");
        this.checkPermaId("should be initialised at next value after last one stored", testProj, 33);
        this.checkPermaId("next value increses by 1", testProj, 34);
        this.projectManager.deleteAllReviews(testProj, this.currentCrucibleUser, (ReviewManager)this.reviewManager);
        this.projectManager.deleteProject(testProj);
        testProj = this.projectManager.createProject("Test2", "TEST-NPOEK");
        this.checkPermaId("After deleting, review perma Id seem to remain in the database, so when we create new proj with same key, it will continue", testProj, 35);
    }

    private void checkPermaId(String reason, Project project, int expectedId) {
        Review r = new Review();
        Assert.assertEquals((String)reason, (long)expectedId, (long)this.projectManager.getNextPermaId(project, r).getPermaIdKey().getNumber());
        this.session().save((Object)r);
    }

    private Session session() {
        return HibernateUtil.currentSession();
    }

    @Test
    public void testConcurrentGetNextPermaId() throws Exception {
        this.allIds = new IntOpenHashSet(10000);
        this.startWorkers();
        Assert.assertThat((String)"All requested perma ids generated", (Object)this.allIds, (Matcher)Matchers.hasSize((int)10000));
    }

    @Override
    public MultithreadedServiceTestBase.Worker getWorker() {
        return new MultithreadedServiceTestBase.Worker(){
            private final int[] ids;
            private final int[] delays;
            {
                this.ids = new int[1000];
                this.delays = new int[1000];
                Random rand = new Random();
                for (int i = 0; i < 1000; ++i) {
                    this.delays[i] = rand.nextInt(3) + 2;
                }
            }

            @Override
            public void runImpl() throws Exception {
                HibernateUtil.ensureTransaction();
                for (int i = 0; i < 1000; ++i) {
                    Review review = new Review(DefaultProjectManagerTest.this.projectManager, DefaultProjectManagerTest.this.project, Review.ReviewType.REVIEW, this.getId() + "_" + i);
                    DefaultProjectManagerTest.this.session().save((Object)review);
                    PermaIdKey key = DefaultProjectManagerTest.this.projectManager.getNextPermaId(DefaultProjectManagerTest.this.project, review).getPermaIdKey();
                    this.ids[i] = key.getNumber();
                    Thread.sleep(this.delays[i]);
                }
                HibernateUtil.closeSession();
            }

            @Override
            public void verifyStateOnShutdown() {
                for (int i = 0; i < 1000; ++i) {
                    Assert.assertTrue((String)"expected id to be unique", (boolean)DefaultProjectManagerTest.this.allIds.add(this.ids[i]));
                }
            }
        };
    }
}

