/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model.managers;

import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.model.PermissionScheme;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.managers.PermissionManager;
import com.cenqua.crucible.model.managers.ProjectManager;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.model.managers.UserActionManager;
import com.cenqua.dbutils.ModelUtils;
import java.util.Collections;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hibernate.stat.Statistics;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;

public class DefaultPermissionManagerTest {
    private ModelUtils mu;
    ProjectManager projectManager;
    Project defaultProject;
    Project otherProject;
    private PermissionManager permissionManager;

    @Autowired
    public void setProjectManager(ProjectManager projectManager) {
        this.projectManager = projectManager;
    }

    @Before
    public void setUp() throws Exception {
        this.mu = new ModelUtils();
        this.mu.createBlankDB();
        HibernateUtil.beginTransaction();
        this.projectManager = ModelUtils.getProjectManager();
        this.defaultProject = this.projectManager.getDefaultProject();
        this.otherProject = this.projectManager.createProject("project 2", "PROJ2");
        HibernateUtil.commitTransaction();
        this.permissionManager = ModelUtils.getPermissionManager();
    }

    @After
    public void tearDown() throws Exception {
        HibernateUtil.forceRollbackTransaction();
        this.mu.destroyDB();
    }

    @Test
    public void testCopyEmptyPermissionScheme() {
        PermissionScheme defaultScheme = (PermissionScheme)Mockito.mock(PermissionScheme.class);
        Mockito.when((Object)defaultScheme.getAnonymousPAs()).thenReturn(Collections.emptySet());
        Mockito.when((Object)defaultScheme.getAllUsersPAs()).thenReturn(Collections.emptySet());
        Mockito.when((Object)defaultScheme.getUserPAs()).thenReturn(Collections.emptySet());
        Mockito.when((Object)defaultScheme.getGroupPAs()).thenReturn(Collections.emptySet());
        Mockito.when((Object)defaultScheme.getReviewRolePAs()).thenReturn(Collections.emptySet());
        PermissionScheme permissionScheme = this.permissionManager.copyPermissionScheme(defaultScheme, "copy of empty permission scheme");
        Assert.assertEquals((Object)"copy of empty permission scheme", (Object)permissionScheme.getName());
        Assert.assertNotNull((Object)permissionScheme.getId());
        Assert.assertEquals((Object)Collections.EMPTY_SET, (Object)permissionScheme.getAnonymousPAs());
        Assert.assertEquals((Object)Collections.EMPTY_SET, (Object)permissionScheme.getAllUsersPAs());
        Assert.assertEquals((Object)Collections.EMPTY_SET, (Object)permissionScheme.getUserPAs());
        Assert.assertEquals((Object)Collections.EMPTY_SET, (Object)permissionScheme.getGroupPAs());
        Assert.assertEquals((Object)Collections.EMPTY_SET, (Object)permissionScheme.getReviewRolePAs());
    }

    @Test
    public void testGetProjectsRoleCanDoActionIn_refreshesProperly() {
        Set projectIdsCanView = this.permissionManager.getProjectsRoleCanDoActionIn(ReviewManager.AUTHOR, UserActionManager.ACTION_VIEW);
        this.permissionManager.getProjectsRoleCanDoActionIn(ReviewManager.AUTHOR, UserActionManager.ACTION_VIEW);
        HibernateUtil.beginTransaction();
        this.projectManager.createProject("project 3", "PROJ3");
        HibernateUtil.commitTransaction();
        Set projectIdsCanViewAfterUpdate = this.permissionManager.getProjectsRoleCanDoActionIn(ReviewManager.AUTHOR, UserActionManager.ACTION_VIEW);
        Assert.assertThat((Object)projectIdsCanView, (Matcher)Matchers.containsInAnyOrder((Object[])new Integer[]{1, 2}));
        Assert.assertThat((Object)projectIdsCanViewAfterUpdate, (Matcher)Matchers.containsInAnyOrder((Object[])new Integer[]{1, 2, 3}));
    }

    @Test
    public void testGetProjectsRoleCanDoActionIn_hitsCache() {
        Statistics statistics = HibernateUtil.getSessionFactory().getStatistics();
        this.permissionManager.getProjectsRoleCanDoActionIn(ReviewManager.AUTHOR, UserActionManager.ACTION_VIEW);
        long missCountAfterFirstMiss = statistics.getQueryCacheMissCount();
        this.permissionManager.getProjectsRoleCanDoActionIn(ReviewManager.AUTHOR, UserActionManager.ACTION_VIEW);
        long hitCountAfterFirstHit = statistics.getQueryCacheHitCount();
        HibernateUtil.beginTransaction();
        this.projectManager.createProject("project 3", "PROJ3");
        HibernateUtil.commitTransaction();
        this.permissionManager.getProjectsRoleCanDoActionIn(ReviewManager.AUTHOR, UserActionManager.ACTION_VIEW);
        this.permissionManager.getProjectsRoleCanDoActionIn(ReviewManager.AUTHOR, UserActionManager.ACTION_VIEW);
        Assert.assertEquals((long)1L, (long)missCountAfterFirstMiss);
        Assert.assertEquals((long)1L, (long)hitCountAfterFirstHit);
        Assert.assertEquals((long)2L, (long)statistics.getQueryCacheMissCount());
        Assert.assertEquals((long)2L, (long)statistics.getQueryCacheHitCount());
    }
}

