/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model.managers;

import com.atlassian.fecru.user.EffectiveUserProvider;
import com.cenqua.crucible.model.CrucibleRevision;
import com.cenqua.crucible.model.Patch;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.dao.PatchDAO;
import com.cenqua.crucible.model.managers.DefaultPatchManager;
import com.cenqua.crucible.model.managers.PatchManager;
import com.cenqua.crucible.revision.diff.patchDiff.PatchException;
import com.cenqua.crucible.revision.source.PatchSource;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.internal.verification.VerificationModeFactory;
import org.mockito.verification.VerificationMode;

public class DefaultPatchManagerTest {
    private PatchManager patchManager;
    private PatchDAO patchDAO;

    @Before
    public void setUp() throws Exception {
        this.patchDAO = (PatchDAO)Mockito.mock(PatchDAO.class);
        this.patchManager = new DefaultPatchManager(this.patchDAO, (EffectiveUserProvider)Mockito.mock(EffectiveUserProvider.class));
    }

    @Test
    public void testGetPatchById() throws Exception {
        Integer id = 5;
        Patch patch = new Patch();
        Mockito.when((Object)this.patchDAO.getPatchById((Integer)org.mockito.Matchers.eq((Object)id))).thenReturn((Object)patch);
        Patch result = this.patchManager.getPatchById(id);
        Assert.assertSame((Object)patch, (Object)result);
    }

    @Test
    public void testFindPatchWhenRevisionSourceStartsWithUploadSpace() throws Exception {
        Integer id = 3;
        CrucibleRevision revision = new CrucibleRevision("UPLOAD::3", null, id + ":4:5:6", "name", new Date());
        Patch patch = new Patch();
        Mockito.when((Object)this.patchDAO.getPatchById((Integer)org.mockito.Matchers.eq((Object)id))).thenReturn((Object)patch);
        Patch result = this.patchManager.findPatch(revision);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testFindPatchWhenRevisionSourceStartsWithPatchSpace() throws Exception {
        Integer id = 3;
        CrucibleRevision revision = new CrucibleRevision("PATCH::3", null, id + ":4:F", "name", new Date());
        Patch patch = new Patch();
        Mockito.when((Object)this.patchDAO.getPatchById((Integer)org.mockito.Matchers.eq((Object)id))).thenReturn((Object)patch);
        Patch result = this.patchManager.findPatch(revision);
        Assert.assertSame((Object)patch, (Object)result);
    }

    @Test
    public void testFindReviewPatches() throws Exception {
        Review review = new Review();
        Patch patch1 = new Patch();
        Patch patch2 = new Patch();
        ArrayList patches = Lists.newArrayList((Object[])new Patch[]{patch1, patch2});
        Mockito.when((Object)this.patchDAO.findReviewPatches((Review)org.mockito.Matchers.eq((Object)review))).thenReturn((Object)patches);
        List result = this.patchManager.findReviewPatches(review);
        Assert.assertSame((Object)patches, (Object)result);
    }

    @Test
    public void testDeleteReviewPatches() throws Exception {
        Review review = new Review();
        Patch patch1 = new Patch();
        Patch patch2 = new Patch();
        ArrayList patches = Lists.newArrayList((Object[])new Patch[]{patch1, patch2});
        Mockito.when((Object)this.patchDAO.findReviewPatches((Review)org.mockito.Matchers.eq((Object)review))).thenReturn((Object)patches);
        this.patchManager.deleteReviewPatches(review);
        ((PatchDAO)Mockito.verify((Object)this.patchDAO, (VerificationMode)VerificationModeFactory.times((int)1))).deleteReviewPatches((Review)org.mockito.Matchers.eq((Object)review));
    }

    @Test
    public void testTransferPatchToExistingSourceWhenExistingPatchIsNotAnchored() throws Exception {
        Patch patch = new Patch();
        patch.setAnchored(true);
        Patch existingPatch = new Patch();
        existingPatch.setAnchored(false);
        PatchSource existingSource = (PatchSource)Mockito.mock(PatchSource.class);
        Mockito.when((Object)this.patchDAO.getPatchIdsForSource(org.mockito.Matchers.anyString())).thenReturn(Collections.singleton(123));
        Mockito.when((Object)this.patchDAO.getPatchById(Integer.valueOf(123))).thenReturn((Object)existingPatch);
        try {
            this.patchManager.transferPatchToExistingSource(patch, existingSource);
            Assert.fail((String)"Expected a PatchException");
        }
        catch (PatchException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.equalTo((Object)"Cannot append to an unanchored patch."));
        }
    }

    @Test
    public void testTransferPatchToExistingSourceWhenAnchorSourcesMismatch() throws Exception {
        Patch patch = new Patch();
        patch.setAnchored(true);
        patch.setAnchorSource("some");
        Patch existingPatch = new Patch();
        existingPatch.setAnchored(true);
        existingPatch.setAnchorSource("some2");
        PatchSource existingSource = (PatchSource)Mockito.mock(PatchSource.class);
        Mockito.when((Object)this.patchDAO.getPatchIdsForSource(org.mockito.Matchers.anyString())).thenReturn(Collections.singleton(123));
        Mockito.when((Object)this.patchDAO.getPatchById(Integer.valueOf(123))).thenReturn((Object)existingPatch);
        try {
            this.patchManager.transferPatchToExistingSource(patch, existingSource);
            Assert.fail((String)"Expected a PatchException");
        }
        catch (PatchException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.equalTo((Object)"Cannot append to a patch anchored to a different repository."));
        }
    }
}

