/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model.managers;

import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fecru.user.FecruUserDAO;
import com.cenqua.crucible.hibernate.CurrentSessionProvider;
import com.cenqua.crucible.model.LogItem;
import com.cenqua.crucible.model.PermissionScheme;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.dao.Generators;
import com.cenqua.crucible.model.dao.HibernatePermissionSchemeDAO;
import com.cenqua.crucible.model.dao.HibernateProjectDAO;
import com.cenqua.crucible.model.dao.HibernateReviewDAO;
import com.cenqua.crucible.model.managers.LogItemBuilder;
import com.cenqua.crucible.model.managers.LogItemManager;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.transaction.TransactionConfiguration;
import org.springframework.transaction.annotation.Transactional;

@TransactionConfiguration(defaultRollback=true)
@ContextConfiguration
@Transactional
@RunWith(value=SpringJUnit4ClassRunner.class)
public class DefaultLogItemManagerTest {
    @Autowired
    private HibernateReviewDAO reviewDAO;
    @Autowired
    private FecruUserDAO userDAO;
    @Autowired
    private HibernateProjectDAO projectDAO;
    @Autowired
    private HibernatePermissionSchemeDAO permissionSchemeDAO;
    @Autowired
    private CurrentSessionProvider currentSessionProvider;
    @Autowired
    private LogItemManager logItemManager;
    private PermissionScheme permissionScheme;
    private Project project;
    private FecruUser user1;
    private Review review1;

    @Before
    public void setUp() throws Exception {
        this.permissionScheme = Generators.generatePermissionScheme();
        this.permissionSchemeDAO.add(this.permissionScheme);
        this.project = Generators.generateProject(this.permissionScheme);
        this.projectDAO.add(this.project);
        this.user1 = Generators.generateUser();
        this.userDAO.create(this.user1);
        this.review1 = Generators.generateReview(this.project, this.user1);
        this.reviewDAO.add(this.review1);
    }

    @Test
    public void testGetLogItemsByIds() throws Exception {
        LogItem logItem1 = LogItemBuilder.buildReviewCreated((Review)this.review1, (FecruUser)this.user1);
        this.logItemManager.addLogItem(logItem1);
        LogItem logItem2 = LogItemBuilder.buildReviewCompleted((Review)this.review1, (FecruUser)this.user1);
        this.logItemManager.addLogItem(logItem2);
        LogItem logItem3 = LogItemBuilder.buildReviewUncompleted((Review)this.review1, (FecruUser)this.user1);
        this.logItemManager.addLogItem(logItem3);
        List result = this.logItemManager.getLogItemsByIds((Collection)ImmutableList.of((Object)logItem1.getId(), (Object)logItem2.getId()));
        Assert.assertThat((Object)Iterables.transform((Iterable)result, (Function)LogItem.TO_ID), (Matcher)Matchers.containsInAnyOrder((Object[])new Integer[]{logItem1.getId(), logItem2.getId()}));
    }
}

