/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model.managers;

import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fecru.user.FecruUserDAO;
import com.cenqua.crucible.model.Comment;
import com.cenqua.crucible.model.PermissionScheme;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.dao.Generators;
import com.cenqua.crucible.model.dao.HibernatePermissionSchemeDAO;
import com.cenqua.crucible.model.dao.HibernateProjectDAO;
import com.cenqua.crucible.model.dao.HibernateReviewDAO;
import com.cenqua.crucible.model.managers.DefaultCommentManager;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.transaction.TransactionConfiguration;
import org.springframework.transaction.annotation.Transactional;

@TransactionConfiguration(defaultRollback=true)
@ContextConfiguration
@Transactional
@RunWith(value=SpringJUnit4ClassRunner.class)
public class DefaultCommentManagerTest {
    @Autowired
    private HibernateReviewDAO reviewDAO;
    @Autowired
    private FecruUserDAO userDAO;
    @Autowired
    private HibernateProjectDAO projectDAO;
    @Autowired
    private HibernatePermissionSchemeDAO permissionSchemeDAO;
    @Autowired
    private DefaultCommentManager commentManager;
    private PermissionScheme permissionScheme;
    private Project project;
    private FecruUser user1;
    private Review review1;

    @Before
    public void setUp() throws Exception {
        this.permissionScheme = Generators.generatePermissionScheme();
        this.permissionSchemeDAO.add(this.permissionScheme);
        this.project = Generators.generateProject(this.permissionScheme);
        this.projectDAO.add(this.project);
        this.user1 = Generators.generateUser();
        this.userDAO.create(this.user1);
        this.review1 = Generators.generateReview(this.project, this.user1);
        this.reviewDAO.add(this.review1);
    }

    @Test
    public void testGetByIds() throws Exception {
        Comment comment1 = this.commentManager.createComment("comment1", this.review1, this.user1);
        Comment comment2 = this.commentManager.createComment("comment2", this.review1, this.user1);
        Comment comment3 = this.commentManager.createComment("comment3", this.review1, this.user1);
        List result = this.commentManager.getByIds((Collection)ImmutableList.of((Object)comment1.getId(), (Object)comment2.getId()));
        Assert.assertThat((Object)Iterables.transform((Iterable)result, (Function)Comment.TO_ID), (Matcher)Matchers.containsInAnyOrder((Object[])new Integer[]{comment1.getId(), comment2.getId()}));
    }
}

