/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model.managers;

import com.atlassian.crucible.actions.search.comment.CommentSearchData;
import com.atlassian.crucible.event.CommentUpdatedEventImpl;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.model.Comment;
import com.cenqua.crucible.model.CrucibleRevision;
import com.cenqua.crucible.model.FRXComment;
import com.cenqua.crucible.model.FileRevisionExtraInfo;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.discussion.DiscussionClause;
import com.cenqua.crucible.model.discussion.DiscussionClauses;
import com.cenqua.crucible.model.managers.CommentManager;
import com.cenqua.crucible.model.managers.FRXCommentManager;
import com.cenqua.crucible.model.managers.FRXManager;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.model.managers.SecureProjectManager;
import com.cenqua.crucible.model.managers.UnreadManager;
import com.cenqua.crucible.util.UseTestSpringContextTestCase;
import com.cenqua.dbutils.ModelUtils;
import com.cenqua.fisheye.rep.TestFishEyeInstances;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;

public class CommentManagerTest
extends UseTestSpringContextTestCase {
    private Project project;
    private Project otherProject;
    Review review;
    Review review2;
    Review review3;
    private FecruUser otherUser;
    private CommentManager commentManager;

    @Before
    public void setUp() throws Exception {
        TestFishEyeInstances.loadSanity1();
        ModelUtils mu = new ModelUtils();
        this.commentManager = ModelUtils.getCommentManager();
        HibernateUtil.beginTransaction();
        this.review = ModelUtils.createBlankTestReview("testreview1");
        this.review2 = ModelUtils.createBlankTestReview("testreview2");
        this.project = ModelUtils.getProjectManager().getDefaultProject();
        this.otherProject = ModelUtils.getProjectManager().createProject("project 2", "PROJ2");
        this.review2.setProject(this.otherProject);
        this.otherUser = ModelUtils.makeAndSaveUser("otheruser");
        this.review3 = ModelUtils.createBlankTestReview("Review_with_comments_attached.");
        ModelUtils.getReviewManager().addReviewer(this.review3, this.otherUser);
        Comment c1 = this.commentManager.createComment("foo", this.review3, this.review3.getCreator());
        Comment c11 = this.commentManager.createComment("foo", this.review3, this.review3.getCreator());
        c11.setDraft(true);
        Comment c111 = this.commentManager.createComment("foo", this.review3, this.review3.getCreator());
        c111.setDeleted(true);
        Comment c1111 = this.commentManager.createComment("foo", this.review3, this.review3.getCreator());
        Comment c1112 = this.commentManager.createComment("foo", this.review3, this.otherUser);
        Comment c112 = this.commentManager.createComment("foo", this.review3, this.review3.getCreator());
        Comment c12 = this.commentManager.createComment("foo", this.review3, this.review3.getCreator());
        c1.addComment(c11);
        c1.addComment(c12);
        c11.setReplyToComment(c1);
        c11.addComment(c111);
        c11.addComment(c112);
        c111.setReplyToComment(c11);
        c111.addComment(c1111);
        c111.addComment(c1112);
        CrucibleRevision fr = ModelUtils.createCrucibleRevision("source", "path", "revision", "revDisplayName", new Date());
        FileRevisionExtraInfo frx = FRXManager.createAndAddFRX((CrucibleRevision)fr, (Review)this.review3);
        Comment frxcomment = this.commentManager.createComment("FRX level comment", this.review3, this.review3.getCreator());
        FRXComment rc = FRXCommentManager.createAndAddFrxComment((Comment)frxcomment, (FileRevisionExtraInfo)frx);
        frx.addFrxComment(rc);
        this.review3.addComment(c1);
        HibernateUtil.commitTransaction();
    }

    @After
    public void tearDown() throws Exception {
        HibernateUtil.commitTransaction();
        HibernateUtil.closeSession();
        TestFishEyeInstances.stop();
    }

    protected void setUpCalendar() {
        Comment c;
        int i;
        HibernateUtil.beginTransaction();
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        cal.set(2008, 1, 20, 0, 0, 0);
        for (i = 0; i < 3; ++i) {
            c = this.commentManager.createComment("test comment Sunday " + i, this.review, this.review.getAuthor());
            ((Calendar)cal).add(12, 1);
            c.setCreateDate(cal.getTime());
            this.review.addComment(c);
        }
        ((Calendar)cal).add(6, 1);
        for (i = 0; i < 3; ++i) {
            c = this.commentManager.createComment("test defect Monday " + i, this.review, this.review.getAuthor());
            ((Calendar)cal).add(12, 1);
            c.setDefectRaised(true);
            c.setCreateDate(cal.getTime());
            this.review.addComment(c);
        }
        for (i = 0; i < 5; ++i) {
            c = this.commentManager.createComment("test comment Monday " + i, this.review, this.review.getAuthor());
            ((Calendar)cal).add(12, 1);
            c.setCreateDate(cal.getTime());
            this.review.addComment(c);
        }
        ((Calendar)cal).add(6, 1);
        for (i = 0; i < 6; ++i) {
            c = this.commentManager.createComment("test comment Tuesday " + i, this.review, this.review.getAuthor());
            ((Calendar)cal).add(12, 1);
            c.setCreateDate(cal.getTime());
            this.review.addComment(c);
        }
        for (i = 0; i < 6; ++i) {
            c = this.commentManager.createComment("test comment Tuesday " + i, this.review2, this.review2.getAuthor());
            ((Calendar)cal).add(12, 1);
            c.setCreateDate(cal.getTime());
            this.review.addComment(c);
        }
        ((Calendar)cal).add(6, 1);
        for (i = 0; i < 12; ++i) {
            c = this.commentManager.createComment("test comment Wednesday " + i, this.review, this.review.getAuthor());
            ((Calendar)cal).add(12, 1);
            c.setCreateDate(cal.getTime());
            this.review.addComment(c);
        }
        ((Calendar)cal).add(6, 1);
        for (i = 0; i < 9; ++i) {
            c = this.commentManager.createComment("test comment Thursday " + i, this.review, this.review.getAuthor());
            ((Calendar)cal).add(12, 1);
            c.setCreateDate(cal.getTime());
            this.review.addComment(c);
        }
        ((Calendar)cal).add(6, 1);
        for (i = 0; i < 8; ++i) {
            c = this.commentManager.createComment("test defect Friday " + i, this.review, this.review.getAuthor());
            ((Calendar)cal).add(12, 1);
            c.setDefectRaised(true);
            c.setCreateDate(cal.getTime());
            this.review.addComment(c);
        }
        for (i = 0; i < 15; ++i) {
            c = this.commentManager.createComment("test comment Friday " + i, this.review, this.review.getAuthor());
            ((Calendar)cal).add(12, 1);
            c.setCreateDate(cal.getTime());
            this.review.addComment(c);
        }
        ((Calendar)cal).add(6, 1);
        for (i = 0; i < 1; ++i) {
            c = this.commentManager.createComment("test comment Saturday " + i, this.review, this.review.getAuthor());
            ((Calendar)cal).add(12, 1);
            c.setCreateDate(cal.getTime());
            this.review.addComment(c);
        }
        ((Calendar)cal).add(6, 1);
        for (i = 0; i < 3; ++i) {
            c = this.commentManager.createComment("test comment Following Monday " + i, this.review, this.review.getAuthor());
            ((Calendar)cal).add(12, 1);
            c.setCreateDate(cal.getTime());
            this.review.addComment(c);
        }
        ((Calendar)cal).add(6, 1);
        for (i = 0; i < 23; ++i) {
            c = this.commentManager.createComment("test comment Following Monday " + i, this.review, this.review.getAuthor());
            ((Calendar)cal).add(12, 1);
            c.setCreateDate(cal.getTime());
            this.review.addComment(c);
        }
        HibernateUtil.commitTransaction();
    }

    @Test
    public void testFRXComments() {
        HibernateUtil.beginTransaction();
        Date createDate = new Date();
        CrucibleRevision fr = ModelUtils.createCrucibleRevision("source", "foo", "revision", "revDisplayName", createDate);
        HibernateUtil.currentSession().save((Object)fr);
        HibernateUtil.commitTransaction();
        HibernateUtil.beginTransaction();
        FileRevisionExtraInfo frx = FRXManager.createAndAddFRX((CrucibleRevision)fr, (Review)this.review);
        FecruUser author = this.review.getAuthor();
        Comment gc = this.commentManager.createComment("message", this.review, author);
        this.review.addComment(gc);
        HibernateUtil.commitTransaction();
        HibernateUtil.beginTransaction();
        Comment fc = this.commentManager.createComment("file-level comment", this.review, author);
        FRXComment rc = FRXCommentManager.createAndAddFrxComment((Comment)fc, (FileRevisionExtraInfo)frx);
        frx.addFrxComment(rc);
        HibernateUtil.commitTransaction();
        Assert.assertThat((Object)this.commentManager.getFrxCommentCount(frx), (Matcher)Matchers.equalTo((Object)1));
        HibernateUtil.beginTransaction();
        Comment reply = this.commentManager.createComment("reply to review comment", this.review, author);
        fc.addComment(reply);
        HibernateUtil.commitTransaction();
        HibernateUtil.beginTransaction();
        this.commentManager.createComment("review comment", this.review, author);
        Comment reply2 = this.commentManager.createComment("reply2 to review comment", this.review, author);
        fc.addComment(reply2);
        HibernateUtil.commitTransaction();
        Assert.assertThat((Object)this.commentManager.getFrxCommentCount(frx), (Matcher)Matchers.equalTo((Object)3));
        Assert.assertThat((Object)this.commentManager.getReviewCommentCount(this.review, author, Boolean.valueOf(false), null, null, null), (Matcher)Matchers.equalTo((Object)5));
        Assert.assertThat((Object)this.commentManager.getReviewFrxsCommentCount(this.review, author, Boolean.valueOf(false), null, null), (Matcher)Matchers.equalTo((Object)3));
        ModelUtils.getReviewManager().addReviewer(this.review, this.otherUser);
        UnreadManager urm = new UnreadManager();
        HibernateUtil.beginTransaction();
        urm.markAsRead(this.otherUser, reply);
        HibernateUtil.commitTransaction();
        Assert.assertTrue((boolean)reply.isRead(this.otherUser));
    }

    @Test
    public void testCountCommentsOnDay() {
        this.setUpCalendar();
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        cal.set(2008, 1, 21, 0, 0, 0);
        Date day = cal.getTime();
        HibernateUtil.beginTransaction();
        long count = this.commentManager.countCommentsOnDay(day, false, this.project);
        Assert.assertThat((Object)count, (Matcher)Matchers.equalTo((Object)5L));
        ((Calendar)cal).add(6, 1);
        day = cal.getTime();
        count = this.commentManager.countCommentsOnDay(day, false, this.project);
        Assert.assertThat((Object)count, (Matcher)Matchers.equalTo((Object)6L));
        ((Calendar)cal).add(6, 1);
        day = cal.getTime();
        count = this.commentManager.countCommentsOnDay(day, false, this.project);
        Assert.assertThat((Object)count, (Matcher)Matchers.equalTo((Object)12L));
        ((Calendar)cal).add(6, 1);
        day = cal.getTime();
        count = this.commentManager.countCommentsOnDay(day, false, this.project);
        Assert.assertThat((Object)count, (Matcher)Matchers.equalTo((Object)9L));
        ((Calendar)cal).add(6, 1);
        day = cal.getTime();
        count = this.commentManager.countCommentsOnDay(day, false, this.project);
        Assert.assertThat((Object)count, (Matcher)Matchers.equalTo((Object)15L));
        ((Calendar)cal).add(6, 1);
        day = cal.getTime();
        count = this.commentManager.countCommentsOnDay(day, false, this.project);
        Assert.assertThat((Object)count, (Matcher)Matchers.equalTo((Object)1L));
        ((Calendar)cal).add(6, 1);
        day = cal.getTime();
        count = this.commentManager.countCommentsOnDay(day, false, this.project);
        Assert.assertThat((Object)count, (Matcher)Matchers.equalTo((Object)3L));
        cal.set(2008, 1, 21);
        day = cal.getTime();
        count = this.commentManager.countCommentsOnDay(day, true, this.project);
        Assert.assertThat((Object)count, (Matcher)Matchers.equalTo((Object)3L));
        ((Calendar)cal).add(6, 4);
        day = cal.getTime();
        count = this.commentManager.countCommentsOnDay(day, true, this.project);
        Assert.assertThat((Object)count, (Matcher)Matchers.equalTo((Object)8L));
        cal.set(2008, 1, 22);
        day = cal.getTime();
        count = this.commentManager.countCommentsOnDay(day, false, this.otherProject);
        Assert.assertThat((Object)count, (Matcher)Matchers.equalTo((Object)6L));
        HibernateUtil.commitTransaction();
    }

    @Test
    public void testCommentBrowser() {
        HibernateUtil.beginTransaction();
        Comment root = (Comment)this.review3.getComments().iterator().next();
        Assert.assertTrue((boolean)this.commentManager.comments(root).where(DiscussionClauses.not((DiscussionClause)DiscussionClauses.isTrue())).isEmpty());
        Assert.assertThat((Object)this.commentManager.comments(root).where(DiscussionClauses.and((DiscussionClause)DiscussionClauses.isTrue(), (DiscussionClause)DiscussionClauses.not((DiscussionClause)DiscussionClauses.isTrue()), (DiscussionClause[])new DiscussionClause[0])).count(), (Matcher)Matchers.equalTo((Object)0));
        Assert.assertThat((Object)this.commentManager.comments(root).count(), (Matcher)Matchers.equalTo((Object)7));
        Assert.assertThat((Object)this.commentManager.comments(root).where(DiscussionClauses.not((DiscussionClause)DiscussionClauses.draft())).count(), (Matcher)Matchers.equalTo((Object)6));
        Assert.assertThat((Object)this.commentManager.comments(root).where(DiscussionClauses.not((DiscussionClause)DiscussionClauses.draft())).prune().count(), (Matcher)Matchers.equalTo((Object)2));
        Assert.assertThat((Object)this.commentManager.comments(root).where(DiscussionClauses.not((DiscussionClause)DiscussionClauses.deleted())).prune().count(), (Matcher)Matchers.equalTo((Object)4));
        List result = this.commentManager.comments(root).where(DiscussionClauses.depth((int)0)).collect();
        Assert.assertThat((Object)result.size(), (Matcher)Matchers.equalTo((Object)1));
        Assert.assertThat(result.get(0), (Matcher)Matchers.equalTo((Object)root));
        result = this.commentManager.comments(root).where(DiscussionClauses.depth((int)1)).collect();
        Assert.assertThat((Object)result.size(), (Matcher)Matchers.equalTo((Object)2));
        Assert.assertThat((Object)((Comment)result.get(0)).getReplyToComment(), (Matcher)Matchers.equalTo((Object)root));
        Assert.assertThat((Object)((Comment)result.get(1)).getReplyToComment(), (Matcher)Matchers.equalTo((Object)root));
        HibernateUtil.commitTransaction();
    }

    @Test
    public void testFRXCommentBrowser() {
        HibernateUtil.beginTransaction();
        FileRevisionExtraInfo frx = (FileRevisionExtraInfo)this.review3.getFrxs().iterator().next();
        Assert.assertThat((Object)this.commentManager.comments(frx).count(), (Matcher)Matchers.equalTo((Object)1));
        HibernateUtil.commitTransaction();
    }

    @Test
    public void testReviewCommentBrowser() {
        HibernateUtil.beginTransaction();
        Assert.assertThat((Object)this.commentManager.comments(this.review3).count(), (Matcher)Matchers.equalTo((Object)8));
        Assert.assertThat((Object)this.commentManager.comments(this.review3).excludeInlineComments().excludeFRXComments().count(), (Matcher)Matchers.equalTo((Object)7));
        Assert.assertThat((Object)this.commentManager.comments(this.review3).excludeInlineComments().excludeReviewComments().count(), (Matcher)Matchers.equalTo((Object)1));
        Assert.assertThat((Object)this.commentManager.comments(this.review3).excludeReviewComments().excludeFRXComments().count(), (Matcher)Matchers.equalTo((Object)0));
        HibernateUtil.commitTransaction();
    }

    @Test
    public void testUnreadSelection() {
        HibernateUtil.beginTransaction();
        Assert.assertThat((Object)this.commentManager.comments(this.review3).where(DiscussionClauses.read((FecruUser)this.otherUser)).count(), (Matcher)Matchers.equalTo((Object)1));
        Assert.assertThat((Object)this.commentManager.comments(this.review3).where(DiscussionClauses.unread((FecruUser)this.otherUser)).count(), (Matcher)Matchers.equalTo((Object)7));
        HibernateUtil.commitTransaction();
    }

    @Test
    public void testAuthorSelection() {
        HibernateUtil.beginTransaction();
        Assert.assertThat((Object)this.commentManager.comments(this.review3).where(DiscussionClauses.author((FecruUser)this.otherUser)).count(), (Matcher)Matchers.equalTo((Object)1));
        HibernateUtil.commitTransaction();
    }

    @Test
    public void testSearchCommentByReviewStateName() throws Exception {
        String state1 = "Approval";
        String state2 = "Closed";
        Principal.SuperUser principal = Principal.SuperUser.INSTANCE;
        SecureProjectManager secureProjectManager = (SecureProjectManager)Mockito.mock(SecureProjectManager.class);
        ImmutableList projects = ImmutableList.copyOf((Collection)Sets.newHashSet((Object[])new Project[]{this.review.getProject(), this.review2.getProject(), this.review3.getProject()}));
        Mockito.when((Object)secureProjectManager.getVisibleProjects((Principal)principal)).thenReturn((Object)projects);
        this.commentManager = ModelUtils.getCommentManager(secureProjectManager);
        HibernateUtil.beginTransaction();
        Comment comment1 = this.commentManager.createComment("comment 1", this.review, this.review.getAuthor());
        Comment comment2 = this.commentManager.createComment("comment 2", this.review2, this.review2.getAuthor());
        Comment comment3 = this.commentManager.createComment("comment 3", this.review3, this.review3.getAuthor());
        this.review.setStateName(state1);
        this.review.addComment(comment1);
        this.review2.setStateName(state2);
        this.review2.addComment(comment2);
        this.review3.addComment(comment3);
        HibernateUtil.commitTransaction();
        CommentSearchData searchData = new CommentSearchData((ReviewManager)this.reviewManager);
        searchData.setState(new String[]{state1, state2});
        List comments = this.commentManager.searchComments((Principal)principal, searchData, "comment");
        Assert.assertThat((Object)comments, (Matcher)Matchers.contains((Object[])new Comment[]{comment1, comment2}));
    }

    @Test
    public void testSearchCommentByUnknownPermaId() throws Exception {
        Principal.SuperUser principal = Principal.SuperUser.INSTANCE;
        SecureProjectManager secureProjectManager = (SecureProjectManager)Mockito.mock(SecureProjectManager.class);
        ImmutableList projects = ImmutableList.copyOf((Collection)Sets.newHashSet((Object[])new Project[]{this.review.getProject(), this.review2.getProject(), this.review3.getProject()}));
        Mockito.when((Object)secureProjectManager.getVisibleProjects((Principal)principal)).thenReturn((Object)projects);
        this.commentManager = ModelUtils.getCommentManager(secureProjectManager);
        HibernateUtil.beginTransaction();
        Comment comment1 = this.commentManager.createComment("comment 1", this.review, this.review.getAuthor());
        this.review.addComment(comment1);
        HibernateUtil.commitTransaction();
        CommentSearchData searchData = new CommentSearchData((ReviewManager)this.reviewManager);
        searchData.setPermaId(this.review.getPermaId());
        List comments = this.commentManager.searchComments((Principal)principal, searchData, "comment");
        Assert.assertThat((Object)comments, (Matcher)Matchers.contains((Object[])new Comment[]{comment1}));
        searchData.setPermaId(this.review.getPermaId() + "123");
        comments = this.commentManager.searchComments((Principal)principal, searchData, "comment");
        Assert.assertThat((Object)comments, (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }

    @Test
    public void testPublishingCommentsPublishesThemInRightOrder() throws Exception {
        String actioner = "actioner";
        String timestamp = "timestamp";
        EventPublisher eventPublisher = (EventPublisher)Mockito.mock(EventPublisher.class);
        this.commentManager = ModelUtils.getCommentManager((SecureProjectManager)Mockito.mock(SecureProjectManager.class), eventPublisher);
        HibernateUtil.beginTransaction();
        FecruUser author = this.review.getAuthor();
        Comment comment1 = this.createDraftComment(author, this.review, "comment 1");
        Comment comment2 = this.createDraftComment(author, this.review, "comment 2");
        Comment comment3 = this.createDraftComment(author, this.review, "comment 3");
        Comment comment4 = this.createDraftComment(author, this.review, "comment 4");
        comment3.setReplyToComment(comment1);
        this.review.addComment(comment1);
        this.review.addComment(comment2);
        this.review.addComment(comment4);
        HibernateUtil.commitTransaction();
        HibernateUtil.clearSession();
        HibernateUtil.beginTransaction();
        this.review = this.reviewManager.getReviewById(this.review.getId());
        this.commentManager.publishDraftCommentsAndAnnounce(this.review, author);
        HibernateUtil.commitTransaction();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{eventPublisher});
        Assert.assertTrue((String)"All comments must be published", (boolean)this.review.getCommentsAndReplies().stream().allMatch(comment -> !comment.isDraft()));
        ((EventPublisher)inOrder.verify((Object)eventPublisher)).publish(org.mockito.Matchers.refEq((Object)new CommentUpdatedEventImpl(this.review.getPermId(), null, comment1.getPermId(), comment1.getMessage(), true, false, this.review.getType()), (String[])new String[]{"actioner", "timestamp"}));
        ((EventPublisher)inOrder.verify((Object)eventPublisher)).publish(org.mockito.Matchers.refEq((Object)new CommentUpdatedEventImpl(this.review.getPermId(), null, comment3.getPermId(), comment3.getMessage(), true, false, this.review.getType()), (String[])new String[]{"actioner", "timestamp"}));
        ((EventPublisher)inOrder.verify((Object)eventPublisher)).publish(org.mockito.Matchers.refEq((Object)new CommentUpdatedEventImpl(this.review.getPermId(), null, comment2.getPermId(), comment2.getMessage(), true, false, this.review.getType()), (String[])new String[]{"actioner", "timestamp"}));
        ((EventPublisher)inOrder.verify((Object)eventPublisher)).publish(org.mockito.Matchers.refEq((Object)new CommentUpdatedEventImpl(this.review.getPermId(), null, comment4.getPermId(), comment4.getMessage(), true, false, this.review.getType()), (String[])new String[]{"actioner", "timestamp"}));
    }

    private Comment createDraftComment(FecruUser author, Review review, String message) {
        Comment comment = this.commentManager.createComment(message, review, author);
        comment.setDraft(true);
        return comment;
    }
}

