/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model.managers;

import com.atlassian.fugue.Option;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.model.CrucibleRevision;
import com.cenqua.crucible.model.StoredPath;
import com.cenqua.crucible.model.managers.FileRevisionManager;
import com.cenqua.crucible.revision.managers.CrucibleRevisionCreator;
import com.cenqua.crucible.revision.source.DisplayRevisionMapper;
import com.cenqua.crucible.spi.MultithreadedServiceTestBase;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.google.common.collect.ImmutableSet;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.hibernate.Session;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class CRUC1929CrucibleRevisionTest
extends MultithreadedServiceTestBase {
    @Override
    public MultithreadedServiceTestBase.Worker getWorker() {
        return new MultithreadedServiceTestBase.Worker(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void runImpl() throws Exception {
                DisplayRevisionMapper mapper = new DisplayRevisionMapper(){

                    public String getDisplayRevision(String revision) {
                        return revision;
                    }
                };
                long t0 = System.currentTimeMillis();
                try {
                    HibernateUtil.beginTransaction();
                    this.log("creating cr...");
                    CrucibleRevision cr1 = FileRevisionManager.createRevision((String)"cvs", (String)"test/CleanSweeper.java", (String)"1.1", (String)"1.1", (Date)new Date());
                    ImmutableSet revs = ImmutableSet.of((Object)new RevInfoKey(new Path((CharSequence)"test/CleanSweeper.java"), "1.1"), (Object)new RevInfoKey(new Path((CharSequence)"test/CleanSweeper.java"), "1.2"), (Object)new RevInfoKey(new Path((CharSequence)"test/CleanSweeperTest.java"), "1.1"));
                    FileRevisionManager.createRevisions((String)"cvs", (Set)revs, (DisplayRevisionMapper)mapper, (Date)new Date(), (Option)Option.none());
                    long t1 = System.currentTimeMillis();
                    Thread.sleep(Math.max(0L, 10000L - (t1 - t0)));
                    this.log("committing...");
                    HibernateUtil.commitTransaction();
                    this.log("cr " + cr1.getId() + " " + cr1.getSourceName() + " " + cr1.getStoredPath() + " " + cr1.getStoredPath().getId() + " " + cr1.getRevision());
                }
                finally {
                    HibernateUtil.closeSession();
                }
            }
        };
    }

    @Test
    @Ignore
    public void testEriksProblemNewPath() throws Exception {
        try {
            Assert.assertEquals((long)0L, (long)HibernateUtil.currentSession().createCriteria(StoredPath.class).list().size());
            this.subtestCreateRevisionInThreads();
        }
        finally {
            HibernateUtil.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void subtestCreateRevisionInThreads() throws Exception {
        try {
            this.startWorkers();
            List allPaths = HibernateUtil.currentSession().createCriteria(StoredPath.class).list();
            System.out.println(allPaths);
            Assert.assertEquals((long)2L, (long)allPaths.size());
            StoredPath path1 = CrucibleRevisionCreator.findStoredPath((Session)HibernateUtil.currentSession(), (String)"test/CleanSweeper.java");
            StoredPath path2 = CrucibleRevisionCreator.findStoredPath((Session)HibernateUtil.currentSession(), (String)"test/CleanSweeperTest.java");
            Assert.assertNotNull((Object)path1);
            Assert.assertNotNull((Object)path2);
            List allRevs = HibernateUtil.currentSession().createCriteria(CrucibleRevision.class).list();
            System.out.println(allRevs);
            Assert.assertEquals((long)3L, (long)allRevs.size());
            CrucibleRevision rev1 = CrucibleRevisionCreator.findRevision((Session)HibernateUtil.currentSession(), (String)"cvs", (String)"test/CleanSweeper.java", (String)"1.1");
            CrucibleRevision rev2 = CrucibleRevisionCreator.findRevision((Session)HibernateUtil.currentSession(), (String)"cvs", (String)"test/CleanSweeper.java", (String)"1.2");
            CrucibleRevision rev3 = CrucibleRevisionCreator.findRevision((Session)HibernateUtil.currentSession(), (String)"cvs", (String)"test/CleanSweeperTest.java", (String)"1.1");
            Assert.assertNotNull((Object)rev1);
            Assert.assertEquals((Object)"cvs", (Object)rev1.getSourceName());
            Assert.assertEquals((Object)"1.1", (Object)rev1.getRevision());
            Assert.assertEquals((Object)"test/CleanSweeper.java", (Object)rev1.getPath());
            Assert.assertEquals((Object)path1.getId(), (Object)rev1.getStoredPath().getId());
            Assert.assertNotNull((Object)rev2);
            Assert.assertEquals((Object)"cvs", (Object)rev2.getSourceName());
            Assert.assertEquals((Object)"1.2", (Object)rev2.getRevision());
            Assert.assertEquals((Object)"test/CleanSweeper.java", (Object)rev2.getPath());
            Assert.assertEquals((Object)path1.getId(), (Object)rev2.getStoredPath().getId());
            Assert.assertNotNull((Object)rev3);
            Assert.assertEquals((Object)"cvs", (Object)rev3.getSourceName());
            Assert.assertEquals((Object)"1.1", (Object)rev3.getRevision());
            Assert.assertEquals((Object)"test/CleanSweeperTest.java", (Object)rev3.getPath());
            Assert.assertEquals((Object)path2.getId(), (Object)rev3.getStoredPath().getId());
        }
        finally {
            HibernateUtil.closeSession();
        }
    }

    @Test
    public void testRevisionAvailableByKey() {
        try {
            CrucibleRevision cr = CrucibleRevisionCreator.createRevision((Session)HibernateUtil.currentSession(), (String)"cvs", null, (String)"test/CleanSweeper.java", (String)"1.2", (String)"xxx", (Date)new Date(), null, null);
            Assert.assertNotNull((Object)cr);
            cr = CrucibleRevisionCreator.findRevision((Session)HibernateUtil.currentSession(), (String)"cvs", (String)"test/CleanSweeper.java", (String)"1.2");
            Assert.assertNotNull((Object)cr);
        }
        finally {
            HibernateUtil.closeSession();
        }
    }
}

