/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model.discussion;

import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.model.Comment;
import com.cenqua.crucible.model.discussion.DiscussionClause;
import com.cenqua.crucible.model.discussion.DiscussionClauses;
import java.util.Date;
import junit.framework.TestCase;

public class DiscussionClausesTest
extends TestCase {
    private static final DiscussionClause TRUE = new DiscussionClause(){

        public boolean test(Comment comment, int depth) {
            return true;
        }
    };
    private static final DiscussionClause FALSE = new DiscussionClause(){

        public boolean test(Comment comment, int depth) {
            return false;
        }
    };
    private static final DiscussionClause FORBIDDEN = new DiscussionClause(){

        public boolean test(Comment comment, int depth) {
            throw new AssertionError((Object)"Unexpected invocation.");
        }
    };

    public void testIsTrue() {
        DiscussionClausesTest.assertTrue((boolean)DiscussionClauses.isTrue().test(null, 0));
    }

    public void testAnd() {
        DiscussionClausesTest.assertTrue((boolean)DiscussionClauses.and((DiscussionClause)TRUE, (DiscussionClause)TRUE, (DiscussionClause[])new DiscussionClause[0]).test(null, 0));
        DiscussionClausesTest.assertTrue((boolean)DiscussionClauses.and((DiscussionClause)TRUE, (DiscussionClause)TRUE, (DiscussionClause[])new DiscussionClause[]{TRUE}).test(null, 0));
        DiscussionClausesTest.assertFalse((boolean)DiscussionClauses.and((DiscussionClause)FALSE, (DiscussionClause)FORBIDDEN, (DiscussionClause[])new DiscussionClause[0]).test(null, 0));
        DiscussionClausesTest.assertFalse((boolean)DiscussionClauses.and((DiscussionClause)TRUE, (DiscussionClause)FALSE, (DiscussionClause[])new DiscussionClause[]{FORBIDDEN}).test(null, 0));
        DiscussionClausesTest.assertFalse((boolean)DiscussionClauses.and((DiscussionClause)TRUE, (DiscussionClause)TRUE, (DiscussionClause[])new DiscussionClause[]{FALSE, FORBIDDEN}).test(null, 0));
    }

    public void testOr() {
        DiscussionClausesTest.assertTrue((boolean)DiscussionClauses.or((DiscussionClause)TRUE, (DiscussionClause)FORBIDDEN, (DiscussionClause[])new DiscussionClause[0]).test(null, 0));
        DiscussionClausesTest.assertTrue((boolean)DiscussionClauses.or((DiscussionClause)FALSE, (DiscussionClause)TRUE, (DiscussionClause[])new DiscussionClause[0]).test(null, 0));
        DiscussionClausesTest.assertTrue((boolean)DiscussionClauses.or((DiscussionClause)FALSE, (DiscussionClause)FALSE, (DiscussionClause[])new DiscussionClause[]{TRUE, FORBIDDEN}).test(null, 0));
    }

    public void testNot() {
        DiscussionClausesTest.assertTrue((boolean)DiscussionClauses.not((DiscussionClause)FALSE).test(null, 0));
        DiscussionClausesTest.assertFalse((boolean)DiscussionClauses.not((DiscussionClause)TRUE).test(null, 0));
    }

    public void testHasJira() {
        Comment comment = new Comment();
        DiscussionClausesTest.assertFalse((boolean)DiscussionClauses.hasJira().test(comment, 0));
        comment.setJiraIssueKey("CRUC-123");
        DiscussionClausesTest.assertTrue((boolean)DiscussionClauses.hasJira().test(comment, 0));
    }

    public void testAuthor() {
        FecruUser user1 = new FecruUser("joe");
        FecruUser user2 = new FecruUser("scott");
        Comment comment = new Comment();
        DiscussionClausesTest.assertFalse((boolean)DiscussionClauses.author((FecruUser)user1).test(comment, 0));
        comment.setUser(user1);
        DiscussionClausesTest.assertTrue((boolean)DiscussionClauses.author((FecruUser)user1).test(comment, 0));
        DiscussionClausesTest.assertFalse((boolean)DiscussionClauses.author((FecruUser)user2).test(comment, 0));
    }

    public void testDraft() {
        FecruUser user1 = new FecruUser("joe");
        FecruUser user2 = new FecruUser("scott");
        Comment comment1 = new Comment();
        comment1.setUser(user1);
        comment1.setDraft(true);
        comment1.setDeleted(false);
        Comment comment2 = new Comment();
        comment2.setUser(user2);
        comment2.setDraft(true);
        comment2.setDeleted(true);
        DiscussionClausesTest.assertTrue((boolean)DiscussionClauses.draft().test(comment1, 0));
        DiscussionClausesTest.assertTrue((boolean)DiscussionClauses.draft().test(comment2, 0));
        DiscussionClausesTest.assertTrue((boolean)DiscussionClauses.draft((FecruUser)user1).test(comment1, 0));
        DiscussionClausesTest.assertFalse((boolean)DiscussionClauses.draft((FecruUser)user2).test(comment1, 0));
        DiscussionClausesTest.assertFalse((boolean)DiscussionClauses.draft((FecruUser)user1).test(comment2, 0));
        DiscussionClausesTest.assertTrue((boolean)DiscussionClauses.draft((FecruUser)user2).test(comment2, 0));
    }

    public void testDefect() {
        Comment comment = new Comment();
        DiscussionClausesTest.assertFalse((boolean)DiscussionClauses.defect().test(comment, 0));
        comment.setDefectRaised(true);
        DiscussionClausesTest.assertTrue((boolean)DiscussionClauses.defect().test(comment, 0));
    }

    public void testVisibility() {
        FecruUser joe = new FecruUser("joe");
        FecruUser scott = new FecruUser("scott");
        Comment comment = new Comment();
        comment.setUser(joe);
        DiscussionClausesTest.assertTrue((boolean)DiscussionClauses.visibleTo((FecruUser)joe).test(comment, 0));
        DiscussionClausesTest.assertTrue((boolean)DiscussionClauses.visibleTo((FecruUser)scott).test(comment, 0));
        DiscussionClausesTest.assertTrue((boolean)DiscussionClauses.visibleToAll().test(comment, 0));
        comment.setDraft(true);
        DiscussionClausesTest.assertTrue((boolean)DiscussionClauses.visibleTo((FecruUser)joe).test(comment, 0));
        DiscussionClausesTest.assertFalse((boolean)DiscussionClauses.visibleTo((FecruUser)scott).test(comment, 0));
        DiscussionClausesTest.assertFalse((boolean)DiscussionClauses.visibleToAll().test(comment, 0));
        comment.setDraft(false);
        comment.setDeleted(true);
        DiscussionClausesTest.assertFalse((boolean)DiscussionClauses.visibleTo((FecruUser)joe).test(comment, 0));
        DiscussionClausesTest.assertFalse((boolean)DiscussionClauses.visibleTo((FecruUser)scott).test(comment, 0));
        DiscussionClausesTest.assertFalse((boolean)DiscussionClauses.visibleToAll().test(comment, 0));
    }

    public void testContains() {
        Comment comment = new Comment();
        comment.setMessage("Foo bar.");
        DiscussionClausesTest.assertFalse((boolean)DiscussionClauses.contains((String)"").test(comment, 0));
        DiscussionClausesTest.assertTrue((boolean)DiscussionClauses.contains((String)"^Foo.*").test(comment, 0));
        DiscussionClausesTest.assertTrue((boolean)DiscussionClauses.contains((String)".*[o]{2}.*").test(comment, 0));
        DiscussionClausesTest.assertFalse((boolean)DiscussionClauses.contains((String)".*[o]{3}.*").test(comment, 0));
    }

    public void testCreatedBefore() {
        Comment comment = new Comment();
        Date early = new Date(0L);
        Date late = new Date(1L);
        comment.setCreateDate(late);
        DiscussionClausesTest.assertFalse((boolean)DiscussionClauses.createdBefore((Date)early, (boolean)false).test(comment, 0));
        DiscussionClausesTest.assertFalse((boolean)DiscussionClauses.createdBefore((Date)late, (boolean)false).test(comment, 0));
        DiscussionClausesTest.assertFalse((boolean)DiscussionClauses.createdBefore((Date)early, (boolean)true).test(comment, 0));
        DiscussionClausesTest.assertTrue((boolean)DiscussionClauses.createdBefore((Date)late, (boolean)true).test(comment, 0));
        comment.setCreateDate(early);
        DiscussionClausesTest.assertTrue((boolean)DiscussionClauses.createdBefore((Date)late, (boolean)false).test(comment, 0));
        DiscussionClausesTest.assertTrue((boolean)DiscussionClauses.createdBefore((Date)late, (boolean)true).test(comment, 0));
    }

    public void testCreatedAfter() {
        Comment comment = new Comment();
        Date early = new Date(0L);
        Date late = new Date(1L);
        comment.setCreateDate(late);
        DiscussionClausesTest.assertTrue((boolean)DiscussionClauses.createdAfter((Date)early, (boolean)false).test(comment, 0));
        DiscussionClausesTest.assertFalse((boolean)DiscussionClauses.createdAfter((Date)late, (boolean)false).test(comment, 0));
        DiscussionClausesTest.assertTrue((boolean)DiscussionClauses.createdAfter((Date)early, (boolean)true).test(comment, 0));
        DiscussionClausesTest.assertTrue((boolean)DiscussionClauses.createdAfter((Date)late, (boolean)true).test(comment, 0));
        comment.setCreateDate(early);
        DiscussionClausesTest.assertFalse((boolean)DiscussionClauses.createdAfter((Date)late, (boolean)false).test(comment, 0));
        DiscussionClausesTest.assertFalse((boolean)DiscussionClauses.createdAfter((Date)late, (boolean)true).test(comment, 0));
    }

    public void testDepth() {
        Comment comment = new Comment();
        DiscussionClausesTest.assertTrue((boolean)DiscussionClauses.depth((int)0).test(comment, 0));
        DiscussionClausesTest.assertFalse((boolean)DiscussionClauses.depth((int)0).test(comment, 1));
        DiscussionClausesTest.assertFalse((boolean)DiscussionClauses.depth((int)1).test(comment, 0));
    }
}

