/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model.dao;

import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fecru.user.FecruUserDAO;
import com.cenqua.crucible.model.PermissionScheme;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.StateChangeLog;
import com.cenqua.crucible.model.dao.Generators;
import com.cenqua.crucible.model.dao.HibernatePermissionSchemeDAO;
import com.cenqua.crucible.model.dao.HibernateProjectDAO;
import com.cenqua.crucible.model.dao.HibernateReviewDAO;
import com.cenqua.crucible.model.dao.HibernateStateChangeLogDAO;
import java.util.Date;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.transaction.TransactionConfiguration;
import org.springframework.transaction.annotation.Transactional;

@TransactionConfiguration(defaultRollback=true)
@ContextConfiguration(value={"classpath:/tests-db-spring-context-level3-manager.xml"})
@Transactional
@RunWith(value=SpringJUnit4ClassRunner.class)
@DirtiesContext
public class HibernateStateChangeLogDAOTest {
    @Autowired
    HibernateStateChangeLogDAO stateChangeLogDAO;
    @Autowired
    private HibernateReviewDAO reviewDAO;
    @Autowired
    private FecruUserDAO userDAO;
    @Autowired
    private HibernateProjectDAO projectDAO;
    @Autowired
    private HibernatePermissionSchemeDAO permissionSchemeDAO;
    private PermissionScheme permissionScheme;
    private Project project1;
    private Project project2;
    private FecruUser user1;
    private FecruUser user2;
    private Review review1;
    private Review review2;
    private Review review3;

    @Before
    public void setUp() throws Exception {
        this.permissionScheme = Generators.generatePermissionScheme();
        this.permissionSchemeDAO.add(this.permissionScheme);
        this.project1 = Generators.generateProject(this.permissionScheme, "XXX");
        this.projectDAO.add(this.project1);
        this.project2 = Generators.generateProject(this.permissionScheme, "YYY");
        this.projectDAO.add(this.project2);
        this.user1 = Generators.generateUser();
        this.userDAO.create(this.user1);
        this.user2 = Generators.generateUser();
        this.userDAO.create(this.user2);
        this.review1 = Generators.generateReview(this.project1, this.user1);
        this.reviewDAO.add(this.review1);
        this.review2 = Generators.generateReview(this.project1, this.user2);
        this.reviewDAO.add(this.review2);
        this.review3 = Generators.generateReview(this.project1, this.user2);
        this.reviewDAO.add(this.review3);
    }

    @Test
    public void testCountStatesOn() throws Exception {
        long now = System.currentTimeMillis();
        this.createStateChangeLog("aaaa", this.review1.getId(), this.user1, now - 5000L);
        this.createStateChangeLog("bbbb", this.review1.getId(), this.user1, now - 4000L);
        this.createStateChangeLog("cccc", this.review1.getId(), this.user2, now - 3000L);
        this.createStateChangeLog("aaaa", this.review2.getId(), this.user2, now - 2000L);
        this.createStateChangeLog("bbbb", this.review2.getId(), this.user1, now - 1000L);
        this.createStateChangeLog("cccc", this.review2.getId(), this.user2, now - 500L);
        this.createStateChangeLog("aaaa", this.review3.getId(), this.user1, now - 5000L);
        this.createStateChangeLog("bbbb", this.review3.getId(), this.user1, now + 4000L);
        this.createStateChangeLog("cccc", this.review3.getId(), this.user2, now + 3000L);
        Map countStates = this.stateChangeLogDAO.countStatesOn(new Date(now), this.project1);
        MatcherAssert.assertThat(countStates.get("cccc"), (Matcher)Matchers.is((Object)2L));
        MatcherAssert.assertThat(countStates.get("aaaa"), (Matcher)Matchers.is((Object)1L));
    }

    private StateChangeLog createStateChangeLog(String newState, Integer reviewId, FecruUser user, long timestamp) {
        StateChangeLog stateChangeLog = new StateChangeLog(newState, reviewId, user);
        stateChangeLog.setDateTimeStamp(Long.valueOf(timestamp));
        this.stateChangeLogDAO.add(stateChangeLog);
        return stateChangeLog;
    }

    @Test
    public void testList() throws Exception {
        Review review4 = Generators.generateReview(this.project2, this.user2);
        this.reviewDAO.add(review4);
        long now = System.currentTimeMillis();
        StateChangeLog stateChangeLog1 = this.createStateChangeLog("aaaa", this.review1.getId(), this.user1, now - 5000L);
        StateChangeLog stateChangeLog2 = this.createStateChangeLog("aaaa", this.review2.getId(), this.user2, now - 2000L);
        StateChangeLog stateChangeLog3 = this.createStateChangeLog("aaaa", this.review3.getId(), this.user2, now + 1000L);
        StateChangeLog stateChangeLog4 = this.createStateChangeLog("aaaa", review4.getId(), this.user2, now - 500L);
        MatcherAssert.assertThat((Object)this.stateChangeLogDAO.list(new Date(now - 1000L), new Date(now), this.project1), (Matcher)Matchers.containsInAnyOrder((Object[])new StateChangeLog[]{stateChangeLog1, stateChangeLog2}));
    }
}

