/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model.dao;

import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fecru.user.FecruUserDAO;
import com.cenqua.crucible.model.PermaIdKey;
import com.cenqua.crucible.model.PermissionScheme;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.ReviewPermaId;
import com.cenqua.crucible.model.dao.Generators;
import com.cenqua.crucible.model.dao.HibernatePermissionSchemeDAO;
import com.cenqua.crucible.model.dao.HibernateProjectDAO;
import com.cenqua.crucible.model.dao.HibernateReviewDAO;
import com.cenqua.crucible.model.dao.HibernateReviewPermaIdDAO;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hibernate.NonUniqueObjectException;
import org.hibernate.SessionFactory;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.transaction.TransactionConfiguration;
import org.springframework.transaction.annotation.Transactional;

@TransactionConfiguration(defaultRollback=true)
@ContextConfiguration(value={"classpath:/tests-db-spring-context-level3-manager.xml"})
@Transactional
@RunWith(value=SpringJUnit4ClassRunner.class)
@DirtiesContext
public class HibernateReviewPermaIdDAOTest {
    @Autowired
    HibernateReviewPermaIdDAO reviewPermaIdDAO;
    @Autowired
    private HibernateReviewDAO reviewDAO;
    @Autowired
    private FecruUserDAO userDAO;
    @Autowired
    private HibernateProjectDAO projectDAO;
    @Autowired
    private HibernatePermissionSchemeDAO permissionSchemeDAO;
    @Autowired
    private SessionFactory sessionFactory;
    private PermissionScheme permissionScheme;
    private Project project1;
    private Project project2;
    private FecruUser user1;
    private FecruUser user2;

    @Before
    public void setUp() throws Exception {
        this.permissionScheme = Generators.generatePermissionScheme();
        this.permissionSchemeDAO.add(this.permissionScheme);
        this.project1 = Generators.generateProject(this.permissionScheme, "XXX");
        this.projectDAO.add(this.project1);
        this.project2 = Generators.generateProject(this.permissionScheme, "YYY");
        this.projectDAO.add(this.project2);
        this.user1 = Generators.generateUser();
        this.userDAO.create(this.user1);
        this.user2 = Generators.generateUser();
        this.userDAO.create(this.user2);
    }

    @Test
    public void testAddAndListOrdered() throws Exception {
        Review review1 = Generators.generateReview(this.project1, this.user1);
        this.reviewDAO.add(review1);
        Review review2 = Generators.generateReview(this.project1, this.user2);
        this.reviewDAO.add(review2);
        MatcherAssert.assertThat((Object)this.reviewPermaIdDAO.listWithReview(review1), (Matcher)Matchers.is((Matcher)Matchers.empty()));
        MatcherAssert.assertThat((Object)this.reviewPermaIdDAO.listWithReview(review2), (Matcher)Matchers.is((Matcher)Matchers.empty()));
        ReviewPermaId reviewPermaId1 = Generators.generateReviewPermaId(review1, this.project1.getProjKey(), 0);
        this.reviewPermaIdDAO.add(reviewPermaId1);
        ReviewPermaId reviewPermaId2 = Generators.generateReviewPermaId(review1, "AAA", 0);
        this.reviewPermaIdDAO.add(reviewPermaId2);
        ReviewPermaId reviewPermaId3 = Generators.generateReviewPermaId(review1, "BBB", 0);
        this.reviewPermaIdDAO.add(reviewPermaId3);
        ReviewPermaId reviewPermaId4 = Generators.generateReviewPermaId(review2, this.project1.getProjKey(), 1);
        this.reviewPermaIdDAO.add(reviewPermaId4);
        ReviewPermaId reviewPermaId5 = Generators.generateReviewPermaId(review2, "CCC", 0);
        this.reviewPermaIdDAO.add(reviewPermaId5);
        MatcherAssert.assertThat((Object)this.reviewPermaIdDAO.listWithReview(review1), (Matcher)Matchers.containsInAnyOrder((Object[])new ReviewPermaId[]{reviewPermaId1, reviewPermaId2, reviewPermaId3}));
        MatcherAssert.assertThat((Object)this.reviewPermaIdDAO.listWithReview(review2), (Matcher)Matchers.containsInAnyOrder((Object[])new ReviewPermaId[]{reviewPermaId4, reviewPermaId5}));
    }

    @Test(expected=NonUniqueObjectException.class)
    public void testKeyUniqueness() throws Exception {
        Review review1 = Generators.generateReview(this.project1, this.user1);
        this.reviewDAO.add(review1);
        Review review2 = Generators.generateReview(this.project1, this.user2);
        this.reviewDAO.add(review2);
        ReviewPermaId reviewPermaId1 = Generators.generateReviewPermaId(review1, this.project1.getProjKey(), 0);
        this.reviewPermaIdDAO.add(reviewPermaId1);
        ReviewPermaId reviewPermaId2 = Generators.generateReviewPermaId(review2, this.project1.getProjKey(), 0);
        this.reviewPermaIdDAO.add(reviewPermaId2);
    }

    @Test
    public void testDelete() throws Exception {
        Review review1 = Generators.generateReview(this.project1, this.user1);
        this.reviewDAO.add(review1);
        Review review2 = Generators.generateReview(this.project1, this.user2);
        this.reviewDAO.add(review2);
        ReviewPermaId reviewPermaId1 = Generators.generateReviewPermaId(review1, this.project1.getProjKey(), 0);
        this.reviewPermaIdDAO.add(reviewPermaId1);
        ReviewPermaId reviewPermaId2 = Generators.generateReviewPermaId(review1, "AAA", 0);
        this.reviewPermaIdDAO.add(reviewPermaId2);
        ReviewPermaId reviewPermaId4 = Generators.generateReviewPermaId(review2, this.project1.getProjKey(), 1);
        this.reviewPermaIdDAO.add(reviewPermaId4);
        ReviewPermaId reviewPermaId5 = Generators.generateReviewPermaId(review2, "BBB", 0);
        this.reviewPermaIdDAO.add(reviewPermaId5);
        MatcherAssert.assertThat((Object)this.reviewPermaIdDAO.listWithReview(review1), (Matcher)Matchers.containsInAnyOrder((Object[])new ReviewPermaId[]{reviewPermaId1, reviewPermaId2}));
        MatcherAssert.assertThat((Object)this.reviewPermaIdDAO.listWithReview(review2), (Matcher)Matchers.containsInAnyOrder((Object[])new ReviewPermaId[]{reviewPermaId4, reviewPermaId5}));
        this.reviewPermaIdDAO.delete(reviewPermaId2);
        MatcherAssert.assertThat((Object)this.reviewPermaIdDAO.listWithReview(review1), (Matcher)Matchers.containsInAnyOrder((Object[])new ReviewPermaId[]{reviewPermaId1}));
        MatcherAssert.assertThat((Object)this.reviewPermaIdDAO.listWithReview(review2), (Matcher)Matchers.containsInAnyOrder((Object[])new ReviewPermaId[]{reviewPermaId4, reviewPermaId5}));
        this.reviewPermaIdDAO.delete(reviewPermaId5);
        this.reviewPermaIdDAO.delete(reviewPermaId4);
        MatcherAssert.assertThat((Object)this.reviewPermaIdDAO.listWithReview(review1), (Matcher)Matchers.containsInAnyOrder((Object[])new ReviewPermaId[]{reviewPermaId1}));
        MatcherAssert.assertThat((Object)this.reviewPermaIdDAO.listWithReview(review2), (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }

    @Test
    public void testDeleteWithProjectKey() throws Exception {
        Review review1 = Generators.generateReview(this.project1, this.user1);
        this.reviewDAO.add(review1);
        Review review2 = Generators.generateReview(this.project1, this.user2);
        this.reviewDAO.add(review2);
        Review review3 = Generators.generateReview(this.project2, this.user1);
        this.reviewDAO.add(review3);
        Review review4 = Generators.generateReview(this.project2, this.user2);
        this.reviewDAO.add(review4);
        this.reviewPermaIdDAO.add(Generators.generateReviewPermaId(review1, this.project1.getProjKey(), 0));
        this.reviewPermaIdDAO.add(Generators.generateReviewPermaId(review1, this.project1.getProjKey(), 1));
        this.reviewPermaIdDAO.add(Generators.generateReviewPermaId(review1, this.project2.getProjKey(), 0));
        this.reviewPermaIdDAO.add(Generators.generateReviewPermaId(review1, this.project2.getProjKey(), 1));
        MatcherAssert.assertThat((Object)this.reviewPermaIdDAO.listProjectKeys(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{this.project1.getProjKey(), this.project2.getProjKey()}));
        this.reviewPermaIdDAO.deleteWithProjectKey(this.project1.getProjKey());
        MatcherAssert.assertThat((Object)this.reviewPermaIdDAO.listProjectKeys(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{this.project2.getProjKey()}));
    }

    @Test
    public void testGetByPermaIdKey() throws Exception {
        Review review1 = Generators.generateReview(this.project1, this.user1);
        this.reviewDAO.add(review1);
        Review review2 = Generators.generateReview(this.project1, this.user2);
        this.reviewDAO.add(review2);
        ReviewPermaId reviewPermaId1 = Generators.generateReviewPermaId(review1, this.project1.getProjKey(), 0);
        this.reviewPermaIdDAO.add(reviewPermaId1);
        ReviewPermaId reviewPermaId2 = Generators.generateReviewPermaId(review2, this.project1.getProjKey(), 1);
        this.reviewPermaIdDAO.add(reviewPermaId2);
        MatcherAssert.assertThat((Object)this.reviewPermaIdDAO.getByPermaIdKey(reviewPermaId1.getPermaIdKey()), (Matcher)Matchers.equalTo((Object)reviewPermaId1));
        MatcherAssert.assertThat((Object)this.reviewPermaIdDAO.getByPermaIdKey(reviewPermaId2.getPermaIdKey()), (Matcher)Matchers.equalTo((Object)reviewPermaId2));
    }

    @Test
    public void testGetMaxNumberForProject() throws Exception {
        Review review1 = Generators.generateReview(this.project1, this.user1);
        this.reviewDAO.add(review1);
        Review review2 = Generators.generateReview(this.project1, this.user2);
        this.reviewDAO.add(review2);
        Review review3 = Generators.generateReview(this.project2, this.user1);
        this.reviewDAO.add(review3);
        Review review4 = Generators.generateReview(this.project2, this.user2);
        this.reviewDAO.add(review4);
        this.reviewPermaIdDAO.add(Generators.generateReviewPermaId(review1, this.project1.getProjKey(), 5));
        this.reviewPermaIdDAO.add(Generators.generateReviewPermaId(review1, this.project1.getProjKey(), 10));
        this.reviewPermaIdDAO.add(Generators.generateReviewPermaId(review1, this.project2.getProjKey(), 15));
        this.reviewPermaIdDAO.add(Generators.generateReviewPermaId(review1, this.project2.getProjKey(), 25));
        MatcherAssert.assertThat((Object)this.reviewPermaIdDAO.getMaxNumberForProject(this.project1.getProjKey()), (Matcher)Matchers.equalTo((Object)10));
        MatcherAssert.assertThat((Object)this.reviewPermaIdDAO.getMaxNumberForProject(this.project2.getProjKey()), (Matcher)Matchers.equalTo((Object)25));
    }

    @Test
    public void testListProjectKeys() throws Exception {
        Review review1 = Generators.generateReview(this.project1, this.user1);
        this.reviewDAO.add(review1);
        Review review2 = Generators.generateReview(this.project1, this.user2);
        this.reviewDAO.add(review2);
        Review review3 = Generators.generateReview(this.project2, this.user1);
        this.reviewDAO.add(review3);
        Review review4 = Generators.generateReview(this.project2, this.user2);
        this.reviewDAO.add(review4);
        this.reviewPermaIdDAO.add(Generators.generateReviewPermaId(review1, this.project1.getProjKey(), 0));
        this.reviewPermaIdDAO.add(Generators.generateReviewPermaId(review1, this.project1.getProjKey(), 1));
        this.reviewPermaIdDAO.add(Generators.generateReviewPermaId(review1, this.project2.getProjKey(), 0));
        this.reviewPermaIdDAO.add(Generators.generateReviewPermaId(review1, this.project2.getProjKey(), 1));
        MatcherAssert.assertThat((Object)this.reviewPermaIdDAO.listProjectKeys(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{this.project1.getProjKey(), this.project2.getProjKey()}));
    }

    @Test
    public void testListWithProjectKey() throws Exception {
        Project project3 = Generators.generateProject(this.permissionScheme);
        this.projectDAO.add(project3);
        Review review1 = Generators.generateReview(this.project1, this.user1);
        this.reviewDAO.add(review1);
        Review review2 = Generators.generateReview(this.project1, this.user2);
        this.reviewDAO.add(review2);
        Review review3 = Generators.generateReview(this.project2, this.user1);
        this.reviewDAO.add(review3);
        Review review4 = Generators.generateReview(this.project2, this.user2);
        this.reviewDAO.add(review4);
        ReviewPermaId reviewPermaId1 = Generators.generateReviewPermaId(review1, this.project1.getProjKey(), 0);
        this.reviewPermaIdDAO.add(reviewPermaId1);
        ReviewPermaId reviewPermaId2 = Generators.generateReviewPermaId(review1, this.project1.getProjKey(), 1);
        this.reviewPermaIdDAO.add(reviewPermaId2);
        ReviewPermaId reviewPermaId3 = Generators.generateReviewPermaId(review1, this.project2.getProjKey(), 0);
        this.reviewPermaIdDAO.add(reviewPermaId3);
        ReviewPermaId reviewPermaId4 = Generators.generateReviewPermaId(review1, this.project2.getProjKey(), 1);
        this.reviewPermaIdDAO.add(reviewPermaId4);
        MatcherAssert.assertThat((Object)this.reviewPermaIdDAO.listWithProjectKey(this.project1.getProjKey()), (Matcher)Matchers.containsInAnyOrder((Object[])new ReviewPermaId[]{reviewPermaId1, reviewPermaId2}));
        MatcherAssert.assertThat((Object)this.reviewPermaIdDAO.listWithProjectKey(this.project2.getProjKey()), (Matcher)Matchers.containsInAnyOrder((Object[])new ReviewPermaId[]{reviewPermaId3, reviewPermaId4}));
    }

    @Test
    public void testGetReviewByPermaId() throws Exception {
        Review review1 = Generators.generateReview(this.project1, this.user1, true);
        this.reviewDAO.add(review1);
        Review review2 = Generators.generateReview(this.project1, this.user2, true);
        this.reviewDAO.add(review2);
        MatcherAssert.assertThat((Object)this.reviewPermaIdDAO.getReviewByPermaId(PermaIdKey.parsePermaId((String)review1.getPermaId())), (Matcher)Matchers.is((Object)review1));
        MatcherAssert.assertThat((Object)this.reviewPermaIdDAO.getReviewByPermaId(PermaIdKey.parsePermaId((String)review2.getPermaId())), (Matcher)Matchers.is((Object)review2));
    }

    @Test
    public void testGetReviewByPermaIdCorrectCase() throws Exception {
        Review review1 = Generators.generateReview(this.project1, this.user1, true);
        this.reviewDAO.add(review1);
        Review review2 = Generators.generateReview(this.project1, this.user2, true);
        this.reviewDAO.add(review2);
        this.sessionFactory.getStatistics().clear();
        this.sessionFactory.getStatistics().setStatisticsEnabled(true);
        MatcherAssert.assertThat((Object)this.sessionFactory.getStatistics().getQueries().length, (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)this.reviewPermaIdDAO.getReviewByPermaId(PermaIdKey.parsePermaId((String)review1.getPermaId())), (Matcher)Matchers.is((Object)review1));
        MatcherAssert.assertThat((Object)this.sessionFactory.getStatistics().getQueries().length, (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)this.reviewPermaIdDAO.getReviewByPermaId(PermaIdKey.parsePermaId((String)review2.getPermaId())), (Matcher)Matchers.is((Object)review2));
        MatcherAssert.assertThat((Object)this.sessionFactory.getStatistics().getQueries().length, (Matcher)Matchers.is((Object)1));
    }
}

