/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model.dao;

import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fecru.user.FecruUserDAO;
import com.cenqua.crucible.model.PermaIdKey;
import com.cenqua.crucible.model.PermissionScheme;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.ReviewParticipant;
import com.cenqua.crucible.model.ReviewPermaId;
import com.cenqua.crucible.model.dao.Generators;
import com.cenqua.crucible.model.dao.HibernateFileRevisionExtraInfoDAO;
import com.cenqua.crucible.model.dao.HibernatePermissionSchemeDAO;
import com.cenqua.crucible.model.dao.HibernateProjectDAO;
import com.cenqua.crucible.model.dao.HibernateReviewDAO;
import com.cenqua.crucible.model.managers.ProjectManager;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hibernate.SessionFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.transaction.TransactionConfiguration;
import org.springframework.transaction.annotation.Transactional;

@TransactionConfiguration(defaultRollback=true)
@ContextConfiguration(value={"classpath:/tests-db-spring-context-level3-manager.xml"})
@Transactional
@RunWith(value=SpringJUnit4ClassRunner.class)
@DirtiesContext
public class HibernateReviewDAOTest {
    @Autowired
    private HibernateReviewDAO reviewDAO;
    @Autowired
    private FecruUserDAO userDAO;
    @Autowired
    private HibernateProjectDAO projectDAO;
    @Autowired
    private HibernatePermissionSchemeDAO permissionSchemeDAO;
    @Autowired
    private HibernateFileRevisionExtraInfoDAO fileRevisionExtraInfoDAO;
    @Autowired
    private SessionFactory sessionFactory;
    private PermissionScheme permissionScheme;
    private Project project;
    private FecruUser user1;
    private FecruUser user2;

    @Before
    public void setUp() throws Exception {
        this.permissionScheme = Generators.generatePermissionScheme();
        this.permissionSchemeDAO.add(this.permissionScheme);
        this.project = Generators.generateProject(this.permissionScheme);
        this.projectDAO.add(this.project);
        this.user1 = Generators.generateUser();
        this.userDAO.create(this.user1);
        this.user2 = Generators.generateUser();
        this.userDAO.create(this.user2);
    }

    @Test
    public void testApplicationContextSetUp() throws Exception {
        MatcherAssert.assertThat((Object)this.reviewDAO, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)this.userDAO, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)this.projectDAO, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)this.sessionFactory, (Matcher)Matchers.notNullValue());
    }

    @Test
    public void testAddAndListOrdered() throws Exception {
        MatcherAssert.assertThat((Object)this.reviewDAO.list(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
        Review review1 = Generators.generateReview(this.project, this.user1);
        this.reviewDAO.add(review1);
        MatcherAssert.assertThat((Object)this.reviewDAO.list(), (Matcher)Matchers.contains((Object[])new Review[]{review1}));
        Review review2 = Generators.generateReview(this.project, this.user1);
        this.reviewDAO.add(review2);
        MatcherAssert.assertThat((Object)this.reviewDAO.list(), (Matcher)Matchers.contains((Object[])new Review[]{review1, review2}));
        Review review3 = Generators.generateReview(this.project, this.user1);
        this.reviewDAO.add(review3);
        MatcherAssert.assertThat((Object)this.reviewDAO.list(), (Matcher)Matchers.contains((Object[])new Review[]{review1, review2, review3}));
    }

    @Test
    public void testDelete() throws Exception {
        Assert.assertThat((Object)this.reviewDAO.list(), (Matcher)CoreMatchers.is((Matcher)Matchers.empty()));
        Review review1 = Generators.generateReview(this.project, this.user1);
        this.reviewDAO.add(review1);
        Review review2 = Generators.generateReview(this.project, this.user1);
        this.reviewDAO.add(review2);
        Review review3 = Generators.generateReview(this.project, this.user2);
        this.reviewDAO.add(review3);
        Assert.assertThat((Object)this.reviewDAO.list(), (Matcher)Matchers.contains((Object[])new Review[]{review1, review2, review3}));
        this.reviewDAO.delete(review2);
        Assert.assertThat((Object)this.reviewDAO.list(), (Matcher)Matchers.contains((Object[])new Review[]{review1, review3}));
        this.reviewDAO.delete(review3);
        Assert.assertThat((Object)this.reviewDAO.list(), (Matcher)Matchers.contains((Object[])new Review[]{review1}));
        this.reviewDAO.delete(review1);
        Assert.assertThat((Object)this.reviewDAO.list(), (Matcher)CoreMatchers.is((Matcher)Matchers.empty()));
    }

    @Test
    public void testPermaIdHistoryAddRemove() throws Exception {
        Review review = Generators.generateReview(this.project, this.user1);
        this.reviewDAO.add(review);
        this.sessionFactory.getCurrentSession().flush();
        this.sessionFactory.getCurrentSession().evict((Object)review);
        review = this.reviewDAO.getById(review.getId());
        review.getPermaIdHistory().add(new ReviewPermaId(review, "AAA", 1));
        this.sessionFactory.getCurrentSession().flush();
        this.sessionFactory.getCurrentSession().evict((Object)review);
        review = this.reviewDAO.getById(review.getId());
        Assert.assertThat((Object)review.getPermaIdHistory(), (Matcher)Matchers.contains((Object[])new ReviewPermaId[]{new ReviewPermaId(review, "AAA", 1)}));
        this.sessionFactory.getCurrentSession().flush();
        this.sessionFactory.getCurrentSession().evict((Object)review);
        review = this.reviewDAO.getById(review.getId());
        review.getPermaIdHistory().add(new ReviewPermaId(review, "AAA", 2));
        this.sessionFactory.getCurrentSession().flush();
        this.sessionFactory.getCurrentSession().evict((Object)review);
        Assert.assertThat((Object)review.getPermaIdHistory(), (Matcher)Matchers.containsInAnyOrder((Object[])new ReviewPermaId[]{new ReviewPermaId(review, "AAA", 1), new ReviewPermaId(review, "AAA", 2)}));
        review = this.reviewDAO.getById(review.getId());
        review.getPermaIdHistory().remove(new ReviewPermaId(review, "AAA", 1));
        this.sessionFactory.getCurrentSession().flush();
        this.sessionFactory.getCurrentSession().evict((Object)review);
        Assert.assertThat((Object)review.getPermaIdHistory(), (Matcher)Matchers.containsInAnyOrder((Object[])new ReviewPermaId[]{new ReviewPermaId(review, "AAA", 2)}));
    }

    @Test
    public void testGetReviewById() throws Exception {
        Review review1 = Generators.generateReview(this.project, this.user1);
        this.reviewDAO.add(review1);
        String review1Name = review1.getName();
        Review review2 = Generators.generateReview(this.project, this.user1);
        this.reviewDAO.add(review2);
        String review2Name = review2.getName();
        MatcherAssert.assertThat((Object)this.reviewDAO.getById(review1.getId()).getName(), (Matcher)Matchers.equalTo((Object)review1Name));
        MatcherAssert.assertThat((Object)this.reviewDAO.getById(review2.getId()).getName(), (Matcher)Matchers.equalTo((Object)review2Name));
    }

    @Test
    public void testGetReviewByPermaId() throws Exception {
        ProjectManager projectManagerMock = (ProjectManager)Mockito.mock(ProjectManager.class);
        final AtomicInteger uniqueIdGenerator = new AtomicInteger();
        Mockito.when((Object)projectManagerMock.getNextPermaId((Project)org.mockito.Matchers.any(Project.class), (Review)org.mockito.Matchers.any(Review.class))).thenAnswer((Answer)new Answer<ReviewPermaId>(){

            public ReviewPermaId answer(InvocationOnMock invocation) throws Throwable {
                Project projectArg = (Project)invocation.getArguments()[0];
                Review reviewArg = (Review)invocation.getArguments()[1];
                return new ReviewPermaId(reviewArg, projectArg.getProjKey(), uniqueIdGenerator.getAndIncrement());
            }
        });
        Review review1 = Generators.generateReview(this.project, this.user1);
        review1.addPermaId(projectManagerMock, this.project);
        this.reviewDAO.add(review1);
        String permaId1 = review1.getPermaId();
        String review1Name = review1.getName();
        Review review2 = Generators.generateReview(this.project, this.user2);
        review2.addPermaId(projectManagerMock, this.project);
        this.reviewDAO.add(review2);
        String permaId2 = review2.getPermaId();
        String review2Name = review2.getName();
        Review review3 = Generators.generateReview(this.project, this.user1);
        review3.addPermaId(projectManagerMock, this.project);
        this.reviewDAO.add(review3);
        String permaId3 = review3.getPermaId();
        String review3Name = review3.getName();
        MatcherAssert.assertThat((Object)this.reviewDAO.getReviewByPermaId(PermaIdKey.parsePermaId((String)permaId1)).getName(), (Matcher)Matchers.equalTo((Object)review1Name));
        MatcherAssert.assertThat((Object)this.reviewDAO.getReviewByPermaId(PermaIdKey.parsePermaId((String)permaId2)).getName(), (Matcher)Matchers.equalTo((Object)review2Name));
        MatcherAssert.assertThat((Object)this.reviewDAO.getReviewByPermaId(PermaIdKey.parsePermaId((String)permaId3)).getName(), (Matcher)Matchers.equalTo((Object)review3Name));
    }

    @Test
    public void testCountReviewsInProject() throws Exception {
        Project project1 = Generators.generateProject(this.permissionScheme);
        this.projectDAO.add(project1);
        Review review1 = Generators.generateReview(this.project, this.user1);
        this.reviewDAO.add(review1);
        Review review2 = Generators.generateReview(project1, this.user1);
        this.reviewDAO.add(review2);
        Review review3 = Generators.generateReview(this.project, this.user1);
        this.reviewDAO.add(review3);
        MatcherAssert.assertThat((Object)this.reviewDAO.countReviewsInProject(this.project), (Matcher)Matchers.equalTo((Object)2));
        MatcherAssert.assertThat((Object)this.reviewDAO.countReviewsInProject(project1), (Matcher)Matchers.equalTo((Object)1));
    }

    @Test
    public void testListWithProject() throws Exception {
        Project project1 = Generators.generateProject(this.permissionScheme);
        this.projectDAO.add(project1);
        Review review1 = Generators.generateReview(this.project, this.user1);
        this.reviewDAO.add(review1);
        Review review2 = Generators.generateReview(project1, this.user1);
        this.reviewDAO.add(review2);
        Review review3 = Generators.generateReview(this.project, this.user1);
        this.reviewDAO.add(review3);
        MatcherAssert.assertThat((Object)this.reviewDAO.listWithProject(this.project), (Matcher)Matchers.contains((Object[])new Review[]{review1, review3}));
        MatcherAssert.assertThat((Object)this.reviewDAO.listWithProject(project1), (Matcher)Matchers.contains((Object[])new Review[]{review2}));
    }

    @Test
    public void testListWithJiraIssueKey() throws Exception {
        Review review1 = Generators.generateReview(this.project, this.user1);
        review1.setJiraIssueKey("jira-1");
        this.reviewDAO.add(review1);
        Review review2 = Generators.generateReview(this.project, this.user1);
        review2.setJiraIssueKey("jira-2");
        this.reviewDAO.add(review2);
        Review review3 = Generators.generateReview(this.project, this.user1);
        review3.setJiraIssueKey("jira-1");
        this.reviewDAO.add(review3);
        MatcherAssert.assertThat((Object)this.reviewDAO.listWithJiraIssueKey("jira-1"), (Matcher)Matchers.contains((Object[])new Review[]{review1, review3}));
        MatcherAssert.assertThat((Object)this.reviewDAO.listWithJiraIssueKey("jira-2"), (Matcher)Matchers.contains((Object[])new Review[]{review2}));
    }

    @Test
    public void testListReviewsInStateOrderedByCreateDateTime() throws Exception {
        Review reviewA1 = this.createReviewInState("Draft", 0L);
        Review reviewA2 = this.createReviewInState("Draft", 100L);
        Review reviewA3 = this.createReviewInState("Draft", 500L);
        Review reviewB1 = this.createReviewInState("Review", 10L);
        Review reviewB2 = this.createReviewInState("Review", 110L);
        Review reviewC1 = this.createReviewInState("Closed", 20L);
        MatcherAssert.assertThat((Object)this.reviewDAO.listReviewsInStateOrderedByCreateDateTime(new String[]{"Draft", "Closed"}, true), (Matcher)Matchers.contains((Object[])new Review[]{reviewA1, reviewC1, reviewA2, reviewA3}));
        MatcherAssert.assertThat((Object)this.reviewDAO.listReviewsInStateOrderedByCreateDateTime(new String[]{"Draft", "Closed"}, false), (Matcher)Matchers.contains((Object[])new Review[]{reviewB1, reviewB2}));
    }

    private Review createReviewInState(String state, long createdTime) {
        Review review = Generators.generateReview(this.project, this.user1);
        review.setCreateDate(new Date(createdTime));
        review.setStateName(state);
        this.reviewDAO.add(review);
        return review;
    }

    @Test
    public void testListReviewsByDueDate() throws Exception {
        long now = System.currentTimeMillis();
        Review review0 = this.createRevieWithDueDate(now + 10L);
        Review review1 = this.createRevieWithDueDate(now - 10L);
        Review review2 = this.createRevieWithDueDate(now - 500L);
        Review review3 = this.createRevieWithDueDate(now - 200L);
        Review review4 = this.createRevieWithDueDate(now - 400L);
        MatcherAssert.assertThat((Object)this.reviewDAO.listReviewsByDueDate(this.project, new Date(now)), (Matcher)Matchers.contains((Object[])new Review[]{review2, review4, review3, review1}));
    }

    private Review createRevieWithDueDate(long dueDate) {
        Review review = Generators.generateReview(this.project, this.user1);
        review.setDueDateTime(Long.valueOf(dueDate));
        review.setStateName("Review");
        this.reviewDAO.add(review);
        return review;
    }

    @Test
    public void testListWithProjectStartLimit() throws Exception {
        ArrayList reviews = Lists.newArrayList();
        for (int i = 0; i < 100; ++i) {
            Review review = Generators.generateReview(this.project, this.user1);
            reviews.add(review);
            this.reviewDAO.add(review);
        }
        MatcherAssert.assertThat((Object)this.reviewDAO.listWithProject(this.project, 0, 10), (Matcher)Matchers.is(reviews.subList(0, 10)));
        MatcherAssert.assertThat((Object)this.reviewDAO.listWithProject(this.project, 50, 20), (Matcher)Matchers.is(reviews.subList(50, 70)));
        MatcherAssert.assertThat((Object)this.reviewDAO.listWithProject(this.project, 90, 110), (Matcher)Matchers.is(reviews.subList(90, 100)));
        MatcherAssert.assertThat((Object)this.reviewDAO.listWithProject(this.project, 101, 150), (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }

    @Test
    public void testGetReviewCountForUsers() throws Exception {
        this.createReviewWithParticipant(this.user1);
        this.createReviewWithParticipant(this.user2);
        this.createReviewWithParticipant(this.user1);
        this.createReviewWithParticipant(this.user2);
        this.createReviewWithParticipant(this.user1);
        MatcherAssert.assertThat((Object)this.reviewDAO.getReviewCountForUsers(null, null, (Set)Sets.newHashSet((Object[])new String[]{this.user1.getUsername()})).get((Object)this.user1.getUsername()), (Matcher)Matchers.is((Object)3L));
        MatcherAssert.assertThat((Object)this.reviewDAO.getReviewCountForUsers(null, null, (Set)Sets.newHashSet((Object[])new String[]{this.user2.getUsername()})).get((Object)this.user2.getUsername()), (Matcher)Matchers.is((Object)2L));
        MatcherAssert.assertThat((Object)this.reviewDAO.getReviewCountForUsers(null, null, (Set)Sets.newHashSet((Object[])new String[]{this.user1.getUsername(), this.user2.getUsername()})).get((Object)this.user2.getUsername()), (Matcher)Matchers.is((Object)2L));
    }

    private Review createReviewWithParticipant(FecruUser user) {
        Review review = Generators.generateReview(this.project, this.user1);
        review.setStateName("Review");
        this.reviewDAO.add(review);
        ReviewParticipant reviewParticipant = new ReviewParticipant();
        reviewParticipant.setReviewer(true);
        reviewParticipant.setUser(user);
        reviewParticipant.setReview(review);
        this.sessionFactory.getCurrentSession().save((Object)reviewParticipant);
        review.getParticipants().add(reviewParticipant);
        return review;
    }

    @Test
    public void testSearchReviewForTerms() throws Exception {
        String term1 = "Abrakadabra";
        String term2 = "Wawaweewaaa";
        String term3 = "Wooooooooow";
        Review review1 = Generators.generateReview(this.project, this.user1);
        review1.setDescription("bla bla bla " + term1 + " bla bla bla");
        review1.setName("name " + term3);
        this.reviewDAO.add(review1);
        Review review2 = Generators.generateReview(this.project, this.user1);
        review2.setDescription("bla bla bla " + term2 + " bla bla bla");
        review2.setName("name " + term2);
        this.reviewDAO.add(review2);
        Review review3 = Generators.generateReview(this.project, this.user1);
        review3.setDescription("bla bla bla " + term3 + " bla bla bla");
        review3.setName("name " + term1);
        this.reviewDAO.add(review3);
        MatcherAssert.assertThat((Object)this.reviewDAO.searchReviewForTerms(Arrays.asList(term1), "review.id", "review.id", Integer.valueOf(100), this.project.getProjKey()), (Matcher)Matchers.containsInAnyOrder((Object[])new Integer[]{review3.getId(), review1.getId()}));
        MatcherAssert.assertThat((Object)this.reviewDAO.searchReviewForTerms(Arrays.asList(term2), "review.id", "review.id", Integer.valueOf(100), this.project.getProjKey()), (Matcher)Matchers.containsInAnyOrder((Object[])new Integer[]{review2.getId()}));
        MatcherAssert.assertThat((Object)this.reviewDAO.searchReviewForTerms(Arrays.asList(term1, term3), "review.id", "review.id", Integer.valueOf(100), this.project.getProjKey()), (Matcher)Matchers.containsInAnyOrder((Object[])new Integer[]{review3.getId(), review1.getId()}));
    }

    @Test
    public void testCountReviewsCreatedInPeriod() throws Exception {
        long end = System.currentTimeMillis();
        long start = end - 10000L;
        Review review0 = Generators.generateReview(this.project, this.user1);
        review0.setCreateDateTime(Long.valueOf(start - 1000L));
        this.reviewDAO.add(review0);
        Review review1 = Generators.generateReview(this.project, this.user1);
        review1.setCreateDateTime(Long.valueOf(start + 1000L));
        this.reviewDAO.add(review1);
        Review review2 = Generators.generateReview(this.project, this.user1);
        review2.setCreateDateTime(Long.valueOf(start + 2000L));
        this.reviewDAO.add(review2);
        Review review3 = Generators.generateReview(this.project, this.user1);
        review3.setCreateDateTime(Long.valueOf(end + 2000L));
        this.reviewDAO.add(review3);
        MatcherAssert.assertThat((Object)this.reviewDAO.countReviewsCreatedInPeriod(new Date(start), new Date(end), this.project), (Matcher)Matchers.is((Object)2));
    }

    @Test
    public void testGetReviewsByIds() throws Exception {
        Review review1 = Generators.generateReview(this.project, this.user1);
        this.reviewDAO.add(review1);
        Review review2 = Generators.generateReview(this.project, this.user1);
        this.reviewDAO.add(review2);
        Review review3 = Generators.generateReview(this.project, this.user1);
        this.reviewDAO.add(review3);
        MatcherAssert.assertThat((Object)this.reviewDAO.getReviewsByIds(Arrays.asList(review1.getId(), review3.getId())), (Matcher)Matchers.containsInAnyOrder((Object[])new Review[]{review1, review3}));
    }
}

