/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model.dao;

import com.atlassian.crucible.spi.services.ProjectSearchCriteria;
import com.atlassian.crucible.spi.services.SearchCriteriaJunctionType;
import com.atlassian.crucible.spi.services.SearchCriteriaType;
import com.cenqua.crucible.model.PermissionScheme;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.dao.Generators;
import com.cenqua.crucible.model.dao.HibernatePermissionSchemeDAO;
import com.cenqua.crucible.model.dao.HibernateProjectDAO;
import java.io.Serializable;
import org.apache.commons.lang3.SerializationUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.transaction.TransactionConfiguration;
import org.springframework.transaction.annotation.Transactional;
import org.unitils.reflectionassert.ReflectionAssert;
import org.unitils.reflectionassert.ReflectionComparatorMode;

@TransactionConfiguration(defaultRollback=true)
@ContextConfiguration(value={"classpath:/tests-db-spring-context-level3-manager.xml"})
@Transactional
@RunWith(value=SpringJUnit4ClassRunner.class)
public class HibernateProjectDAOTest {
    @Autowired
    private HibernateProjectDAO projectDAO;
    @Autowired
    private HibernatePermissionSchemeDAO permissionSchemeDAO;
    private PermissionScheme permissionScheme;

    @Before
    public void setUp() throws Exception {
        this.permissionScheme = Generators.generatePermissionScheme();
        this.permissionSchemeDAO.add(this.permissionScheme);
    }

    @Test
    public void testAddListOrdered() throws Exception {
        Assert.assertThat((Object)this.projectDAO.list(), (Matcher)CoreMatchers.is((Matcher)Matchers.empty()));
        Project project1 = Generators.generateProject(this.permissionScheme, "AAAA");
        this.projectDAO.add(project1);
        Assert.assertThat((Object)this.projectDAO.list(), (Matcher)Matchers.contains((Object[])new Project[]{project1}));
        Project project2 = Generators.generateProject(this.permissionScheme, "CCCC");
        this.projectDAO.add(project2);
        Assert.assertThat((Object)this.projectDAO.list(), (Matcher)Matchers.contains((Object[])new Project[]{project1, project2}));
        Project project3 = Generators.generateProject(this.permissionScheme, "BBBB");
        this.projectDAO.add(project3);
        Assert.assertThat((Object)this.projectDAO.list(), (Matcher)Matchers.contains((Object[])new Project[]{project1, project3, project2}));
    }

    @Test
    public void testDelete() throws Exception {
        Assert.assertThat((Object)this.projectDAO.list(), (Matcher)CoreMatchers.is((Matcher)Matchers.empty()));
        Project project1 = Generators.generateProject(this.permissionScheme, "AAAA");
        this.projectDAO.add(project1);
        Project project2 = Generators.generateProject(this.permissionScheme, "CCCC");
        this.projectDAO.add(project2);
        Project project3 = Generators.generateProject(this.permissionScheme, "BBBB");
        this.projectDAO.add(project3);
        Assert.assertThat((Object)this.projectDAO.list(), (Matcher)Matchers.contains((Object[])new Project[]{project1, project3, project2}));
        this.projectDAO.delete(project3);
        Assert.assertThat((Object)this.projectDAO.list(), (Matcher)Matchers.contains((Object[])new Project[]{project1, project2}));
        this.projectDAO.delete(project1);
        Assert.assertThat((Object)this.projectDAO.list(), (Matcher)Matchers.contains((Object[])new Project[]{project2}));
        this.projectDAO.delete(project2);
        Assert.assertThat((Object)this.projectDAO.list(), (Matcher)CoreMatchers.is((Matcher)Matchers.empty()));
    }

    @Test
    public void testGetProjectById() throws Exception {
        Project project1 = Generators.generateProject(this.permissionScheme);
        this.projectDAO.add(project1);
        Project project1Copy = (Project)SerializationUtils.clone((Serializable)project1);
        Project project2 = Generators.generateProject(this.permissionScheme);
        this.projectDAO.add(project2);
        Project project2Copy = (Project)SerializationUtils.clone((Serializable)project2);
        ReflectionAssert.assertReflectionEquals((Object)this.projectDAO.getById(project1.getId()), (Object)project1Copy, (ReflectionComparatorMode[])new ReflectionComparatorMode[0]);
        ReflectionAssert.assertReflectionEquals((Object)this.projectDAO.getById(project2.getId()), (Object)project2Copy, (ReflectionComparatorMode[])new ReflectionComparatorMode[0]);
    }

    @Test
    public void testGetProjectByKey() throws Exception {
        Project project1 = Generators.generateProject(this.permissionScheme);
        this.projectDAO.add(project1);
        Project project1Copy = (Project)SerializationUtils.clone((Serializable)project1);
        Project project2 = Generators.generateProject(this.permissionScheme);
        this.projectDAO.add(project2);
        Project project2Copy = (Project)SerializationUtils.clone((Serializable)project2);
        ReflectionAssert.assertReflectionEquals((Object)this.projectDAO.getByKey(project1.getProjKey()), (Object)project1Copy, (ReflectionComparatorMode[])new ReflectionComparatorMode[0]);
        ReflectionAssert.assertReflectionEquals((Object)this.projectDAO.getByKey(project2.getProjKey()), (Object)project2Copy, (ReflectionComparatorMode[])new ReflectionComparatorMode[0]);
    }

    @Test
    public void testListProjectsWithDefaultRepositoryName() throws Exception {
        Project project1 = Generators.generateProject(this.permissionScheme, "AAA");
        project1.setDefaultRepositoryName("repo1");
        this.projectDAO.add(project1);
        Project project2 = Generators.generateProject(this.permissionScheme, "BBB");
        project2.setDefaultRepositoryName("repo1");
        this.projectDAO.add(project2);
        Project project3 = Generators.generateProject(this.permissionScheme, "CCC");
        project3.setDefaultRepositoryName("repo2");
        this.projectDAO.add(project3);
        Assert.assertThat((Object)this.projectDAO.listWithDefaultRepositoryName("repo1"), (Matcher)Matchers.contains((Object[])new Project[]{project1, project2}));
        Assert.assertThat((Object)this.projectDAO.listWithDefaultRepositoryName("repo2"), (Matcher)Matchers.contains((Object[])new Project[]{project3}));
    }

    @Test
    public void testListProjectsWithPermissionScheme() throws Exception {
        PermissionScheme permissionScheme2 = Generators.generatePermissionScheme();
        this.permissionSchemeDAO.add(permissionScheme2);
        Project project1 = Generators.generateProject(this.permissionScheme, "AAA");
        this.projectDAO.add(project1);
        Project project2 = Generators.generateProject(permissionScheme2, "BBB");
        this.projectDAO.add(project2);
        Project project3 = Generators.generateProject(permissionScheme2, "CCC");
        this.projectDAO.add(project3);
        Assert.assertThat((Object)this.projectDAO.listWithPermissionScheme(this.permissionScheme), (Matcher)Matchers.contains((Object[])new Project[]{project1}));
        Assert.assertThat((Object)this.projectDAO.listWithPermissionScheme(permissionScheme2), (Matcher)Matchers.contains((Object[])new Project[]{project2, project3}));
    }

    @Test
    public void testListProjectKeys() throws Exception {
        Project project1 = Generators.generateProject(this.permissionScheme);
        project1.setProjKey("PRAAA");
        this.projectDAO.add(project1);
        Project project2 = Generators.generateProject(this.permissionScheme);
        project2.setProjKey("PRCCC");
        this.projectDAO.add(project2);
        Project project3 = Generators.generateProject(this.permissionScheme);
        project3.setProjKey("PRBBB");
        this.projectDAO.add(project3);
        Assert.assertThat((Object)this.projectDAO.listProjectKeys(), (Matcher)Matchers.contains((Object[])new String[]{"PRAAA", "PRBBB", "PRCCC"}));
    }

    @Test
    public void testCount() throws Exception {
        Assert.assertThat((Object)this.projectDAO.list(), (Matcher)CoreMatchers.is((Matcher)Matchers.empty()));
        Project project1 = Generators.generateProject(this.permissionScheme, "AAAA");
        this.projectDAO.add(project1);
        Project project2 = Generators.generateProject(this.permissionScheme, "CCCC");
        this.projectDAO.add(project2);
        Project project3 = Generators.generateProject(this.permissionScheme, "BBBB");
        this.projectDAO.add(project3);
        Assert.assertThat((Object)this.projectDAO.countProjects(), (Matcher)Matchers.equalTo((Object)3));
        Project project4 = Generators.generateProject(this.permissionScheme, "DDDD");
        this.projectDAO.add(project4);
        Assert.assertThat((Object)this.projectDAO.countProjects(), (Matcher)Matchers.equalTo((Object)4));
        this.projectDAO.delete(project1);
        Assert.assertThat((Object)this.projectDAO.countProjects(), (Matcher)Matchers.equalTo((Object)3));
    }

    @Test
    public void testCountWithProjectSearchCriteria() throws Exception {
        Assert.assertThat((Object)this.projectDAO.countProjects(ProjectSearchCriteria.create((SearchCriteriaJunctionType)SearchCriteriaJunctionType.AND, (SearchCriteriaType)SearchCriteriaType.PARTIAL_MATCH).all()), (Matcher)Matchers.equalTo((Object)0));
        PermissionScheme permissionScheme2 = Generators.generatePermissionScheme();
        this.permissionSchemeDAO.add(permissionScheme2);
        Project project1 = Generators.generateProject(this.permissionScheme, "AAAA");
        this.projectDAO.add(project1);
        Project project2 = Generators.generateProject(this.permissionScheme, "CCCC");
        this.projectDAO.add(project2);
        Project project3 = Generators.generateProject(this.permissionScheme, "BBBB");
        this.projectDAO.add(project3);
        Project project4 = Generators.generateProject(permissionScheme2, "ZZZZ");
        this.projectDAO.add(project4);
        Assert.assertThat((Object)this.projectDAO.countProjects(ProjectSearchCriteria.create((SearchCriteriaJunctionType)SearchCriteriaJunctionType.AND, (SearchCriteriaType)SearchCriteriaType.PARTIAL_MATCH).key("aaa").permissionSchemeName(this.permissionScheme.getName())), (Matcher)Matchers.equalTo((Object)1));
        Assert.assertThat((Object)this.projectDAO.countProjects(ProjectSearchCriteria.create((SearchCriteriaJunctionType)SearchCriteriaJunctionType.AND, (SearchCriteriaType)SearchCriteriaType.EXACT_MATCH).key("aaa").permissionSchemeName(this.permissionScheme.getName())), (Matcher)Matchers.equalTo((Object)0));
        Assert.assertThat((Object)this.projectDAO.countProjects(ProjectSearchCriteria.create((SearchCriteriaJunctionType)SearchCriteriaJunctionType.OR, (SearchCriteriaType)SearchCriteriaType.EXACT_MATCH).key("aaa").permissionSchemeName(this.permissionScheme.getName())), (Matcher)Matchers.equalTo((Object)3));
        Assert.assertThat((Object)this.projectDAO.countProjects(ProjectSearchCriteria.create((SearchCriteriaJunctionType)SearchCriteriaJunctionType.AND, (SearchCriteriaType)SearchCriteriaType.EXACT_MATCH).key("CCCC").permissionSchemeName(this.permissionScheme.getName())), (Matcher)Matchers.equalTo((Object)1));
        Assert.assertThat((Object)this.projectDAO.countProjects(ProjectSearchCriteria.create((SearchCriteriaJunctionType)SearchCriteriaJunctionType.AND, (SearchCriteriaType)SearchCriteriaType.PARTIAL_MATCH).key("bbb").permissionSchemeName(permissionScheme2.getName())), (Matcher)Matchers.equalTo((Object)0));
        Assert.assertThat((Object)this.projectDAO.countProjects(ProjectSearchCriteria.create((SearchCriteriaJunctionType)SearchCriteriaJunctionType.OR, (SearchCriteriaType)SearchCriteriaType.PARTIAL_MATCH).key("bbb").permissionSchemeName(permissionScheme2.getName())), (Matcher)Matchers.equalTo((Object)2));
        Assert.assertThat((Object)this.projectDAO.countProjects(ProjectSearchCriteria.create((SearchCriteriaJunctionType)SearchCriteriaJunctionType.OR, (SearchCriteriaType)SearchCriteriaType.PARTIAL_MATCH).name(project3.getName().toUpperCase()).permissionSchemeName(permissionScheme2.getName())), (Matcher)Matchers.equalTo((Object)2));
        Assert.assertThat((Object)this.projectDAO.countProjects(ProjectSearchCriteria.create((SearchCriteriaJunctionType)SearchCriteriaJunctionType.OR, (SearchCriteriaType)SearchCriteriaType.PARTIAL_MATCH).defaultRepositoryName(project3.getDefaultRepositoryName().toUpperCase()).permissionSchemeName(permissionScheme2.getName())), (Matcher)Matchers.equalTo((Object)2));
    }

    @Test
    public void testListWithProjectSearchCriteria() throws Exception {
        Assert.assertThat((Object)this.projectDAO.list(ProjectSearchCriteria.create((SearchCriteriaJunctionType)SearchCriteriaJunctionType.AND, (SearchCriteriaType)SearchCriteriaType.PARTIAL_MATCH).all(), 0, 100), (Matcher)CoreMatchers.is((Matcher)Matchers.empty()));
        PermissionScheme permissionScheme2 = Generators.generatePermissionScheme();
        this.permissionSchemeDAO.add(permissionScheme2);
        Project project1 = Generators.generateProject(this.permissionScheme, "AAAA");
        this.projectDAO.add(project1);
        Project project2 = Generators.generateProject(this.permissionScheme, "CCCC");
        this.projectDAO.add(project2);
        Project project3 = Generators.generateProject(this.permissionScheme, "BBBB");
        this.projectDAO.add(project3);
        Project project4 = Generators.generateProject(permissionScheme2, "ZZZZ");
        this.projectDAO.add(project4);
        Assert.assertThat((Object)this.projectDAO.list(ProjectSearchCriteria.create((SearchCriteriaJunctionType)SearchCriteriaJunctionType.AND, (SearchCriteriaType)SearchCriteriaType.PARTIAL_MATCH).key("aaa").permissionSchemeName(this.permissionScheme.getName()), 0, 100), (Matcher)Matchers.containsInAnyOrder((Object[])new Project[]{project1}));
        Assert.assertThat((Object)this.projectDAO.list(ProjectSearchCriteria.create((SearchCriteriaJunctionType)SearchCriteriaJunctionType.AND, (SearchCriteriaType)SearchCriteriaType.EXACT_MATCH).key("aaa").permissionSchemeName(this.permissionScheme.getName()), 0, 100), (Matcher)CoreMatchers.is((Matcher)Matchers.empty()));
        Assert.assertThat((Object)this.projectDAO.list(ProjectSearchCriteria.create((SearchCriteriaJunctionType)SearchCriteriaJunctionType.OR, (SearchCriteriaType)SearchCriteriaType.EXACT_MATCH).key("aaa").permissionSchemeName(this.permissionScheme.getName()), 0, 100), (Matcher)Matchers.containsInAnyOrder((Object[])new Project[]{project1, project2, project3}));
        Assert.assertThat((Object)this.projectDAO.list(ProjectSearchCriteria.create((SearchCriteriaJunctionType)SearchCriteriaJunctionType.AND, (SearchCriteriaType)SearchCriteriaType.EXACT_MATCH).key("CCCC").permissionSchemeName(this.permissionScheme.getName()), 0, 100), (Matcher)Matchers.containsInAnyOrder((Object[])new Project[]{project2}));
        Assert.assertThat((Object)this.projectDAO.list(ProjectSearchCriteria.create((SearchCriteriaJunctionType)SearchCriteriaJunctionType.AND, (SearchCriteriaType)SearchCriteriaType.PARTIAL_MATCH).key("bbb").permissionSchemeName(permissionScheme2.getName()), 0, 100), (Matcher)CoreMatchers.is((Matcher)Matchers.empty()));
        Assert.assertThat((Object)this.projectDAO.list(ProjectSearchCriteria.create((SearchCriteriaJunctionType)SearchCriteriaJunctionType.OR, (SearchCriteriaType)SearchCriteriaType.PARTIAL_MATCH).key("bbb").permissionSchemeName(permissionScheme2.getName()), 0, 100), (Matcher)Matchers.containsInAnyOrder((Object[])new Project[]{project3, project4}));
        Assert.assertThat((Object)this.projectDAO.list(ProjectSearchCriteria.create((SearchCriteriaJunctionType)SearchCriteriaJunctionType.OR, (SearchCriteriaType)SearchCriteriaType.PARTIAL_MATCH).name(project3.getName().toUpperCase()).permissionSchemeName(permissionScheme2.getName()), 0, 100), (Matcher)Matchers.containsInAnyOrder((Object[])new Project[]{project3, project4}));
        Assert.assertThat((Object)this.projectDAO.list(ProjectSearchCriteria.create((SearchCriteriaJunctionType)SearchCriteriaJunctionType.OR, (SearchCriteriaType)SearchCriteriaType.PARTIAL_MATCH).defaultRepositoryName(project3.getDefaultRepositoryName().toUpperCase()).permissionSchemeName(permissionScheme2.getName()), 0, 100), (Matcher)Matchers.containsInAnyOrder((Object[])new Project[]{project3, project4}));
    }

    @Test
    public void testEnsureProjectExistsPositive() throws Exception {
        Project project1 = Generators.generateProject(this.permissionScheme, "AAAA");
        this.projectDAO.add(project1);
        Assert.assertThat((Object)this.projectDAO.ensureProjectExists(project1.getProjKey()), (Matcher)Matchers.equalTo((Object)project1));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEnsureProjectExistsNegative() throws Exception {
        Project project1 = Generators.generateProject(this.permissionScheme, "AAAA");
        this.projectDAO.ensureProjectExists(project1.getProjKey());
    }
}

