/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model.dao;

import com.atlassian.crucible.spi.services.PermissionSchemeSearchCriteria;
import com.atlassian.crucible.spi.services.SearchCriteriaType;
import com.cenqua.crucible.model.PermissionScheme;
import com.cenqua.crucible.model.dao.Generators;
import com.cenqua.crucible.model.dao.HibernatePermissionSchemeDAO;
import java.io.Serializable;
import org.apache.commons.lang3.SerializationUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.transaction.TransactionConfiguration;
import org.springframework.transaction.annotation.Transactional;
import org.unitils.reflectionassert.ReflectionAssert;
import org.unitils.reflectionassert.ReflectionComparatorMode;

@TransactionConfiguration(defaultRollback=true)
@ContextConfiguration(value={"classpath:/tests-db-spring-context-level3-manager.xml"})
@Transactional
@RunWith(value=SpringJUnit4ClassRunner.class)
@DirtiesContext
public class HibernatePermissionSchemeDAOTest {
    @Autowired
    private HibernatePermissionSchemeDAO permissionSchemeDAO;

    @Test
    public void testAddAndListOrder() throws Exception {
        Assert.assertThat((Object)this.permissionSchemeDAO.list(), (Matcher)CoreMatchers.is((Matcher)Matchers.empty()));
        PermissionScheme permissionScheme1 = Generators.generatePermissionScheme("AAAA");
        this.permissionSchemeDAO.add(permissionScheme1);
        Assert.assertThat((Object)this.permissionSchemeDAO.list(), (Matcher)Matchers.contains((Object[])new PermissionScheme[]{permissionScheme1}));
        PermissionScheme permissionScheme2 = Generators.generatePermissionScheme("CCCC");
        this.permissionSchemeDAO.add(permissionScheme2);
        Assert.assertThat((Object)this.permissionSchemeDAO.list(), (Matcher)Matchers.contains((Object[])new PermissionScheme[]{permissionScheme1, permissionScheme2}));
        PermissionScheme permissionScheme3 = Generators.generatePermissionScheme("BBBB");
        this.permissionSchemeDAO.add(permissionScheme3);
        Assert.assertThat((Object)this.permissionSchemeDAO.list(), (Matcher)Matchers.contains((Object[])new PermissionScheme[]{permissionScheme1, permissionScheme3, permissionScheme2}));
    }

    @Test
    public void testEnsureProjectExistsPositive() throws Exception {
        PermissionScheme permissionScheme1 = Generators.generatePermissionScheme("AAAA");
        this.permissionSchemeDAO.add(permissionScheme1);
        Assert.assertThat((Object)this.permissionSchemeDAO.ensurePermissionSchemeExists(permissionScheme1.getName()), (Matcher)Matchers.equalTo((Object)permissionScheme1));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEnsureProjectExistsNegative() throws Exception {
        PermissionScheme permissionScheme1 = Generators.generatePermissionScheme("AAAA");
        this.permissionSchemeDAO.ensurePermissionSchemeExists(permissionScheme1.getName());
    }

    @Test
    public void testDelete() throws Exception {
        Assert.assertThat((Object)this.permissionSchemeDAO.list(), (Matcher)CoreMatchers.is((Matcher)Matchers.empty()));
        PermissionScheme permissionScheme1 = Generators.generatePermissionScheme("AAA");
        this.permissionSchemeDAO.add(permissionScheme1);
        PermissionScheme permissionScheme2 = Generators.generatePermissionScheme("CCC");
        this.permissionSchemeDAO.add(permissionScheme2);
        PermissionScheme permissionScheme3 = Generators.generatePermissionScheme("BBB");
        this.permissionSchemeDAO.add(permissionScheme3);
        Assert.assertThat((Object)this.permissionSchemeDAO.list(), (Matcher)Matchers.contains((Object[])new PermissionScheme[]{permissionScheme1, permissionScheme3, permissionScheme2}));
        this.permissionSchemeDAO.delete(permissionScheme3);
        Assert.assertThat((Object)this.permissionSchemeDAO.list(), (Matcher)Matchers.contains((Object[])new PermissionScheme[]{permissionScheme1, permissionScheme2}));
        this.permissionSchemeDAO.delete(permissionScheme1);
        Assert.assertThat((Object)this.permissionSchemeDAO.list(), (Matcher)Matchers.contains((Object[])new PermissionScheme[]{permissionScheme2}));
        this.permissionSchemeDAO.delete(permissionScheme2);
        Assert.assertThat((Object)this.permissionSchemeDAO.list(), (Matcher)CoreMatchers.is((Matcher)Matchers.empty()));
    }

    @Test
    public void testGetPermissionSchemeById() throws Exception {
        PermissionScheme permissionScheme1 = Generators.generatePermissionScheme();
        this.permissionSchemeDAO.add(permissionScheme1);
        PermissionScheme permissionScheme1Copy = (PermissionScheme)SerializationUtils.clone((Serializable)permissionScheme1);
        PermissionScheme permissionScheme2 = Generators.generatePermissionScheme();
        this.permissionSchemeDAO.add(permissionScheme2);
        PermissionScheme permissionScheme2Copy = (PermissionScheme)SerializationUtils.clone((Serializable)permissionScheme2);
        ReflectionAssert.assertReflectionEquals((Object)this.permissionSchemeDAO.getById(permissionScheme1.getId()), (Object)permissionScheme1Copy, (ReflectionComparatorMode[])new ReflectionComparatorMode[0]);
        ReflectionAssert.assertReflectionEquals((Object)this.permissionSchemeDAO.getById(permissionScheme2.getId()), (Object)permissionScheme2Copy, (ReflectionComparatorMode[])new ReflectionComparatorMode[0]);
    }

    @Test
    public void testGetPermissionSchemeByName() throws Exception {
        PermissionScheme permissionScheme1 = Generators.generatePermissionScheme();
        this.permissionSchemeDAO.add(permissionScheme1);
        PermissionScheme permissionScheme1Copy = (PermissionScheme)SerializationUtils.clone((Serializable)permissionScheme1);
        PermissionScheme permissionScheme2 = Generators.generatePermissionScheme();
        this.permissionSchemeDAO.add(permissionScheme2);
        PermissionScheme permissionScheme2Copy = (PermissionScheme)SerializationUtils.clone((Serializable)permissionScheme2);
        ReflectionAssert.assertReflectionEquals((Object)this.permissionSchemeDAO.getByName(permissionScheme1.getName()), (Object)permissionScheme1Copy, (ReflectionComparatorMode[])new ReflectionComparatorMode[0]);
        ReflectionAssert.assertReflectionEquals((Object)this.permissionSchemeDAO.getByName(permissionScheme2.getName()), (Object)permissionScheme2Copy, (ReflectionComparatorMode[])new ReflectionComparatorMode[0]);
    }

    @Test
    public void testCountPermissionSchemesPartialMatch() throws Exception {
        Assert.assertThat((Object)this.permissionSchemeDAO.countPermissionSchemes(PermissionSchemeSearchCriteria.create((SearchCriteriaType)SearchCriteriaType.PARTIAL_MATCH).all()), (Matcher)CoreMatchers.is((Object)0));
        PermissionScheme permissionScheme1 = Generators.generatePermissionScheme();
        permissionScheme1.setName("AAAAAAA");
        this.permissionSchemeDAO.add(permissionScheme1);
        Assert.assertThat((Object)this.permissionSchemeDAO.countPermissionSchemes(PermissionSchemeSearchCriteria.create((SearchCriteriaType)SearchCriteriaType.PARTIAL_MATCH).all()), (Matcher)CoreMatchers.is((Object)1));
        PermissionScheme permissionScheme2 = Generators.generatePermissionScheme();
        permissionScheme2.setName("BBBBBBB");
        this.permissionSchemeDAO.add(permissionScheme2);
        Assert.assertThat((Object)this.permissionSchemeDAO.countPermissionSchemes(PermissionSchemeSearchCriteria.create((SearchCriteriaType)SearchCriteriaType.PARTIAL_MATCH).all()), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)this.permissionSchemeDAO.countPermissionSchemes(PermissionSchemeSearchCriteria.create((SearchCriteriaType)SearchCriteriaType.PARTIAL_MATCH).name("AA")), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)this.permissionSchemeDAO.countPermissionSchemes(PermissionSchemeSearchCriteria.create((SearchCriteriaType)SearchCriteriaType.PARTIAL_MATCH).name("aa")), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)this.permissionSchemeDAO.countPermissionSchemes(PermissionSchemeSearchCriteria.create((SearchCriteriaType)SearchCriteriaType.PARTIAL_MATCH).name("BBBB")), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)this.permissionSchemeDAO.countPermissionSchemes(PermissionSchemeSearchCriteria.create((SearchCriteriaType)SearchCriteriaType.PARTIAL_MATCH).name("nonexisting")), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void testCountPermissionSchemesExactMatch() throws Exception {
        Assert.assertThat((Object)this.permissionSchemeDAO.countPermissionSchemes(PermissionSchemeSearchCriteria.create((SearchCriteriaType)SearchCriteriaType.EXACT_MATCH).all()), (Matcher)CoreMatchers.is((Object)0));
        PermissionScheme permissionScheme1 = Generators.generatePermissionScheme();
        permissionScheme1.setName("AAAAAAA");
        this.permissionSchemeDAO.add(permissionScheme1);
        Assert.assertThat((Object)this.permissionSchemeDAO.countPermissionSchemes(PermissionSchemeSearchCriteria.create((SearchCriteriaType)SearchCriteriaType.EXACT_MATCH).all()), (Matcher)CoreMatchers.is((Object)1));
        PermissionScheme permissionScheme2 = Generators.generatePermissionScheme();
        permissionScheme2.setName("BBBBBBB");
        this.permissionSchemeDAO.add(permissionScheme2);
        Assert.assertThat((Object)this.permissionSchemeDAO.countPermissionSchemes(PermissionSchemeSearchCriteria.create((SearchCriteriaType)SearchCriteriaType.EXACT_MATCH).all()), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)this.permissionSchemeDAO.countPermissionSchemes(PermissionSchemeSearchCriteria.create((SearchCriteriaType)SearchCriteriaType.EXACT_MATCH).name("AAAAAAA")), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)this.permissionSchemeDAO.countPermissionSchemes(PermissionSchemeSearchCriteria.create((SearchCriteriaType)SearchCriteriaType.EXACT_MATCH).name("aa")), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)this.permissionSchemeDAO.countPermissionSchemes(PermissionSchemeSearchCriteria.create((SearchCriteriaType)SearchCriteriaType.EXACT_MATCH).name("BBBBBBB")), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)this.permissionSchemeDAO.countPermissionSchemes(PermissionSchemeSearchCriteria.create((SearchCriteriaType)SearchCriteriaType.EXACT_MATCH).name("bbbbbbb")), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void testListPermissionSchemesExactMatch() throws Exception {
        Assert.assertThat((Object)this.permissionSchemeDAO.list(PermissionSchemeSearchCriteria.create((SearchCriteriaType)SearchCriteriaType.EXACT_MATCH).all(), 0, 100), (Matcher)CoreMatchers.is((Matcher)Matchers.empty()));
        PermissionScheme permissionScheme1 = Generators.generatePermissionScheme();
        permissionScheme1.setName("AAAAAAA");
        this.permissionSchemeDAO.add(permissionScheme1);
        Assert.assertThat((Object)this.permissionSchemeDAO.list(PermissionSchemeSearchCriteria.create((SearchCriteriaType)SearchCriteriaType.EXACT_MATCH).all(), 0, 100), (Matcher)Matchers.containsInAnyOrder((Object[])new PermissionScheme[]{permissionScheme1}));
        PermissionScheme permissionScheme2 = Generators.generatePermissionScheme();
        permissionScheme2.setName("BBBBBBB");
        this.permissionSchemeDAO.add(permissionScheme2);
        Assert.assertThat((Object)this.permissionSchemeDAO.list(PermissionSchemeSearchCriteria.create((SearchCriteriaType)SearchCriteriaType.EXACT_MATCH).all(), 0, 100), (Matcher)Matchers.containsInAnyOrder((Object[])new PermissionScheme[]{permissionScheme1, permissionScheme2}));
        Assert.assertThat((Object)this.permissionSchemeDAO.list(PermissionSchemeSearchCriteria.create((SearchCriteriaType)SearchCriteriaType.EXACT_MATCH).name("AAAAAAA"), 0, 100), (Matcher)Matchers.containsInAnyOrder((Object[])new PermissionScheme[]{permissionScheme1}));
        Assert.assertThat((Object)this.permissionSchemeDAO.list(PermissionSchemeSearchCriteria.create((SearchCriteriaType)SearchCriteriaType.EXACT_MATCH).name("aa"), 0, 100), (Matcher)CoreMatchers.is((Matcher)Matchers.empty()));
        Assert.assertThat((Object)this.permissionSchemeDAO.list(PermissionSchemeSearchCriteria.create((SearchCriteriaType)SearchCriteriaType.EXACT_MATCH).name("BBBBBBB"), 0, 100), (Matcher)Matchers.containsInAnyOrder((Object[])new PermissionScheme[]{permissionScheme2}));
        Assert.assertThat((Object)this.permissionSchemeDAO.list(PermissionSchemeSearchCriteria.create((SearchCriteriaType)SearchCriteriaType.EXACT_MATCH).name("bbbbbbb"), 0, 100), (Matcher)CoreMatchers.is((Matcher)Matchers.empty()));
    }
}

