/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model.dao;

import com.cenqua.crucible.hibernate.CurrentSessionProvider;
import com.cenqua.crucible.model.Patch;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.dao.HibernatePatchDAO;
import com.cenqua.crucible.model.dao.PatchDAO;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.Query;
import org.hibernate.Session;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.internal.verification.VerificationModeFactory;
import org.mockito.verification.VerificationMode;

public class HibernatePatchDAOTest {
    private Session session;
    private PatchDAO patchDAO;

    @Before
    public void setUp() throws Exception {
        CurrentSessionProvider currentSessionProvider = (CurrentSessionProvider)Mockito.mock(CurrentSessionProvider.class);
        this.session = (Session)Mockito.mock(Session.class);
        Mockito.when((Object)currentSessionProvider.currentSession()).thenReturn((Object)this.session);
        this.patchDAO = new HibernatePatchDAO(currentSessionProvider);
    }

    @Test
    public void testFindReviewPatches() throws Exception {
        Query query = (Query)Mockito.mock(Query.class);
        Review review = new Review();
        Patch patch1 = new Patch();
        Patch patch2 = new Patch();
        ArrayList patches = Lists.newArrayList((Object[])new Patch[]{patch1, patch2});
        Mockito.when((Object)this.session.createQuery(Matchers.anyString())).thenReturn((Object)query);
        Mockito.when((Object)query.list()).thenReturn((Object)patches);
        List result = this.patchDAO.findReviewPatches(review);
        ((Query)Mockito.verify((Object)query, (VerificationMode)VerificationModeFactory.times((int)1))).setEntity((String)Matchers.eq((Object)"review"), Matchers.same((Object)review));
        Assert.assertSame((Object)patches, (Object)result);
    }

    @Test
    public void testDeleteReviewPatches() throws Exception {
        Query query = (Query)Mockito.mock(Query.class);
        Review review = new Review();
        Mockito.when((Object)this.session.createQuery(Matchers.anyString())).thenReturn((Object)query);
        this.patchDAO.deleteReviewPatches(review);
        ((Query)Mockito.verify((Object)query, (VerificationMode)VerificationModeFactory.times((int)1))).setEntity((String)Matchers.eq((Object)"review"), Matchers.same((Object)review));
        ((Query)Mockito.verify((Object)query, (VerificationMode)VerificationModeFactory.times((int)1))).executeUpdate();
    }

    @Test
    public void testGetPatchById() throws Exception {
        Integer id = 5;
        Patch patch = new Patch();
        Mockito.when((Object)this.session.get((Class)Matchers.eq(Patch.class), (Serializable)Matchers.eq((Object)id))).thenReturn((Object)patch);
        Patch result = this.patchDAO.getPatchById(id);
        Assert.assertSame((Object)patch, (Object)result);
    }

    @Test
    public void testSavePatch() throws Exception {
        Patch patch = new Patch();
        this.patchDAO.savePatch(patch);
        ((Session)Mockito.verify((Object)this.session, (VerificationMode)VerificationModeFactory.times((int)1))).save(Matchers.same((Object)patch));
    }
}

