/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model.dao;

import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fecru.user.FecruUserDAO;
import com.cenqua.crucible.model.PermissionScheme;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.dao.FileRevisionExtraInfoCreator;
import com.cenqua.crucible.model.dao.FileRevisionExtraInfoDAO;
import com.cenqua.crucible.model.dao.Generators;
import com.cenqua.crucible.model.dao.HibernateFileRevisionExtraInfoDAO;
import com.cenqua.crucible.model.dao.HibernatePermissionSchemeDAO;
import com.cenqua.crucible.model.dao.HibernateProjectDAO;
import com.cenqua.crucible.model.dao.HibernateReviewDAO;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsCollectionWithSize;
import org.hibernate.SessionFactory;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.transaction.TransactionConfiguration;
import org.springframework.transaction.annotation.Transactional;

@TransactionConfiguration(defaultRollback=true)
@ContextConfiguration(value={"classpath:/tests-db-spring-context-level3-manager.xml"})
@Transactional
@RunWith(value=SpringJUnit4ClassRunner.class)
@DirtiesContext
public class HibernateFileRevisionExtraInfoDAOTest {
    @Autowired
    private HibernateFileRevisionExtraInfoDAO fileRevisionExtraInfoDAO;
    @Autowired
    private HibernateReviewDAO reviewDAO;
    @Autowired
    private FecruUserDAO userDAO;
    @Autowired
    private HibernateProjectDAO projectDAO;
    @Autowired
    private HibernatePermissionSchemeDAO permissionSchemeDAO;
    private Review review1;
    private Review review2;
    @Autowired
    private SessionFactory sessionFactory;

    @Before
    public void setUp() throws Exception {
        PermissionScheme permissionScheme = Generators.generatePermissionScheme();
        this.permissionSchemeDAO.add(permissionScheme);
        Project project = Generators.generateProject(permissionScheme);
        this.projectDAO.add(project);
        FecruUser user = Generators.generateUser();
        this.userDAO.create(user);
        this.review1 = Generators.generateReview(project, user);
        this.reviewDAO.add(this.review1);
        this.review2 = Generators.generateReview(project, user);
        this.reviewDAO.add(this.review2);
    }

    @Test
    public void testGetRevisionDetailsConsideredInReviews() throws Exception {
        String repo1 = "repository1";
        String repo2 = "repository2";
        String repo3 = "repository3";
        FileRevisionExtraInfoCreator fileRevisionExtraInfoCreator = new FileRevisionExtraInfoCreator(this.sessionFactory, (FileRevisionExtraInfoDAO)this.fileRevisionExtraInfoDAO);
        fileRevisionExtraInfoCreator.createFileRevisionExtraInfoWithCrucibleRevisionsForReviewFromRepositories(this.review1, "repository1", "repository1", "repository2");
        fileRevisionExtraInfoCreator.createFileRevisionExtraInfoWithCrucibleRevisionsForReviewFromRepositories(this.review1, "repository2", "repository2", "repository2");
        fileRevisionExtraInfoCreator.createFileRevisionExtraInfoWithCrucibleRevisionsForReviewFromRepositories(this.review1, "repository2", "repository3", "repository3");
        MatcherAssert.assertThat((Object)this.fileRevisionExtraInfoDAO.getRevisionDetailsConsideredInReviews("repository1"), (Matcher)IsCollectionWithSize.hasSize((int)2));
        MatcherAssert.assertThat((Object)this.fileRevisionExtraInfoDAO.getRevisionDetailsConsideredInReviews("repository2"), (Matcher)IsCollectionWithSize.hasSize((int)5));
        MatcherAssert.assertThat((Object)this.fileRevisionExtraInfoDAO.getRevisionDetailsConsideredInReviews("repository3"), (Matcher)IsCollectionWithSize.hasSize((int)2));
    }
}

