/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model.dao;

import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fecru.user.FecruUserDAO;
import com.cenqua.crucible.model.CrucibleActivityItem;
import com.cenqua.crucible.model.PermissionScheme;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.dao.Generators;
import com.cenqua.crucible.model.dao.HibernateCrucibleActivityItemDAO;
import com.cenqua.crucible.model.dao.HibernatePermissionSchemeDAO;
import com.cenqua.crucible.model.dao.HibernateProjectDAO;
import com.cenqua.crucible.model.dao.HibernateReviewDAO;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.transaction.TransactionConfiguration;
import org.springframework.transaction.annotation.Transactional;

@TransactionConfiguration(defaultRollback=true)
@ContextConfiguration(value={"classpath:/tests-db-spring-context-level3-manager.xml"})
@Transactional
@RunWith(value=SpringJUnit4ClassRunner.class)
@DirtiesContext
public class HibernateCrucibleActivityItemDAOTest {
    @Autowired
    private HibernateCrucibleActivityItemDAO crucibleActivityItemDAO;
    @Autowired
    private HibernateReviewDAO reviewDAO;
    @Autowired
    private FecruUserDAO userDAO;
    @Autowired
    private HibernateProjectDAO projectDAO;
    @Autowired
    private HibernatePermissionSchemeDAO permissionSchemeDAO;
    private Review review1;
    private Review review2;

    @Before
    public void setUp() throws Exception {
        PermissionScheme permissionScheme = Generators.generatePermissionScheme();
        this.permissionSchemeDAO.add(permissionScheme);
        Project project = Generators.generateProject(permissionScheme);
        this.projectDAO.add(project);
        FecruUser user = Generators.generateUser();
        this.userDAO.create(user);
        this.review1 = Generators.generateReview(project, user);
        this.reviewDAO.add(this.review1);
        this.review2 = Generators.generateReview(project, user);
        this.reviewDAO.add(this.review2);
    }

    @Test
    public void testDeleteCrucibleActivityItems() throws Exception {
        CrucibleActivityItem crucibleActivityItem1a = Generators.generateCrucibleActivityItem(this.review1);
        CrucibleActivityItem crucibleActivityItem1b = Generators.generateCrucibleActivityItem(this.review1);
        CrucibleActivityItem crucibleActivityItem2a = Generators.generateCrucibleActivityItem(this.review2);
        CrucibleActivityItem crucibleActivityItem2b = Generators.generateCrucibleActivityItem(this.review2);
        this.crucibleActivityItemDAO.add(crucibleActivityItem1a);
        this.crucibleActivityItemDAO.add(crucibleActivityItem1b);
        this.crucibleActivityItemDAO.add(crucibleActivityItem2a);
        this.crucibleActivityItemDAO.add(crucibleActivityItem2b);
        MatcherAssert.assertThat((Object)this.crucibleActivityItemDAO.list(), (Matcher)Matchers.containsInAnyOrder((Object[])new CrucibleActivityItem[]{crucibleActivityItem1a, crucibleActivityItem1b, crucibleActivityItem2a, crucibleActivityItem2b}));
        this.crucibleActivityItemDAO.deleteWithReview(this.review2);
        MatcherAssert.assertThat((Object)this.crucibleActivityItemDAO.list(), (Matcher)Matchers.containsInAnyOrder((Object[])new CrucibleActivityItem[]{crucibleActivityItem1a, crucibleActivityItem1b}));
        this.crucibleActivityItemDAO.deleteWithReview(this.review1);
        MatcherAssert.assertThat((Object)this.crucibleActivityItemDAO.list(), (Matcher)CoreMatchers.is((Matcher)Matchers.empty()));
    }
}

