/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model.dao;

import com.cenqua.crucible.model.PermissionScheme;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.dao.Generators;
import com.cenqua.crucible.model.dao.HibernateContentRootDAO;
import com.cenqua.crucible.model.dao.HibernatePermissionSchemeDAO;
import com.cenqua.crucible.model.dao.HibernateProjectDAO;
import com.cenqua.fisheye.model.ContentRoot;
import java.io.Serializable;
import org.apache.commons.lang3.SerializationUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hibernate.SessionFactory;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.transaction.TransactionConfiguration;
import org.springframework.transaction.annotation.Transactional;
import org.unitils.reflectionassert.ReflectionAssert;
import org.unitils.reflectionassert.ReflectionComparatorMode;

@TransactionConfiguration(defaultRollback=true)
@ContextConfiguration(value={"classpath:/tests-db-spring-context-level3-manager.xml"})
@Transactional
@RunWith(value=SpringJUnit4ClassRunner.class)
@DirtiesContext
public class HibernateContentRootDAOTest {
    @Autowired
    private HibernateContentRootDAO contentRootDAO;
    @Autowired
    private HibernateProjectDAO projectDAO;
    @Autowired
    private HibernatePermissionSchemeDAO permissionSchemeDAO;
    @Autowired
    private SessionFactory sessionFactory;
    private PermissionScheme permissionScheme;
    private Project project;

    @Before
    public void setUp() throws Exception {
        this.permissionScheme = Generators.generatePermissionScheme();
        this.permissionSchemeDAO.add(this.permissionScheme);
        this.project = Generators.generateProject(this.permissionScheme);
        this.projectDAO.add(this.project);
    }

    @Test
    public void testApplicationContextSetUp() throws Exception {
        MatcherAssert.assertThat((Object)this.contentRootDAO, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)this.sessionFactory, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)this.permissionScheme, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)this.project, (Matcher)Matchers.notNullValue());
    }

    @Test
    public void testAdd() throws Exception {
        MatcherAssert.assertThat((Object)this.contentRootDAO.list(), (Matcher)CoreMatchers.is((Matcher)Matchers.empty()));
        ContentRoot contentRoot1 = Generators.generateContentRoot(this.project);
        this.contentRootDAO.add(contentRoot1);
        MatcherAssert.assertThat((Object)this.contentRootDAO.list(), (Matcher)Matchers.contains((Object[])new ContentRoot[]{contentRoot1}));
        ContentRoot contentRoot2 = Generators.generateContentRoot(this.project);
        this.contentRootDAO.add(contentRoot2);
        MatcherAssert.assertThat((Object)this.contentRootDAO.list(), (Matcher)Matchers.contains((Object[])new ContentRoot[]{contentRoot1, contentRoot2}));
    }

    @Test
    public void testDelete() throws Exception {
        ContentRoot contentRoot1 = Generators.generateContentRoot(this.project);
        this.contentRootDAO.add(contentRoot1);
        ContentRoot contentRoot2 = Generators.generateContentRoot(this.project);
        this.contentRootDAO.add(contentRoot2);
        MatcherAssert.assertThat((Object)this.contentRootDAO.list(), (Matcher)Matchers.contains((Object[])new ContentRoot[]{contentRoot1, contentRoot2}));
        this.contentRootDAO.delete(contentRoot1);
        MatcherAssert.assertThat((Object)this.contentRootDAO.list(), (Matcher)Matchers.contains((Object[])new ContentRoot[]{contentRoot2}));
        this.contentRootDAO.delete(contentRoot2);
        MatcherAssert.assertThat((Object)this.contentRootDAO.list(), (Matcher)CoreMatchers.is((Matcher)Matchers.empty()));
    }

    @Test
    public void testDeleteByProjectIdRepositoryPath() throws Exception {
        ContentRoot contentRoot1 = Generators.generateContentRoot(this.project);
        this.contentRootDAO.add(contentRoot1);
        ContentRoot contentRoot2 = Generators.generateContentRoot(this.project);
        this.contentRootDAO.add(contentRoot2);
        MatcherAssert.assertThat((Object)this.contentRootDAO.list(), (Matcher)Matchers.contains((Object[])new ContentRoot[]{contentRoot1, contentRoot2}));
        this.contentRootDAO.deleteByProjectIdRepositoryPath(contentRoot1.getProject().getId(), contentRoot1.getRepName(), contentRoot1.getPath());
        MatcherAssert.assertThat((Object)this.contentRootDAO.list(), (Matcher)Matchers.contains((Object[])new ContentRoot[]{contentRoot2}));
        this.contentRootDAO.deleteByProjectIdRepositoryPath(contentRoot2.getProject().getId(), contentRoot2.getRepName(), contentRoot2.getPath());
        MatcherAssert.assertThat((Object)this.contentRootDAO.list(), (Matcher)CoreMatchers.is((Matcher)Matchers.empty()));
    }

    @Test
    public void testGetById() throws Exception {
        ContentRoot contentRoot1 = Generators.generateContentRoot(this.project);
        this.contentRootDAO.add(contentRoot1);
        ContentRoot contentRootCopy1 = (ContentRoot)SerializationUtils.clone((Serializable)contentRoot1);
        ContentRoot contentRoot2 = Generators.generateContentRoot(this.project);
        this.contentRootDAO.add(contentRoot2);
        ContentRoot contentRootCopy2 = (ContentRoot)SerializationUtils.clone((Serializable)contentRoot2);
        ReflectionAssert.assertReflectionEquals((Object)this.contentRootDAO.getById(contentRoot1.getId()), (Object)contentRootCopy1, (ReflectionComparatorMode[])new ReflectionComparatorMode[0]);
        ReflectionAssert.assertReflectionEquals((Object)this.contentRootDAO.getById(contentRoot2.getId()), (Object)contentRootCopy2, (ReflectionComparatorMode[])new ReflectionComparatorMode[0]);
    }

    @Test
    public void testGetByProjectRepositoryPath() throws Exception {
        ContentRoot contentRoot1 = Generators.generateContentRoot(this.project);
        this.contentRootDAO.add(contentRoot1);
        ContentRoot contentRoot2 = Generators.generateContentRoot(this.project);
        this.contentRootDAO.add(contentRoot2);
        MatcherAssert.assertThat((Object)this.contentRootDAO.getByProjectRepositoryPath(this.project, contentRoot1.getRepName(), contentRoot1.getPath()), (Matcher)CoreMatchers.equalTo((Object)contentRoot1));
        MatcherAssert.assertThat((Object)this.contentRootDAO.getByProjectRepositoryPath(this.project, contentRoot2.getRepName(), contentRoot2.getPath()), (Matcher)CoreMatchers.equalTo((Object)contentRoot2));
    }

    @Test
    public void testListWithRepositoryName() throws Exception {
        ContentRoot contentRoot1 = Generators.generateContentRoot(this.project);
        this.contentRootDAO.add(contentRoot1);
        ContentRoot contentRoot2 = Generators.generateContentRoot(this.project);
        this.contentRootDAO.add(contentRoot2);
        MatcherAssert.assertThat((Object)this.contentRootDAO.listWithRepositoryName(contentRoot1.getRepName()), (Matcher)Matchers.contains((Object[])new ContentRoot[]{contentRoot1}));
        MatcherAssert.assertThat((Object)this.contentRootDAO.listWithRepositoryName(contentRoot2.getRepName()), (Matcher)Matchers.contains((Object[])new ContentRoot[]{contentRoot2}));
    }
}

