/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model.dao;

import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.model.CrucibleActivityItem;
import com.cenqua.crucible.model.FileRevisionExtraInfo;
import com.cenqua.crucible.model.PermissionScheme;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.ReviewPermaId;
import com.cenqua.fisheye.model.ContentRoot;
import java.util.Date;
import java.util.Random;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.sf.ehcache.store.chm.ConcurrentHashMap;

public class Generators {
    private static final Random rnd = new Random();
    private static final ConcurrentMap<String, AtomicInteger> sequenceGenerator = new ConcurrentHashMap();

    public static ContentRoot generateContentRoot(Project project) {
        return new ContentRoot(project, Generators.generateRepositoryName(), Generators.generatePath());
    }

    public static Project generateProject(PermissionScheme permissionScheme, String key) {
        Project project = new Project();
        project.setProjKey(key);
        project.setName("project_name_" + key);
        project.setStoreRevisions(true);
        project.setPermissionScheme(permissionScheme);
        project.setDefaultRepositoryName("repo" + rnd.nextInt());
        return project;
    }

    public static Project generateProject(PermissionScheme permissionScheme) {
        return Generators.generateProject(permissionScheme, "" + rnd.nextInt());
    }

    public static String generateRepositoryName() {
        return "repository_" + rnd.nextInt();
    }

    public static String generatePath() {
        return "path_" + rnd.nextInt();
    }

    public static PermissionScheme generatePermissionScheme(String suffix) {
        PermissionScheme permissionScheme = new PermissionScheme();
        permissionScheme.setName("permissionScheme_" + suffix);
        return permissionScheme;
    }

    public static PermissionScheme generatePermissionScheme() {
        return Generators.generatePermissionScheme("" + rnd.nextInt());
    }

    public static Review generateReview(Project project, FecruUser creator) {
        return Generators.generateReview(project, creator, false);
    }

    public static Review generateReview(Project project, FecruUser creator, boolean addPermaId) {
        Review review = new Review();
        review.setCreator(creator);
        review.setProject(project);
        review.setJiraIssueKey("TestJiraKey-" + rnd.nextInt());
        review.setCreateDate(new Date());
        review.setName("ReviewName" + rnd.nextInt());
        review.setDescription("ReviewDescription" + rnd.nextInt());
        review.setStateName("Review");
        if (addPermaId) {
            review.getPermaIdHistory().add(Generators.generateReviewPermaId(review));
        }
        return review;
    }

    public static FecruUser generateUser(String username) {
        return new FecruUser(username);
    }

    public static FecruUser generateUser() {
        return Generators.generateUser(Generators.generateUsername());
    }

    public static String generateUsername() {
        return "test_user_" + rnd.nextInt(Integer.MAX_VALUE);
    }

    public static ReviewPermaId generateReviewPermaId(Review review, String prefix, int number) {
        return new ReviewPermaId(review, prefix, number);
    }

    public static ReviewPermaId generateReviewPermaId(Review review) {
        String key = review.getProject().getProjKey();
        return Generators.generateReviewPermaId(review, review.getProject().getProjKey(), Generators.genId(key));
    }

    public static int genId(String key) {
        sequenceGenerator.putIfAbsent(key, new AtomicInteger(0));
        return ((AtomicInteger)sequenceGenerator.get(key)).incrementAndGet();
    }

    public static CrucibleActivityItem generateCrucibleActivityItem(Review review) {
        CrucibleActivityItem crucibleActivityItem = new CrucibleActivityItem();
        crucibleActivityItem.setReview(review);
        crucibleActivityItem.setAction("action_" + rnd.nextInt());
        return crucibleActivityItem;
    }

    public static FileRevisionExtraInfo generateFileRevisionExtraInfo(Review review) {
        return new FileRevisionExtraInfo(review, new Date());
    }
}

