/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model.dao;

import com.cenqua.crucible.model.CrucibleRevision;
import com.cenqua.crucible.model.FRXRevision;
import com.cenqua.crucible.model.FileRevisionExtraInfo;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.StoredPath;
import com.cenqua.crucible.model.dao.FileRevisionExtraInfoDAO;
import com.cenqua.crucible.model.dao.Generators;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Random;
import org.hibernate.SessionFactory;

public class FileRevisionExtraInfoCreator {
    private final SessionFactory sessionFactory;
    private final FileRevisionExtraInfoDAO fileRevisionExtraInfoDAO;

    public FileRevisionExtraInfoCreator(SessionFactory sessionFactory, FileRevisionExtraInfoDAO fileRevisionExtraInfoDAO) {
        this.sessionFactory = sessionFactory;
        this.fileRevisionExtraInfoDAO = fileRevisionExtraInfoDAO;
    }

    public FileRevisionExtraInfo createFileRevisionExtraInfoWithCrucibleRevisionsForReviewFromRepositories(Review review, String ... repositoryNames) {
        Random rnd = new Random();
        FileRevisionExtraInfo fileRevisionExtraInfo = Generators.generateFileRevisionExtraInfo(review);
        fileRevisionExtraInfo.setShowAsDiff(Boolean.valueOf(false));
        this.fileRevisionExtraInfoDAO.add(fileRevisionExtraInfo);
        ArrayList frxRevisions = Lists.newArrayList();
        for (String repositoryName : repositoryNames) {
            StoredPath storedPath = this.add(new StoredPath("path_" + rnd.nextInt(), "hash_" + rnd.nextInt()));
            CrucibleRevision cr = this.add(new CrucibleRevision(repositoryName, storedPath, "rev_" + rnd.nextInt(), "revDisplayName_" + rnd.nextInt(), new Date()));
            FRXRevision frxRevision = this.add(new FRXRevision(fileRevisionExtraInfo, cr, new Date()));
            frxRevision.setOrder(1);
            frxRevisions.add(frxRevision);
        }
        fileRevisionExtraInfo.setFrxRevisions((List)frxRevisions);
        return fileRevisionExtraInfo;
    }

    private StoredPath add(StoredPath storedPath) {
        this.sessionFactory.getCurrentSession().save((Object)storedPath);
        return storedPath;
    }

    private CrucibleRevision add(CrucibleRevision crucibleRevision) {
        this.sessionFactory.getCurrentSession().save((Object)crucibleRevision);
        return crucibleRevision;
    }

    private FRXRevision add(FRXRevision frxRevision) {
        this.sessionFactory.getCurrentSession().save((Object)frxRevision);
        return frxRevision;
    }
}

