/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model;

import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.model.Comment;
import com.cenqua.crucible.model.CrucibleRevision;
import com.cenqua.crucible.model.FRXComment;
import com.cenqua.crucible.model.FileRevisionExtraInfo;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.managers.CommentManager;
import com.cenqua.crucible.model.managers.FRXCommentManager;
import com.cenqua.crucible.model.managers.FRXManager;
import com.cenqua.crucible.model.managers.FileRevisionManager;
import com.cenqua.crucible.util.UseTestSpringContextTestCase;
import com.cenqua.dbutils.ModelUtils;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.rep.TestFishEyeInstances;
import java.util.Date;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RevisionCommentTest
extends UseTestSpringContextTestCase {
    private FRXComment rcomment1;
    private FRXComment rcomment2;
    private CommentManager commentManager;

    @Before
    public void setUp() throws Exception {
        TestFishEyeInstances.loadSanity1();
        this.commentManager = (CommentManager)SpringContext.getComponent((String)"commentManager");
    }

    @After
    public void tearDown() throws Exception {
        HibernateUtil.closeSession();
        TestFishEyeInstances.stop();
    }

    @Test
    public void testEquals() throws Exception {
        FRXComment c1 = new FRXComment();
        FRXComment c2 = new FRXComment();
        Assert.assertEquals((Object)false, (Object)c1.equals((Object)"blah"));
        Assert.assertEquals((Object)true, (Object)c1.equals((Object)c1));
        try {
            c1.hashCode();
            Assert.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Assert.assertEquals((Object)false, (Object)c1.equals((Object)c2));
        HibernateUtil.beginTransaction();
        Review review = ModelUtils.createBlankTestReview("testreview");
        HibernateUtil.commitTransaction();
        HibernateUtil.beginTransaction();
        Comment comment1 = this.commentManager.createComment("test comment 1", review, review.getAuthor());
        Comment comment2 = this.commentManager.createComment("test comment 2", review, review.getAuthor());
        CrucibleRevision crucibleRev1 = FileRevisionManager.createRevision((String)"svn", (String)"/a/fake/path.c", (String)"d2225", (String)"d2225", (Date)new Date());
        CrucibleRevision crucibleRev2 = FileRevisionManager.createRevision((String)"svn", (String)"/a/fake/path.c", (String)"d2226", (String)"d2226", (Date)new Date());
        FileRevisionExtraInfo frx1 = FRXManager.createAndAddFRX((CrucibleRevision)crucibleRev1, (Review)review);
        FileRevisionExtraInfo frx2 = FRXManager.createAndAddFRX((CrucibleRevision)crucibleRev2, (Review)review);
        this.rcomment1 = FRXCommentManager.createAndAddFrxComment((Comment)comment1, (FileRevisionExtraInfo)frx1);
        this.rcomment2 = FRXCommentManager.createAndAddFrxComment((Comment)comment2, (FileRevisionExtraInfo)frx2);
        Assert.assertEquals((Object)false, (Object)this.rcomment1.equals(null));
        Assert.assertEquals((Object)false, (Object)c1.equals((Object)this.rcomment1));
        Assert.assertEquals((Object)true, (Object)this.rcomment2.equals((Object)this.rcomment2));
        Assert.assertEquals((Object)true, (Object)this.rcomment1.equals((Object)this.rcomment1));
        Assert.assertEquals((Object)false, (Object)this.rcomment1.equals((Object)this.rcomment2));
        Assert.assertEquals((Object)false, (Object)(this.rcomment1.hashCode() == this.rcomment2.hashCode() ? 1 : 0));
        HibernateUtil.commitTransaction();
        Fred t = new Fred();
        System.out.println("Starting thread");
        t.start();
        t.join();
    }

    private class Fred
    extends Thread {
        private Fred() {
        }

        @Override
        public void run() {
            HibernateUtil.beginTransaction();
            FRXComment c1 = FRXCommentManager.getById((Integer)RevisionCommentTest.this.rcomment1.getId());
            FRXComment c2 = FRXCommentManager.getById((Integer)RevisionCommentTest.this.rcomment2.getId());
            Assert.assertEquals((Object)true, (Object)RevisionCommentTest.this.rcomment1.equals((Object)c1));
            Assert.assertEquals((Object)true, (Object)RevisionCommentTest.this.rcomment2.equals((Object)c2));
            Assert.assertEquals((Object)false, (Object)RevisionCommentTest.this.rcomment1.equals((Object)c2));
            HibernateUtil.commitTransaction();
            HibernateUtil.closeSession();
        }
    }
}

