/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model;

import com.atlassian.crucible.filters.CrucibleFilter;
import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.managers.InviteManager;
import com.cenqua.dbutils.ModelUtils;
import com.cenqua.fisheye.rep.TestFishEyeInstances;
import com.cenqua.fisheye.util.Disposer;
import com.cenqua.fisheye.util.TestUtil;
import com.cenqua.fisheye.web.filters.DummyHttpServletRequest;
import java.util.List;
import javax.servlet.ServletRequest;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public final class ReviewTest {
    private Review review;
    private String invite1 = "invite1@test.com";
    private String invite2 = "invite2@test.com";
    private String existingUser = "user@test.com";
    private FecruUser existingCruUser;
    private String invalid = "invalid";

    @Before
    public void setUp() throws Exception {
        TestFishEyeInstances.stop();
        Disposer.pushThreadInstance();
        TestFishEyeInstances.getSanity1Repos();
        CrucibleFilter.setContext((CrucibleFilter.Context)new CrucibleFilter.Context((ServletRequest)new DummyHttpServletRequest(), null));
        TestUtil.addFisheyeUser("existinguser", "Existing User", this.existingUser);
        this.existingCruUser = ModelUtils.makeAndSaveUser("existinguser");
        this.review = new Review();
        HibernateUtil.beginTransaction();
        HibernateUtil.currentSession().save((Object)this.review);
        HibernateUtil.commitTransaction();
        FecruUser author = ModelUtils.makeAndSaveUser("author");
        this.review.setAuthor(author);
        this.review.setModerator(author);
    }

    @After
    public void tearDown() throws Exception {
        CrucibleFilter.setContext(null);
        HibernateUtil.forceRollbackTransaction();
        HibernateUtil.closeSession();
        Disposer.popThreadInstance();
        TestFishEyeInstances.stop();
    }

    @Test
    public void testInviteReviewer() throws Exception {
        HibernateUtil.beginTransaction();
        Assert.assertTrue((boolean)InviteManager.inviteReviewer((String)this.invite1, (Review)this.review, (FecruUser)this.existingCruUser).isEmpty());
        Assert.assertTrue((boolean)InviteManager.inviteReviewer((String)this.invite2, (Review)this.review, (FecruUser)this.existingCruUser).isEmpty());
        HibernateUtil.commitTransaction();
        Assert.assertEquals((int)2, (int)this.review.getInvitees().size());
        HibernateUtil.beginTransaction();
        this.review.removeInviteReviewer(this.invite1);
        Assert.assertEquals((String)(this.existingUser + " is already in the user database."), (String)((String)InviteManager.inviteReviewer((String)this.existingUser, (Review)this.review, (FecruUser)this.existingCruUser).get(0)));
        Assert.assertEquals((String)(this.invalid + " is not a valid email address, and was not added."), (String)((String)InviteManager.inviteReviewer((String)this.invalid, (Review)this.review, (FecruUser)this.existingCruUser).get(0)));
        HibernateUtil.commitTransaction();
        Assert.assertEquals((int)1, (int)this.review.getInvitees().size());
        HibernateUtil.beginTransaction();
        List messages = InviteManager.inviteReviewer((String)(this.invite1 + "," + this.invite2), (Review)this.review, (FecruUser)this.existingCruUser);
        Assert.assertTrue((messages.size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((String)(this.invite2 + " is already invited to this review."), (String)((String)messages.get(0)));
        HibernateUtil.commitTransaction();
        Assert.assertEquals((int)2, (int)this.review.getInvitees().size());
    }

    @Test
    public void testDeleteInviteUser() throws Exception {
        HibernateUtil.beginTransaction();
        InviteManager.inviteReviewer((String)this.invite1, (Review)this.review, (FecruUser)this.existingCruUser);
        HibernateUtil.commitTransaction();
        HibernateUtil.beginTransaction();
        InviteManager.deleteCrucibleInviteUser((String)this.invite1, (FecruUser)this.existingCruUser);
        HibernateUtil.commitTransaction();
        Assert.assertTrue((String)"Invitees should be empty", (boolean)this.review.getInvitees().isEmpty());
        Assert.assertTrue((String)"Team size incorrect", (this.review.getTeam().size() == 2 ? 1 : 0) != 0);
    }
}

