/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model;

import com.atlassian.crucible.activity.lucene.ReviewItemIndexer;
import com.atlassian.fecru.review.ParticipantDAO;
import com.atlassian.fecru.review.ParticipantDAOImpl;
import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.hibernate.CurrentSessionProvider;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.hibernate.HibernateUtilCurrentSessionProvider;
import com.cenqua.crucible.model.CrucibleRevision;
import com.cenqua.crucible.model.FileRevisionExtraInfo;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.ReviewParticipant;
import com.cenqua.crucible.model.managers.FRXManager;
import com.cenqua.crucible.model.managers.FileRevisionManager;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.model.managers.UnreadFileManager;
import com.cenqua.crucible.model.managers.impl.DefaultReviewManager;
import com.cenqua.crucible.util.DummyReviewItemIndexer;
import com.cenqua.dbutils.ModelUtils;
import com.cenqua.fisheye.rep.TestFishEyeInstances;
import java.util.Date;
import junit.framework.Assert;
import org.hibernate.Session;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public final class ReviewParticipantTest {
    private ReviewParticipant p1;
    private ReviewParticipant p2;
    private DefaultReviewManager reviewManager;
    private ParticipantDAO participantDAO;

    @Before
    public void setUp() throws Exception {
        TestFishEyeInstances.loadSanity1();
        this.participantDAO = new ParticipantDAOImpl((CurrentSessionProvider)new HibernateUtilCurrentSessionProvider());
        this.reviewManager = ModelUtils.getReviewManagerWithMockedManagersAndRealDAOs();
        this.reviewManager.setReviewItemIndexer((ReviewItemIndexer)new DummyReviewItemIndexer());
        DefaultReviewManager.set((ReviewManager)this.reviewManager);
    }

    @After
    public void tearDown() throws Exception {
        HibernateUtil.rollbackTransactionIfNotCommitted();
        HibernateUtil.closeSession();
        TestFishEyeInstances.stop();
    }

    @Test
    public void testParticipantsRoles() throws Exception {
        FecruUser user = new FecruUser(Integer.valueOf(1), "matt");
        ReviewParticipant.ParticipantsRoles roles = ReviewParticipant.addToExistingRoles(null, (FecruUser)user, (boolean)true, (boolean)false, (boolean)false);
        Assert.assertEquals((String)"should be a reviewer", (boolean)true, (boolean)roles.reviewer);
        Assert.assertEquals((String)"should not be an author", (boolean)false, (boolean)roles.author);
        Assert.assertEquals((String)"should not be a moderator", (boolean)false, (boolean)roles.moderator);
        roles = ReviewParticipant.addToExistingRoles((ReviewParticipant.ParticipantsRoles)roles, (FecruUser)user, (boolean)true, (boolean)true, (boolean)false);
        Assert.assertEquals((String)"should not be a reviewer", (boolean)false, (boolean)roles.reviewer);
        Assert.assertEquals((String)"should be an author", (boolean)true, (boolean)roles.author);
        Assert.assertEquals((String)"should not be a moderator", (boolean)false, (boolean)roles.moderator);
        roles = ReviewParticipant.addToExistingRoles((ReviewParticipant.ParticipantsRoles)roles, (FecruUser)user, (boolean)false, (boolean)false, (boolean)true);
        Assert.assertEquals((String)"should not be a reviewer", (boolean)false, (boolean)roles.reviewer);
        Assert.assertEquals((String)"should be an author", (boolean)true, (boolean)roles.author);
        Assert.assertEquals((String)"should be a moderator", (boolean)true, (boolean)roles.moderator);
        roles = ReviewParticipant.addToExistingRoles(null, (FecruUser)user, (boolean)true, (boolean)true, (boolean)true);
        Assert.assertEquals((String)"should not be a reviewer", (boolean)false, (boolean)roles.reviewer);
        Assert.assertEquals((String)"should be an author", (boolean)true, (boolean)roles.author);
        Assert.assertEquals((String)"should be a moderator", (boolean)true, (boolean)roles.moderator);
    }

    @Test
    public void testEqualsHash() throws Exception {
        ReviewParticipant punsaved1 = new ReviewParticipant();
        ReviewParticipant punsaved2 = new ReviewParticipant();
        Assert.assertEquals((boolean)false, (boolean)punsaved1.equals((Object)"blah"));
        Assert.assertEquals((boolean)true, (boolean)punsaved1.equals((Object)punsaved1));
        Assert.assertEquals((boolean)false, (boolean)punsaved1.equals((Object)punsaved2));
        try {
            punsaved1.hashCode();
            Assert.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        HibernateUtil.beginTransaction();
        Review review = ModelUtils.createBlankTestReview("testreview");
        HibernateUtil.commitTransaction();
        HibernateUtil.beginTransaction();
        FecruUser u1 = ModelUtils.makeAndSaveUser("fred");
        FecruUser u2 = ModelUtils.makeAndSaveUser("jim");
        FecruUser u3 = ModelUtils.makeAndSaveUser("jane");
        this.p1 = this.reviewManager.addReviewer(review, u1);
        this.p2 = this.reviewManager.addReviewer(review, u2);
        Assert.assertEquals((boolean)true, (boolean)this.p1.equals((Object)this.p1));
        Assert.assertEquals((boolean)false, (boolean)punsaved1.equals((Object)this.p1));
        Assert.assertEquals((boolean)false, (boolean)this.p1.equals((Object)punsaved1));
        Assert.assertEquals((boolean)false, (boolean)this.p1.equals((Object)this.p2));
        Assert.assertEquals((boolean)false, (this.p1.hashCode() == this.p2.hashCode() ? 1 : 0) != 0);
        HibernateUtil.commitTransaction();
        HibernateUtil.closeSession();
        Session s = HibernateUtil.currentSession();
        s.update((Object)review);
        HibernateUtil.closeSession();
        Assert.assertEquals((int)0, (int)review.getCountCompletedReviewers());
        Assert.assertFalse((boolean)review.isAllReviewersComplete());
        this.completeViaReview(this.p1, review);
        Assert.assertEquals((int)1, (int)review.getCountCompletedReviewers());
        Assert.assertFalse((boolean)review.isAllReviewersComplete());
        this.completeViaReview(this.p2, review);
        Assert.assertEquals((int)2, (int)review.getCountCompletedReviewers());
        Assert.assertTrue((boolean)review.isAllReviewersComplete());
        this.uncompleteViaReview(this.p1, review);
        Assert.assertEquals((int)1, (int)review.getCountCompletedReviewers());
        Assert.assertFalse((boolean)review.isAllReviewersComplete());
        this.completeViaReview(this.p1, review);
        Assert.assertEquals((int)2, (int)review.getCountCompletedReviewers());
        Assert.assertTrue((boolean)review.isAllReviewersComplete());
        ReviewParticipant p3 = this.addParticipantToReview(review, u3);
        Assert.assertEquals((int)2, (int)review.getCountCompletedReviewers());
        Assert.assertFalse((boolean)review.isAllReviewersComplete());
        this.completeViaReview(p3, review);
        Assert.assertEquals((int)3, (int)review.getCountCompletedReviewers());
        Assert.assertTrue((boolean)review.isAllReviewersComplete());
        this.uncompleteViaReview(p3, review);
        Assert.assertEquals((int)2, (int)review.getCountCompletedReviewers());
        Assert.assertFalse((boolean)review.isAllReviewersComplete());
        this.removeParticipantFromReview(review, p3);
        Assert.assertEquals((int)2, (int)review.getCountCompletedReviewers());
        Assert.assertTrue((boolean)review.isAllReviewersComplete());
        Fred t = new Fred();
        System.out.println("Starting thread");
        t.start();
        try {
            t.join();
        }
        catch (InterruptedException e) {
            System.err.println(e.getMessage());
        }
    }

    @Test
    public void testRemoveReviewerWhoHasCompletedAnFRX() throws Exception {
        HibernateUtil.beginTransaction();
        Review review = ModelUtils.createBlankTestReview("testreview");
        HibernateUtil.commitTransaction();
        HibernateUtil.beginTransaction();
        FecruUser reviewer1 = ModelUtils.makeAndSaveUser("reviewer1");
        HibernateUtil.commitTransaction();
        HibernateUtil.beginTransaction();
        this.reviewManager.addReviewer(review, reviewer1);
        CrucibleRevision crucibleRev1 = FileRevisionManager.createRevision((String)"svn", (String)"/a/fake/path.c", (String)"d2225", (String)"d2225", (Date)new Date());
        FileRevisionExtraInfo frx1 = FRXManager.createAndAddFRX((CrucibleRevision)crucibleRev1, (Review)review);
        new UnreadFileManager().markAsRead(review.getParticipant(reviewer1), frx1);
        HibernateUtil.commitTransaction();
        HibernateUtil.beginTransaction();
        review = this.reviewManager.getReviewByPermaId(review.getPermaId());
        review.removeReviewer(reviewer1);
        HibernateUtil.commitTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeViaReview(ReviewParticipant p, Review r) {
        Session s = HibernateUtil.currentSession();
        HibernateUtil.beginTransaction();
        try {
            s.update((Object)r);
            s.update((Object)p);
            r.setReviewerComplete(p);
            HibernateUtil.commitTransaction();
        }
        finally {
            HibernateUtil.rollbackTransactionIfNotCommitted();
            HibernateUtil.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uncompleteViaReview(ReviewParticipant p, Review r) {
        Session s = HibernateUtil.currentSession();
        HibernateUtil.beginTransaction();
        try {
            s.update((Object)r);
            s.update((Object)p);
            r.setReviewerIncomplete(p);
            HibernateUtil.commitTransaction();
        }
        finally {
            HibernateUtil.rollbackTransactionIfNotCommitted();
            HibernateUtil.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReviewParticipant addParticipantToReview(Review r, FecruUser u) {
        Session s = HibernateUtil.currentSession();
        HibernateUtil.beginTransaction();
        try {
            s.update((Object)r);
            s.update((Object)u);
            ReviewParticipant p = this.reviewManager.addReviewer(r, u);
            HibernateUtil.commitTransaction();
            ReviewParticipant reviewParticipant = p;
            return reviewParticipant;
        }
        finally {
            HibernateUtil.rollbackTransactionIfNotCommitted();
            HibernateUtil.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeParticipantFromReview(Review r, ReviewParticipant p) {
        Session s = HibernateUtil.currentSession();
        HibernateUtil.beginTransaction();
        try {
            s.update((Object)r);
            s.update((Object)p);
            r.removeParticipant(p);
            HibernateUtil.commitTransaction();
        }
        finally {
            HibernateUtil.rollbackTransactionIfNotCommitted();
            HibernateUtil.closeSession();
        }
    }

    private class Fred
    extends Thread {
        private Fred() {
        }

        @Override
        public void run() {
            HibernateUtil.beginTransaction();
            ReviewParticipant p11 = ReviewParticipantTest.this.participantDAO.getById(ReviewParticipantTest.this.p1.getId().intValue());
            ReviewParticipant p22 = ReviewParticipantTest.this.participantDAO.getById(ReviewParticipantTest.this.p2.getId().intValue());
            Assert.assertEquals((boolean)true, (boolean)p11.equals((Object)ReviewParticipantTest.this.p1));
            Assert.assertEquals((boolean)true, (p11.hashCode() == ReviewParticipantTest.this.p1.hashCode() ? 1 : 0) != 0);
            Assert.assertEquals((boolean)true, (boolean)p22.equals((Object)ReviewParticipantTest.this.p2));
            Assert.assertEquals((boolean)true, (p22.hashCode() == ReviewParticipantTest.this.p2.hashCode() ? 1 : 0) != 0);
            Assert.assertEquals((boolean)false, (boolean)p11.equals((Object)ReviewParticipantTest.this.p2));
            Assert.assertEquals((boolean)false, (p11.hashCode() == ReviewParticipantTest.this.p2.hashCode() ? 1 : 0) != 0);
            HibernateUtil.commitTransaction();
            HibernateUtil.closeSession();
        }
    }
}

