/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model;

import com.cenqua.crucible.model.Review;
import junit.framework.TestCase;

public class ReviewParentTest
extends TestCase {
    Review[] reviews = new Review[5];

    public void setUp() {
        for (int i = 0; i < this.reviews.length; ++i) {
            this.reviews[i] = new Review();
            this.reviews[i].setId(Integer.valueOf(i));
        }
    }

    public void testNoParent() {
        ReviewParentTest.assertFalse((boolean)this.reviews[0].isDescendantOf(this.reviews[1]));
        ReviewParentTest.assertFalse((boolean)this.reviews[0].isDescendantOf(this.reviews[0]));
        this.reviews[0].setParentReview(this.reviews[1]);
        ReviewParentTest.assertFalse((boolean)this.reviews[1].isDescendantOf(this.reviews[0]));
    }

    public void testParent() {
        this.reviews[0].setParentReview(this.reviews[1]);
        ReviewParentTest.assertTrue((boolean)this.reviews[0].isDescendantOf(this.reviews[1]));
    }

    public void testGrandParents() {
        int i;
        for (i = 0; i < this.reviews.length - 1; ++i) {
            this.reviews[i].setParentReview(this.reviews[i + 1]);
        }
        for (i = 0; i < this.reviews.length - 1; ++i) {
            int j;
            for (j = 0; j <= i; ++j) {
                ReviewParentTest.assertFalse((boolean)this.reviews[i].isDescendantOf(this.reviews[j]));
            }
            for (j = i + 1; j < this.reviews.length; ++j) {
                ReviewParentTest.assertTrue((boolean)this.reviews[i].isDescendantOf(this.reviews[j]));
            }
        }
    }

    public void testCycle() {
        int i;
        for (i = 0; i < this.reviews.length; ++i) {
            this.reviews[i].setParentReview(this.reviews[(i + 1) % this.reviews.length]);
        }
        for (i = 0; i < this.reviews.length - 1; ++i) {
            for (int j = 0; j < this.reviews.length - 1; ++j) {
                if (i == j) {
                    ReviewParentTest.assertFalse((boolean)this.reviews[i].isDescendantOf(this.reviews[j]));
                    continue;
                }
                ReviewParentTest.assertTrue((boolean)this.reviews[i].isDescendantOf(this.reviews[j]));
            }
        }
    }
}

