/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model;

import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.model.managers.GroupManager;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;

public abstract class PrincipalTestSupport
extends TestCase {

    public class MockGroupManager
    implements GroupManager {
        private Map<Principal, List<String>> groupMap = new HashMap<Principal, List<String>>();

        public void addPrincipalToGroup(Principal p, String group) {
            if (!this.groupMap.containsKey(p)) {
                this.groupMap.put(p, new LinkedList());
            }
            this.groupMap.get(p).add(group);
        }

        public List<String> getPrincipalGroups(Principal p) {
            return this.groupMap.get(p);
        }
    }

    public static class MockPrincipal
    implements Principal {
        private String userName;

        public MockPrincipal(String userName) {
            this.userName = userName;
        }

        public String getUserName() {
            return this.userName;
        }

        public String getDisplayName() {
            return this.userName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MockPrincipal that = (MockPrincipal)o;
            return this.userName.equals(that.userName);
        }

        public int hashCode() {
            return this.userName.hashCode();
        }
    }
}

