/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model;

import com.atlassian.crucible.activity.lucene.ReviewItemIndexer;
import com.atlassian.crucible.spi.impl.SPIUserUtils;
import com.atlassian.fecru.user.EffectiveUserProvider;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fecru.user.FecruUserDAOImpl;
import com.atlassian.fisheye.user.permissions.GlobalPermissionManager;
import com.atlassian.fisheye.user.permissions.GlobalPermissionType;
import com.cenqua.crucible.hibernate.CurrentSessionProvider;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.hibernate.HibernateUtilCurrentSessionProvider;
import com.cenqua.crucible.model.PermissionScheme;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.model.PrincipalTestSupport;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.dao.HibernatePermissionSchemeDAO;
import com.cenqua.crucible.model.dao.HibernateProjectDAO;
import com.cenqua.crucible.model.dao.HibernateReviewDAO;
import com.cenqua.crucible.model.dao.PermissionSchemeDAO;
import com.cenqua.crucible.model.dao.ProjectDAO;
import com.cenqua.crucible.model.dao.ReviewDAO;
import com.cenqua.crucible.model.managers.CrucibleUserManager;
import com.cenqua.crucible.model.managers.GroupManager;
import com.cenqua.crucible.model.managers.PermissionManager;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.model.managers.UserActionManager;
import com.cenqua.crucible.model.managers.impl.DefaultPermissionManager;
import com.cenqua.crucible.model.managers.impl.DefaultSecureProjectManager;
import com.cenqua.crucible.util.DummyConfig;
import com.cenqua.crucible.util.DummyConfigDocument;
import com.cenqua.crucible.util.DummyReviewItemIndexer;
import com.cenqua.crucible.util.DummyReviewManager;
import com.cenqua.crucible.util.DummySPIUserUtils;
import com.cenqua.crucible.util.DummySecurityType;
import com.cenqua.dbutils.ModelUtils;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.config1.SecurityType;
import com.cenqua.fisheye.user.GroupMembershipManager;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.web.DummyWatchManager;
import com.cenqua.fisheye.web.WatchManager;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.springframework.context.ApplicationContext;

public class PermissionSchemeTest
extends PrincipalTestSupport {
    private ModelUtils mu;
    private SecurityType securityType;
    private Set<String> cruDisabledUsers = new HashSet<String>();
    private Map<String, FecruUser> addedUsers = new HashMap<String, FecruUser>();
    private RootConfig oldRootConfig;
    private PermissionManager permissionManager;
    private UserManager userManager;
    private GroupMembershipManager groupMembershipManager;
    private DefaultSecureProjectManager secureProjectManager;
    private GlobalPermissionManager globalPermissionManager;
    private PermissionSchemeDAO permissionSchemeDAO;
    private ProjectDAO projectDAO;
    private ReviewDAO reviewDAO;
    private FecruUserDAOImpl userDAO;

    protected void setUp() throws Exception {
        this.mu = new ModelUtils();
        this.mu.createBlankDB();
        this.securityType = new DummySecurityType(true, true);
        DummyConfigDocument config = new DummyConfigDocument(new DummyConfig(this.securityType));
        this.userManager = (UserManager)Mockito.mock(UserManager.class);
        Mockito.when((Object)this.userManager.isCrucibleEnabled(Mockito.anyString())).thenAnswer(invocation -> !this.cruDisabledUsers.contains(invocation.getArguments()[0]));
        this.groupMembershipManager = (GroupMembershipManager)Mockito.mock(GroupMembershipManager.class);
        RootConfig root = new RootConfig(){

            public UserManager getUserManager() {
                return PermissionSchemeTest.this.userManager;
            }
        };
        root.setConfig((ConfigDocument)config);
        this.oldRootConfig = AppConfig.getsConfig();
        AppConfig.resetConfig((RootConfig)root);
        this.permissionSchemeDAO = new HibernatePermissionSchemeDAO((CurrentSessionProvider)new HibernateUtilCurrentSessionProvider());
        this.projectDAO = new HibernateProjectDAO((CurrentSessionProvider)new HibernateUtilCurrentSessionProvider());
        this.reviewDAO = new HibernateReviewDAO((CurrentSessionProvider)new HibernateUtilCurrentSessionProvider());
        this.userDAO = new FecruUserDAOImpl();
        this.userDAO.setCurrentSessionProvider((CurrentSessionProvider)new HibernateUtilCurrentSessionProvider());
        this.globalPermissionManager = (GlobalPermissionManager)Mockito.mock(GlobalPermissionManager.class);
        this.permissionManager = new DefaultPermissionManager(this.permissionSchemeDAO, this.projectDAO, this.reviewDAO, (CurrentSessionProvider)new HibernateUtilCurrentSessionProvider(), this.userManager, this.groupMembershipManager, (EffectiveUserProvider)Mockito.mock(EffectiveUserProvider.class), this.globalPermissionManager, ModelUtils.getTxTemplate());
        this.secureProjectManager = new DefaultSecureProjectManager(this.permissionManager, this.groupMembershipManager, ModelUtils.getProjectManager(), root, (CurrentSessionProvider)new HibernateUtilCurrentSessionProvider());
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        HibernateUtil.commitTransaction();
        this.mu.destroyDB();
        AppConfig.resetConfig((RootConfig)this.oldRootConfig);
    }

    public void testShouldNotAllowDefaultPermissionSchemeDeletion() throws Exception {
        PermissionScheme defaultScheme = this.permissionManager.getDefaultPermissionScheme();
        try {
            this.permissionManager.deletePermissionSchemeByName(defaultScheme.getName());
            PermissionSchemeTest.fail((String)"should throw IllegalArgumentException when deleting default permission scheme");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        PermissionSchemeTest.assertTrue((this.permissionManager.getDefaultPermissionScheme() != null ? 1 : 0) != 0);
        PermissionSchemeTest.assertTrue((boolean)defaultScheme.getId().equals(this.permissionManager.getDefaultPermissionScheme().getId()));
        PermissionScheme deletableScheme = this.permissionManager.createPermissionScheme("deletable scheme");
        Integer id = deletableScheme.getId();
        PermissionSchemeTest.assertNotNull((Object)id);
        try {
            this.permissionManager.deletePermissionSchemeByName(deletableScheme.getName());
        }
        catch (IllegalArgumentException ignore) {
            PermissionSchemeTest.fail((String)"should not throw IllegalArgumentException when deleting a deletable permission scheme");
        }
        for (PermissionScheme permissionScheme : this.permissionManager.getPermissionSchemes()) {
            if (permissionScheme.getId() != id) continue;
            PermissionSchemeTest.fail((String)"deletion failed");
        }
    }

    public void testPermScheme() throws Exception {
        this.setupSpringContext();
        HibernateUtil.beginTransaction();
        PermissionSchemeTest.assertEquals((int)2, (int)Iterables.size((Iterable)this.permissionManager.getPermissionSchemes()));
        FecruUser fred = this.addUser("fred");
        FecruUser jim = this.addUser("jim");
        FecruUser jane = this.addUser("jane");
        FecruUser notCruUser = this.addUser("notCruUser");
        this.userDAO.create(notCruUser);
        HibernateUtil.currentSession().flush();
        this.cruDisabledUsers.add(notCruUser.getUsername());
        HibernateUtil.currentSession().flush();
        PermissionScheme permissionScheme1 = new PermissionScheme("ps1");
        this.permissionSchemeDAO.add(permissionScheme1);
        Project project1 = new Project();
        project1.setName("Project1");
        project1.setProjKey("pk1");
        project1.setPermissionScheme(permissionScheme1);
        HibernateUtil.currentSession().flush();
        this.projectDAO.add(project1);
        Review r = new Review();
        r.setId(Integer.valueOf(111));
        r.setProject(project1);
        this.reviewDAO.add(r);
        HibernateUtil.currentSession().flush();
        r.setModerator(fred);
        r.setAuthor(jim);
        r.addReviewer(jane);
        HibernateUtil.currentSession().flush();
        PrincipalTestSupport.MockGroupManager groupManager = new PrincipalTestSupport.MockGroupManager(this);
        PermissionScheme ps = this.permissionManager.createPermissionScheme("fred");
        PermissionSchemeTest.assertEquals((String)ps.getName(), (String)"fred");
        ps.addAllUsersAction(UserActionManager.ACTION_CREATE);
        ps.addAllUsersAction("action:2");
        ps.addAllUsersAction("action:3");
        ps.addAllUsersAction("action:3");
        PermissionSchemeTest.assertEquals((int)3, (int)ps.getAllUsersPAs().size());
        ps.addAnonAction("action:2");
        ps.addAnonAction("action:4");
        ps.addAnonAction("action:4");
        PermissionSchemeTest.assertEquals((int)2, (int)ps.getAnonymousPAs().size());
        PrincipalTestSupport.MockPrincipal fredPrincipal = new PrincipalTestSupport.MockPrincipal(fred.getUsername());
        groupManager.addPrincipalToGroup(fredPrincipal, "ateam");
        groupManager.addPrincipalToGroup(fredPrincipal, "bteam");
        PrincipalTestSupport.MockPrincipal jimPrincipal = new PrincipalTestSupport.MockPrincipal(jim.getUsername());
        groupManager.addPrincipalToGroup(jimPrincipal, "ateam");
        PrincipalTestSupport.MockPrincipal janePrincipal = new PrincipalTestSupport.MockPrincipal(jane.getUsername());
        groupManager.addPrincipalToGroup(janePrincipal, "bteam");
        groupManager.addPrincipalToGroup(janePrincipal, "cteam");
        groupManager.addPrincipalToGroup(janePrincipal, "dteam");
        PrincipalTestSupport.MockPrincipal pNotCruUser = new PrincipalTestSupport.MockPrincipal(notCruUser.getUsername());
        ps.addUserAction(fredPrincipal.getUserName(), "action:5");
        ps.addUserAction(jimPrincipal.getUserName(), "action:5");
        ps.addUserAction(janePrincipal.getUserName(), "action:5");
        ps.addUserAction(janePrincipal.getUserName(), "action:6");
        ps.addUserAction(janePrincipal.getUserName(), "action:6");
        PermissionSchemeTest.assertEquals((int)4, (int)ps.getUserPAs().size());
        ps.addGroupAction("ateam", "action:5");
        ps.addGroupAction("bteam", "action:5");
        ps.addGroupAction("bteam", "action:7");
        ps.addGroupAction("cteam", "action:5");
        ps.addGroupAction("cteam", "action:5");
        PermissionSchemeTest.assertEquals((int)4, (int)ps.getGroupPAs().size());
        ps.addReviewRoleAction(ReviewManager.MODERATOR.getName(), "action:11");
        ps.addReviewRoleAction(ReviewManager.MODERATOR.getName(), "action:8");
        ps.addReviewRoleAction(ReviewManager.MODERATOR.getName(), "action:9");
        ps.addReviewRoleAction(ReviewManager.AUTHOR.getName(), "action:11");
        ps.addReviewRoleAction(ReviewManager.AUTHOR.getName(), "action:8");
        ps.addReviewRoleAction(ReviewManager.AUTHOR.getName(), "action:9");
        ps.addReviewRoleAction(ReviewManager.REVIEWER.getName(), "action:10");
        ps.addReviewRoleAction(ReviewManager.REVIEWER.getName(), "action:10");
        PermissionSchemeTest.assertEquals((int)7, (int)ps.getReviewRolePAs().size());
        HibernateUtil.commitTransaction();
        Iterable schemes = this.permissionManager.getPermissionSchemes();
        PermissionSchemeTest.assertEquals((String)"Wrong number of schemes found", (int)4, (int)Iterables.size((Iterable)schemes));
        ps = this.permissionManager.findPermissionSchemeByName("fred");
        PermissionSchemeTest.assertTrue((String)"Created scheme not in list", (boolean)Iterables.contains((Iterable)schemes, (Object)ps));
        Mockito.when((Object)this.userManager.getLicensedUser(Mockito.anyString())).thenAnswer(invocation -> this.addedUsers.get((String)invocation.getArguments()[0]));
        Mockito.when((Object)this.groupMembershipManager.getGroupsForUser(Mockito.anyString())).thenAnswer(invocation -> groupManager.getPrincipalGroups(new PrincipalTestSupport.MockPrincipal((String)invocation.getArguments()[0])));
        DefaultPermissionManager permissionManager = new DefaultPermissionManager((PermissionSchemeDAO)new HibernatePermissionSchemeDAO((CurrentSessionProvider)new HibernateUtilCurrentSessionProvider()), (ProjectDAO)new HibernateProjectDAO((CurrentSessionProvider)new HibernateUtilCurrentSessionProvider()), (ReviewDAO)new HibernateReviewDAO((CurrentSessionProvider)new HibernateUtilCurrentSessionProvider()), (CurrentSessionProvider)new HibernateUtilCurrentSessionProvider(), this.userManager, this.groupMembershipManager, (EffectiveUserProvider)Mockito.mock(EffectiveUserProvider.class), this.globalPermissionManager, ModelUtils.getTxTemplate());
        Mockito.when((Object)this.globalPermissionManager.hasPermission(fredPrincipal.getUserName(), GlobalPermissionType.CRUCIBLE_USER)).thenReturn((Object)true);
        Mockito.when((Object)this.globalPermissionManager.hasPermission(janePrincipal.getUserName(), GlobalPermissionType.CRUCIBLE_USER)).thenReturn((Object)true);
        Mockito.when((Object)this.globalPermissionManager.hasPermission(jimPrincipal.getUserName(), GlobalPermissionType.CRUCIBLE_USER)).thenReturn((Object)true);
        PermissionSchemeTest.assertTrue((boolean)permissionManager.canPrincipalDoAction(ps, (Principal)Principal.Anonymous.ANON, null, "action:2", r));
        PermissionSchemeTest.assertTrue((boolean)permissionManager.canPrincipalDoAction(ps, (Principal)Principal.Anonymous.ANON, null, "action:2", r));
        PermissionSchemeTest.assertFalse((boolean)permissionManager.canPrincipalDoAction(ps, (Principal)Principal.Anonymous.ANON, null, UserActionManager.ACTION_CREATE, r));
        PermissionSchemeTest.assertTrue((boolean)permissionManager.canPrincipalDoAction(ps, (Principal)fredPrincipal, null, UserActionManager.ACTION_CREATE, r));
        PermissionSchemeTest.assertFalse((boolean)permissionManager.canPrincipalDoAction(ps, (Principal)pNotCruUser, null, UserActionManager.ACTION_CREATE, r));
        Project defaultProject = ModelUtils.getProjectManager().getDefaultProject();
        Set projects = DefaultPermissionManager.getProjectsPrincipalCanDoActionIn((Principal)pNotCruUser, (String)UserActionManager.ACTION_CREATE, (GroupManager)groupManager);
        PermissionSchemeTest.assertFalse((boolean)projects.contains(defaultProject));
        HibernateUtil.beginTransaction();
        Project newProject = ModelUtils.getProjectManager().createProject("testProject", "TP");
        newProject.setPermissionScheme(ps);
        HibernateUtil.commitTransaction();
        projects = DefaultPermissionManager.getProjectsPrincipalCanDoActionIn((Principal)fredPrincipal, (String)UserActionManager.ACTION_CREATE, (GroupManager)groupManager);
        PermissionSchemeTest.assertTrue((String)"Expecting project to be visible", (boolean)projects.contains(newProject));
        PermissionSchemeTest.assertTrue((boolean)permissionManager.canPrincipalDoAction(ps, (Principal)fredPrincipal, null, UserActionManager.ACTION_CREATE, r));
        PermissionSchemeTest.assertTrue((boolean)permissionManager.canPrincipalDoAction(ps, (Principal)fredPrincipal, null, "action:5", r));
        PermissionSchemeTest.assertTrue((boolean)permissionManager.canPrincipalDoAction(ps, (Principal)janePrincipal, null, "action:6", r));
        PermissionSchemeTest.assertFalse((boolean)permissionManager.canPrincipalDoAction(ps, (Principal)fredPrincipal, null, "action:6", r));
        PermissionSchemeTest.assertTrue((boolean)permissionManager.canPrincipalDoAction(ps, (Principal)fredPrincipal, null, "action:7", r));
        PermissionSchemeTest.assertTrue((boolean)permissionManager.canPrincipalDoAction(ps, (Principal)fredPrincipal, null, "action:5", r));
        PermissionSchemeTest.assertTrue((boolean)permissionManager.canPrincipalDoAction(ps, (Principal)jimPrincipal, null, "action:5", r));
        PermissionSchemeTest.assertFalse((boolean)permissionManager.canPrincipalDoAction(ps, (Principal)jimPrincipal, null, "action:7", r));
        PermissionSchemeTest.assertTrue((boolean)permissionManager.canPrincipalDoAction(ps, (Principal)fredPrincipal, null, "action:11", r));
        PermissionSchemeTest.assertTrue((boolean)permissionManager.canPrincipalDoAction(ps, (Principal)fredPrincipal, null, "action:8", r));
        PermissionSchemeTest.assertFalse((boolean)permissionManager.canPrincipalDoAction(ps, (Principal)fredPrincipal, null, "action:10", r));
        PermissionSchemeTest.assertTrue((boolean)permissionManager.canPrincipalDoAction(ps, (Principal)jimPrincipal, null, "action:11", r));
        PermissionSchemeTest.assertTrue((boolean)permissionManager.canPrincipalDoAction(ps, (Principal)jimPrincipal, null, "action:8", r));
        PermissionSchemeTest.assertFalse((boolean)permissionManager.canPrincipalDoAction(ps, (Principal)jimPrincipal, null, "action:10", r));
        PermissionSchemeTest.assertFalse((boolean)permissionManager.canPrincipalDoAction(ps, (Principal)janePrincipal, null, "action:11", r));
        PermissionSchemeTest.assertFalse((boolean)permissionManager.canPrincipalDoAction(ps, (Principal)janePrincipal, null, "action:8", r));
        PermissionSchemeTest.assertTrue((boolean)permissionManager.canPrincipalDoAction(ps, (Principal)janePrincipal, null, "action:10", r));
        this.securityType.setAllowAnon(false);
        PermissionSchemeTest.assertFalse((boolean)permissionManager.canPrincipalDoAction(ps, (Principal)Principal.Anonymous.ANON, null, "action:2", r));
        this.securityType.setAllowAnon(true);
        this.securityType.setAllowCruAnon(false);
        PermissionSchemeTest.assertFalse((boolean)permissionManager.canPrincipalDoAction(ps, (Principal)Principal.Anonymous.ANON, null, "action:2", r));
    }

    public void testPermScheme_shouldBeGroupNameCaseInsensitive() {
        this.setupSpringContext();
        HibernateUtil.beginTransaction();
        PermissionScheme permissionScheme = new PermissionScheme("ps1");
        this.permissionSchemeDAO.add(permissionScheme);
        String ACTION_NAME = "some-action";
        permissionScheme.addGroupAction("group1", "some-action");
        MatcherAssert.assertThat((Object)permissionScheme.isAllowedByGroup((List)ImmutableList.of((Object)"group1"), "some-action"), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)permissionScheme.isAllowedByGroup((List)ImmutableList.of((Object)"GROUP1"), "some-action"), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)permissionScheme.isAllowedByGroup((List)ImmutableList.of((Object)"group2"), "some-action"), (Matcher)Is.is((Object)false));
        HibernateUtil.commitTransaction();
    }

    private void setupSpringContext() {
        ApplicationContext mockApplicationContext = (ApplicationContext)Mockito.mock(ApplicationContext.class);
        CrucibleUserManager crucibleUserManager = (CrucibleUserManager)Mockito.mock(CrucibleUserManager.class);
        DummyReviewItemIndexer reviewItemIndexer = new DummyReviewItemIndexer();
        DummyWatchManager watchManager = new DummyWatchManager();
        DummySPIUserUtils spiUserUtils = new DummySPIUserUtils();
        DummyReviewManager reviewManager = new DummyReviewManager();
        Mockito.when((Object)mockApplicationContext.getBean((String)Matchers.eq((Object)"crucibleUserManager"))).thenReturn((Object)crucibleUserManager);
        Mockito.when((Object)mockApplicationContext.getBean((String)Matchers.eq((Object)"reviewItemIndexer"), (Class)Matchers.eq(ReviewItemIndexer.class))).thenReturn((Object)reviewItemIndexer);
        Mockito.when((Object)mockApplicationContext.getBean((String)Matchers.eq((Object)"watchManager"), (Class)Matchers.eq(WatchManager.class))).thenReturn((Object)watchManager);
        Mockito.when((Object)mockApplicationContext.getBean((String)Matchers.eq((Object)"secureProjectManager"))).thenReturn((Object)this.secureProjectManager);
        Mockito.when((Object)mockApplicationContext.getBeansOfType((Class)Matchers.eq(SPIUserUtils.class))).thenReturn((Object)ImmutableMap.of((Object)"", (Object)spiUserUtils));
        Mockito.when((Object)mockApplicationContext.getBeansOfType((Class)Matchers.eq(ReviewManager.class))).thenReturn((Object)ImmutableMap.of((Object)"", (Object)reviewManager));
        SpringContext.setApplicationContext((ApplicationContext)mockApplicationContext);
    }

    private FecruUser addUser(String username) {
        FecruUser user = new FecruUser(username);
        this.userDAO.create(user);
        this.addedUsers.put(username, user);
        return user;
    }
}

