/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model;

import com.cenqua.crucible.model.ModelTestUtils;
import com.cenqua.crucible.model.PermaIdKey;
import junit.framework.TestCase;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class PermaIdKeyTest
extends TestCase {
    private static final Class[] CTOR_SIGNATURE = new Class[]{String.class, Integer.TYPE};
    private static final Object[] VALID_CTOR_ARGS = new Object[]{"CR-FE", 1};

    public void testNoNullProjKey() throws Exception {
        ModelTestUtils.assertPropertyValueNotAccepted("projKey", null, String.class, 0, PermaIdKey.class, CTOR_SIGNATURE, VALID_CTOR_ARGS);
    }

    public void testNoEmptyProjKey() throws Exception {
        ModelTestUtils.assertPropertyValueNotAccepted("projKey", "", String.class, 0, PermaIdKey.class, CTOR_SIGNATURE, VALID_CTOR_ARGS);
    }

    @Test
    public void createFromCorrectt() {
        PermaIdKey permaIdKey = PermaIdKey.parsePermaId((String)"AAAA-10");
        MatcherAssert.assertThat((Object)permaIdKey.getProjKey(), (Matcher)Matchers.equalTo((Object)"AAA"));
        MatcherAssert.assertThat((Object)permaIdKey.getNumber(), (Matcher)Matchers.equalTo((Object)10));
    }

    @Test(expected=IllegalArgumentException.class)
    public void createFromNoKey() {
        PermaIdKey.parsePermaId((String)"-10");
    }

    @Test(expected=IllegalArgumentException.class)
    public void createFromNoNumber() {
        PermaIdKey.parsePermaId((String)"AAA-");
    }

    @Test(expected=IllegalArgumentException.class)
    public void createFromDoubleDash() {
        PermaIdKey.parsePermaId((String)"AAA-----10");
    }
}

