/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import junit.framework.Assert;

public class ModelTestUtils {
    public static <T> void assertPropertyValueNotAccepted(String propertyName, T badValue, Class<T> propertyClass, int propertyIndexInCtorArgs, Class clazz, Class[] ctorSignature, Object[] validCtorArgs) throws Exception {
        Method setter;
        Constructor ctor = clazz.getDeclaredConstructor(ctorSignature);
        try {
            setter = clazz.getMethod("set" + ModelTestUtils.toPascalCase(propertyName), propertyClass);
        }
        catch (NoSuchMethodException e) {
            setter = clazz.getDeclaredMethod("set" + ModelTestUtils.toPascalCase(propertyName), propertyClass);
        }
        ctor.setAccessible(true);
        setter.setAccessible(true);
        String message = "Expected exception from setting " + propertyName + " with value " + badValue;
        Object[] ctorArgsWithBadValue = new Object[validCtorArgs.length];
        System.arraycopy(validCtorArgs, 0, ctorArgsWithBadValue, 0, validCtorArgs.length);
        ctorArgsWithBadValue[propertyIndexInCtorArgs] = badValue;
        try {
            ctor.newInstance(ctorArgsWithBadValue);
            Assert.fail((String)message);
        }
        catch (InvocationTargetException e) {
            Assert.assertSame((String)("Unexpected exception: " + e.getTargetException()), IllegalArgumentException.class, e.getTargetException().getClass());
        }
        Object validObject = ctor.newInstance(validCtorArgs);
        try {
            setter.invoke(validObject, badValue);
            Assert.fail((String)message);
        }
        catch (InvocationTargetException e) {
            Assert.assertSame((String)("Unexpected exception: " + e.getTargetException()), IllegalArgumentException.class, e.getTargetException().getClass());
        }
    }

    private static String toPascalCase(String propertyName) {
        return "" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.subSequence(1, propertyName.length());
    }
}

