/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model;

import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.model.Comment;
import com.cenqua.crucible.model.FRXComment;
import com.cenqua.crucible.model.InlineComment;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.notification.Notification;
import com.cenqua.crucible.notification.NotificationEvent;
import java.util.ArrayList;
import java.util.List;

public class MockModelUtil {
    List<Review> reviews = new ArrayList<Review>();
    List<Project> projects = new ArrayList<Project>();
    List<Comment> comments = new ArrayList<Comment>();
    List<FecruUser> crucibleUsers = new ArrayList<FecruUser>();
    List<Notification> notifications = new ArrayList<Notification>();

    public void clear() {
        this.reviews.clear();
        this.projects.clear();
        this.comments.clear();
        this.crucibleUsers.clear();
        this.notifications.clear();
    }

    public synchronized Review createReview(Project project, String name) {
        Review review = new Review();
        review.setId(Integer.valueOf(this.reviews.size() + 1));
        review.setProject(project);
        review.setName(name);
        this.reviews.add(review);
        return review;
    }

    public synchronized Comment createComment(Review review, FecruUser commenter) {
        Comment comment = new Comment(){

            public FRXComment getFrxComment() {
                return null;
            }

            public InlineComment getInlineComment() {
                return null;
            }
        };
        comment.setId(Integer.valueOf(this.comments.size() + 1));
        comment.setReview(review);
        comment.setUser(commenter);
        this.comments.add(comment);
        return comment;
    }

    public synchronized Comment createReply(Review review, FecruUser commenter, Comment parent) {
        Comment reply = this.createComment(review, commenter);
        reply.setReplyToComment(parent);
        return reply;
    }

    public synchronized FecruUser createUser(FecruUser feUser) {
        return this.createUser(feUser.getUsername());
    }

    public FecruUser createUser(String username) {
        FecruUser user = new FecruUser(Integer.valueOf(this.crucibleUsers.size() + 1), username);
        this.crucibleUsers.add(user);
        return user;
    }

    public synchronized Notification createNotification(NotificationEvent note) {
        Notification notification = new Notification();
        notification.setId(Integer.valueOf(this.notifications.size() + 1));
        notification.setEvent(note);
        this.notifications.add(notification);
        return notification;
    }

    public synchronized Project createProject() {
        Project project = new Project();
        project.setId(Integer.valueOf(this.projects.size() + 1));
        this.projects.add(project);
        return project;
    }
}

