/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model;

import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.model.CrucibleRevision;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.model.managers.FileRevisionManager;
import com.cenqua.crucible.revision.source.Source;
import com.cenqua.crucible.revision.source.SourceFactory;
import com.cenqua.crucible.spi.ServiceTestBase;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.user.UserLogin;
import com.cenqua.fisheye.util.Disposer;
import java.util.Date;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FileRevisionTest
extends ServiceTestBase {
    private SourceFactory sourceFactory;
    private CrucibleRevision crucibleRev1;
    private CrucibleRevision crucibleRev2;
    private CrucibleRevision filemain0;
    private CrucibleRevision filemain1;
    private CrucibleRevision filemain2;
    private CrucibleRevision filebranch0;
    private CrucibleRevision filebranch1;
    private String main0 = "1.1";
    private String main1 = "1.8";
    private String main2 = "1.9";
    private String branch0 = "1.9.6.1";
    private String branch1 = "1.9.6.2";

    @Before
    public void setUp() throws Exception {
        this.sourceFactory = (SourceFactory)SpringContext.getComponent((String)"sourceFactory");
        Assert.assertNotNull((Object)((RepositoryManager)SpringContext.getComponentByClass(RepositoryManager.class)).getRepository("cvs"));
        Disposer.pushThreadInstance();
    }

    @After
    public void tearDown() throws Exception {
        Disposer.popThreadInstance();
    }

    private void setupFileRevisions() {
        HibernateUtil.beginTransaction();
        this.filemain0 = FileRevisionManager.createRevision((String)"cvs", (String)"/test/CleanSweeper.java", (String)this.main0, (String)this.main0, (Date)new Date());
        this.filemain1 = FileRevisionManager.createRevision((String)"cvs", (String)"/test/CleanSweeper.java", (String)this.main1, (String)this.main1, (Date)new Date());
        this.filemain2 = FileRevisionManager.createRevision((String)"cvs", (String)"/test/CleanSweeper.java", (String)this.main2, (String)this.main2, (Date)new Date());
        this.filebranch0 = FileRevisionManager.createRevision((String)"cvs", (String)"/test/CleanSweeper.java", (String)this.branch0, (String)this.branch0, (Date)new Date());
        this.filebranch1 = FileRevisionManager.createRevision((String)"cvs", (String)"/test/CleanSweeper.java", (String)this.branch1, (String)this.branch1, (Date)new Date());
        HibernateUtil.commitTransaction();
        this.dumpFileRevision(this.filemain0);
        this.dumpFileRevision(this.filemain1);
        this.dumpFileRevision(this.filemain2);
        this.dumpFileRevision(this.filebranch0);
        this.dumpFileRevision(this.filebranch1);
    }

    @Test
    public void testEqualsHash() throws Exception {
        CrucibleRevision fr1 = new CrucibleRevision();
        CrucibleRevision fr2 = new CrucibleRevision();
        Assert.assertEquals((Object)false, (Object)fr1.equals((Object)"blah"));
        Assert.assertEquals((Object)true, (Object)fr1.equals((Object)fr1));
        Assert.assertEquals((Object)false, (Object)fr1.equals((Object)fr2));
        try {
            fr1.hashCode();
            Assert.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        HibernateUtil.beginTransaction();
        this.crucibleRev1 = FileRevisionManager.createRevision((String)"cvs", (String)"/a/fake/path.c", (String)"d2225", (String)"d2225", (Date)new Date());
        this.crucibleRev2 = FileRevisionManager.createRevision((String)"cvs", (String)"/a/fake/path.c", (String)"d2226", (String)"d2226", (Date)new Date());
        Assert.assertEquals((Object)true, (Object)this.crucibleRev1.equals((Object)this.crucibleRev1));
        Assert.assertEquals((Object)false, (Object)this.crucibleRev1.equals((Object)fr1));
        Assert.assertEquals((Object)false, (Object)fr1.equals((Object)this.crucibleRev1));
        Assert.assertEquals((Object)false, (Object)this.crucibleRev1.equals((Object)this.crucibleRev2));
        Assert.assertEquals((Object)false, (Object)(this.crucibleRev1.hashCode() == this.crucibleRev2.hashCode() ? 1 : 0));
        HibernateUtil.commitTransaction();
        Fred t = new Fred();
        System.out.println("Starting thread");
        t.start();
        t.join();
        Assert.assertNull((Object)t.e);
    }

    @Test
    public void testIsLatestRevision() throws Exception {
        this.setupFileRevisions();
        Assert.assertTrue((boolean)this.isAnySuccessorRevisions(this.filemain0));
        Assert.assertTrue((boolean)this.isAnySuccessorRevisions(this.filemain1));
        Assert.assertFalse((boolean)this.isAnySuccessorRevisions(this.filemain2));
        Assert.assertTrue((boolean)this.isAnySuccessorRevisions(this.filebranch0));
        Assert.assertFalse((boolean)this.isAnySuccessorRevisions(this.filebranch1));
    }

    private boolean isAnySuccessorRevisions(CrucibleRevision cruRev) throws Exception {
        UserLogin currentUser = this.createTrustedUserLogin("fred");
        Source source = this.sourceFactory.getSource(cruRev.getSourceName(), (Principal)currentUser);
        return source.isAnySuccessorRevisions(cruRev);
    }

    @Test
    public void testGetLatestRevisionID() throws Exception {
        this.setupFileRevisions();
        Assert.assertEquals((Object)this.main2, (Object)this.getLatestRevIdent(this.filemain0));
        Assert.assertEquals((Object)this.main2, (Object)this.getLatestRevIdent(this.filemain1));
        Assert.assertEquals((Object)this.main2, (Object)this.getLatestRevIdent(this.filemain2));
        Assert.assertEquals((Object)this.branch1, (Object)this.getLatestRevIdent(this.filebranch0));
        Assert.assertEquals((Object)this.branch1, (Object)this.getLatestRevIdent(this.filebranch1));
    }

    private String getLatestRevIdent(CrucibleRevision cruRev) throws Exception {
        UserLogin currentUser = this.createTrustedUserLogin("fred");
        Source source = this.sourceFactory.getSource(cruRev.getSourceName(), (Principal)currentUser);
        return source.getLatestRevIdent(cruRev);
    }

    private void dumpFileRevision(CrucibleRevision fr) {
        System.out.println("FileRevisionTest:" + fr.getPath() + ":" + fr.getRevision());
    }

    private class Fred
    extends Thread {
        Throwable e;

        private Fred() {
        }

        @Override
        public void run() {
            try {
                HibernateUtil.beginTransaction();
                CrucibleRevision r1 = FileRevisionManager.getById((Integer)FileRevisionTest.this.crucibleRev1.getId());
                CrucibleRevision r2 = FileRevisionManager.getById((Integer)FileRevisionTest.this.crucibleRev2.getId());
                Assert.assertEquals((Object)true, (Object)FileRevisionTest.this.crucibleRev1.equals((Object)r1));
                Assert.assertEquals((Object)true, (Object)(FileRevisionTest.this.crucibleRev1.hashCode() == r1.hashCode() ? 1 : 0));
                Assert.assertEquals((Object)true, (Object)FileRevisionTest.this.crucibleRev2.equals((Object)r2));
                Assert.assertEquals((Object)true, (Object)(FileRevisionTest.this.crucibleRev2.hashCode() == r2.hashCode() ? 1 : 0));
                Assert.assertEquals((Object)false, (Object)FileRevisionTest.this.crucibleRev1.equals((Object)r2));
                Assert.assertEquals((Object)false, (Object)(FileRevisionTest.this.crucibleRev1.hashCode() == r2.hashCode() ? 1 : 0));
                HibernateUtil.commitTransaction();
                HibernateUtil.closeSession();
            }
            catch (Exception e1) {
                this.e = e1;
                this.e.printStackTrace();
            }
        }
    }
}

