/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model;

import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.model.CrucibleRevision;
import com.cenqua.crucible.model.FileRevisionExtraInfo;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.managers.FRXManager;
import com.cenqua.crucible.model.managers.FileRevisionManager;
import com.cenqua.crucible.util.UseTestSpringContextTestCase;
import com.cenqua.dbutils.ModelUtils;
import com.cenqua.fisheye.rep.TestFishEyeInstances;
import java.util.Date;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FileRevisionExtraInfoTest
extends UseTestSpringContextTestCase {
    private FileRevisionExtraInfo frx1;
    private FileRevisionExtraInfo frx2;
    private Throwable storedFailure;

    @Before
    public void setUp() throws Exception {
        TestFishEyeInstances.loadSanity1();
    }

    @After
    public void tearDown() throws Exception {
        HibernateUtil.closeSession();
        TestFishEyeInstances.stop();
    }

    @Test
    public void testEqualsHash() throws Throwable {
        FileRevisionExtraInfo frxunsaved1 = new FileRevisionExtraInfo();
        FileRevisionExtraInfo frxunsaved2 = new FileRevisionExtraInfo();
        Assert.assertEquals((Object)false, (Object)frxunsaved1.equals((Object)"blah"));
        Assert.assertEquals((Object)true, (Object)frxunsaved1.equals((Object)frxunsaved1));
        Assert.assertEquals((Object)false, (Object)frxunsaved1.equals((Object)frxunsaved2));
        try {
            frxunsaved1.hashCode();
            frxunsaved2.hashCode();
            Assert.fail((String)"IllegalStateException expected");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        HibernateUtil.beginTransaction();
        Review review = ModelUtils.createBlankTestReview("testreview");
        HibernateUtil.commitTransaction();
        HibernateUtil.beginTransaction();
        CrucibleRevision crucibleRev1 = FileRevisionManager.createRevision((String)"svn", (String)"/a/fake/path.c", (String)"d2225", (String)"d2225", (Date)new Date());
        CrucibleRevision crucibleRev2 = FileRevisionManager.createRevision((String)"svn", (String)"/a/fake/path.c", (String)"d2226", (String)"d2226", (Date)new Date());
        this.frx1 = FRXManager.createAndAddFRX((CrucibleRevision)crucibleRev1, (Review)review);
        this.frx2 = FRXManager.createAndAddFRX((CrucibleRevision)crucibleRev2, (Review)review);
        Assert.assertEquals((Object)true, (Object)this.frx1.equals((Object)this.frx1));
        Assert.assertEquals((Object)false, (Object)this.frx1.equals((Object)frxunsaved1));
        Assert.assertEquals((Object)false, (Object)frxunsaved1.equals((Object)this.frx1));
        Assert.assertEquals((Object)false, (Object)this.frx1.equals((Object)this.frx2));
        Assert.assertEquals((Object)false, (Object)(this.frx1.hashCode() == this.frx2.hashCode() ? 1 : 0));
        HibernateUtil.commitTransaction();
        Fred t = new Fred();
        System.out.println("Starting thread");
        t.start();
        try {
            t.join();
        }
        catch (InterruptedException e) {
            System.err.println(e.getMessage());
        }
        if (this.storedFailure != null) {
            throw this.storedFailure;
        }
    }

    private void storeFailure(Throwable threadFailureError) {
        this.storedFailure = threadFailureError;
    }

    private class Fred
    extends Thread {
        private Fred() {
        }

        @Override
        public void run() {
            try {
                HibernateUtil.beginTransaction();
                FileRevisionExtraInfo r1 = FRXManager.getById((Integer)FileRevisionExtraInfoTest.this.frx1.getId());
                FileRevisionExtraInfo r2 = FRXManager.getById((Integer)FileRevisionExtraInfoTest.this.frx2.getId());
                Assert.assertEquals((Object)true, (Object)FileRevisionExtraInfoTest.this.frx1.equals((Object)r1));
                Assert.assertEquals((Object)true, (Object)(FileRevisionExtraInfoTest.this.frx1.hashCode() == r1.hashCode() ? 1 : 0));
                Assert.assertEquals((Object)true, (Object)FileRevisionExtraInfoTest.this.frx2.equals((Object)r2));
                Assert.assertEquals((Object)true, (Object)(FileRevisionExtraInfoTest.this.frx2.hashCode() == r2.hashCode() ? 1 : 0));
                Assert.assertEquals((Object)false, (Object)FileRevisionExtraInfoTest.this.frx1.equals((Object)r2));
                Assert.assertEquals((Object)false, (Object)(FileRevisionExtraInfoTest.this.frx1.hashCode() == r2.hashCode() ? 1 : 0));
                HibernateUtil.commitTransaction();
            }
            catch (Throwable ae) {
                FileRevisionExtraInfoTest.this.storeFailure(ae);
            }
            finally {
                HibernateUtil.closeSession();
            }
        }
    }
}

