/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model;

import com.cenqua.crucible.CrucibleSysProps;
import com.cenqua.crucible.model.CrucibleRevision;
import com.cenqua.crucible.model.ModelTestUtils;
import com.cenqua.crucible.model.StoredPath;
import com.cenqua.crucible.model.StoredPathFactoryTestHelper;
import java.util.Date;
import org.junit.Assert;
import org.junit.Test;

public class CrucibleRevisionTest {
    private static final Class[] CTOR_SIGNATURE = new Class[]{String.class, StoredPath.class, String.class, String.class, Date.class};
    private static final Object[] VALID_CTOR_ARGS = new Object[]{"source", StoredPathFactoryTestHelper.makeStoredPath("/a/b/c"), "revision", "revisionDisplayName", new Date()};

    @Test
    public void testNoNullSourceName() throws Exception {
        ModelTestUtils.assertPropertyValueNotAccepted("sourceName", null, String.class, 0, CrucibleRevision.class, CTOR_SIGNATURE, VALID_CTOR_ARGS);
    }

    @Test
    public void testNoEmptySourceName() throws Exception {
        ModelTestUtils.assertPropertyValueNotAccepted("sourceName", "", String.class, 0, CrucibleRevision.class, CTOR_SIGNATURE, VALID_CTOR_ARGS);
    }

    @Test
    public void testNoNullRevision() throws Exception {
        ModelTestUtils.assertPropertyValueNotAccepted("revision", null, String.class, 2, CrucibleRevision.class, CTOR_SIGNATURE, VALID_CTOR_ARGS);
    }

    @Test
    public void testNoEmptyRevision() throws Exception {
        ModelTestUtils.assertPropertyValueNotAccepted("revision", "", String.class, 2, CrucibleRevision.class, CTOR_SIGNATURE, VALID_CTOR_ARGS);
    }

    @Test
    public void testNoNullRevisionDisplayName() throws Exception {
        ModelTestUtils.assertPropertyValueNotAccepted("revisionDisplayName", null, String.class, 3, CrucibleRevision.class, CTOR_SIGNATURE, VALID_CTOR_ARGS);
    }

    @Test
    public void testNoEmptyRevisionDisplayName() throws Exception {
        ModelTestUtils.assertPropertyValueNotAccepted("revisionDisplayName", "", String.class, 3, CrucibleRevision.class, CTOR_SIGNATURE, VALID_CTOR_ARGS);
    }

    @Test
    public void testNullOrEmptyDetailsValueRemovesMapEntry() {
        CrucibleRevision revision = new CrucibleRevision();
        revision.getDetails().put("foo", "bar");
        Assert.assertTrue((boolean)revision.getDetails().containsKey("foo"));
        revision.getDetails().put("foo", null);
        Assert.assertFalse((boolean)revision.getDetails().containsKey("foo"));
        revision.getDetails().put("foo", "");
        Assert.assertFalse((boolean)revision.getDetails().containsKey("foo"));
        revision.getDetails().put("foo", "bar");
        Assert.assertTrue((boolean)revision.getDetails().containsKey("foo"));
    }

    @Test
    public void testIsNotMetdataChangeIfLinesAdded() {
        CrucibleRevisionTest.withMetaDataRevisionDetection(true, () -> {
            CrucibleRevision revision = CrucibleRevisionTest.newModifiedRevision();
            revision.getDetails().put("linesAdded", "1");
            Assert.assertFalse((boolean)revision.isMetadataOnlyChange());
        });
    }

    @Test
    public void testIsNotMetadataChangeIfLinesRemoved() {
        CrucibleRevisionTest.withMetaDataRevisionDetection(true, () -> {
            CrucibleRevision revision = CrucibleRevisionTest.newModifiedRevision();
            revision.getDetails().put("linesRemoved", "1");
            Assert.assertFalse((boolean)revision.isMetadataOnlyChange());
        });
    }

    @Test
    public void testIsNotMetadataChangeIfLinesAddedAndRemoved() {
        CrucibleRevisionTest.withMetaDataRevisionDetection(true, () -> {
            CrucibleRevision revision = CrucibleRevisionTest.newModifiedRevision();
            revision.getDetails().put("linesAdded", "1");
            revision.getDetails().put("linesRemoved", "1");
            Assert.assertFalse((boolean)revision.isMetadataOnlyChange());
        });
    }

    @Test
    public void testIsMetadataChangeIfNoLinesChanged() {
        CrucibleRevisionTest.withMetaDataRevisionDetection(true, () -> Assert.assertTrue((boolean)CrucibleRevisionTest.newModifiedRevision().isMetadataOnlyChange()));
    }

    @Test
    public void testIsNotMetadataChangeIfNoLinesChangedButSysPropSet() {
        CrucibleRevisionTest.withMetaDataRevisionDetection(false, () -> Assert.assertFalse((boolean)CrucibleRevisionTest.newModifiedRevision().isMetadataOnlyChange()));
    }

    @Test
    public void testIsNotMetadataChangeIfAdded() {
        CrucibleRevisionTest.withMetaDataRevisionDetection(true, () -> Assert.assertFalse((boolean)CrucibleRevisionTest.newAddedRevision().isMetadataOnlyChange()));
    }

    @Test
    public void testIsNotMetadataChangeIfDeleted() {
        CrucibleRevisionTest.withMetaDataRevisionDetection(true, () -> Assert.assertFalse((boolean)CrucibleRevisionTest.newDeletedRevision().isMetadataOnlyChange()));
    }

    @Test
    public void testIsNotMetadataChangeIfBinary() {
        CrucibleRevisionTest.withMetaDataRevisionDetection(true, () -> Assert.assertFalse((boolean)CrucibleRevisionTest.newBinaryRevision().isMetadataOnlyChange()));
    }

    @Test
    public void testIsNotMetadataChangeIfNullProperties() {
        CrucibleRevisionTest.withMetaDataRevisionDetection(true, () -> Assert.assertFalse((boolean)new CrucibleRevision().isMetadataOnlyChange()));
    }

    private static void withMetaDataRevisionDetection(boolean value, Runnable runnable) {
        boolean original = CrucibleSysProps.DETECT_METADATA_REVISION_CHANGES;
        CrucibleSysProps.DETECT_METADATA_REVISION_CHANGES = value;
        try {
            runnable.run();
        }
        finally {
            CrucibleSysProps.DETECT_METADATA_REVISION_CHANGES = original;
        }
    }

    public static CrucibleRevision newModifiedRevision() {
        CrucibleRevision revision = new CrucibleRevision();
        revision.setBinary(Boolean.valueOf(false));
        revision.setAdded(Boolean.valueOf(false));
        revision.setDeletion(Boolean.valueOf(false));
        revision.setCopied(Boolean.valueOf(false));
        revision.setModified(Boolean.valueOf(true));
        return revision;
    }

    public static CrucibleRevision newBinaryRevision() {
        CrucibleRevision revision = new CrucibleRevision();
        revision.setBinary(Boolean.valueOf(true));
        revision.setAdded(Boolean.valueOf(false));
        revision.setDeletion(Boolean.valueOf(false));
        revision.setCopied(Boolean.valueOf(false));
        revision.setModified(Boolean.valueOf(false));
        return revision;
    }

    public static CrucibleRevision newDeletedRevision() {
        CrucibleRevision revision = new CrucibleRevision();
        revision.setBinary(Boolean.valueOf(true));
        revision.setAdded(Boolean.valueOf(false));
        revision.setDeletion(Boolean.valueOf(true));
        revision.setCopied(Boolean.valueOf(false));
        revision.setModified(Boolean.valueOf(false));
        return revision;
    }

    public static CrucibleRevision newAddedRevision() {
        CrucibleRevision revision = new CrucibleRevision();
        revision.setBinary(Boolean.valueOf(false));
        revision.setAdded(Boolean.valueOf(true));
        revision.setDeletion(Boolean.valueOf(false));
        revision.setCopied(Boolean.valueOf(false));
        revision.setModified(Boolean.valueOf(false));
        return revision;
    }
}

