/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model;

import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.model.Comment;
import com.cenqua.crucible.model.CommentReadStatus;
import com.cenqua.crucible.model.CommentVisitor;
import com.cenqua.crucible.model.CommentVisitorContext;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.managers.CommentManager;
import com.cenqua.crucible.util.UseTestSpringContextTestCase;
import com.cenqua.dbutils.ModelUtils;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.rep.TestFishEyeInstances;
import com.cenqua.fisheye.util.Pair;
import java.util.LinkedList;
import org.hibernate.Query;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CommentTest
extends UseTestSpringContextTestCase {
    private Comment comment1;
    private Comment comment2;
    private CommentManager commentManager;

    @Before
    public void setUp() throws Exception {
        TestFishEyeInstances.loadSanity1();
        this.commentManager = (CommentManager)SpringContext.getComponent((String)"commentManager");
    }

    @After
    public void tearDown() throws Exception {
        HibernateUtil.closeSession();
        TestFishEyeInstances.stop();
    }

    @Test
    public void testEquals() throws Exception {
        Comment c1 = new Comment();
        Comment c2 = new Comment();
        Assert.assertEquals((Object)false, (Object)c1.equals((Object)"blah"));
        Assert.assertEquals((Object)true, (Object)c1.equals((Object)c1));
        try {
            int hash = c1.hashCode();
            Assert.fail((String)"comment hashcode should throw ISE");
        }
        catch (IllegalStateException hash) {
            // empty catch block
        }
        Assert.assertEquals((Object)false, (Object)c1.equals((Object)c2));
        HibernateUtil.beginTransaction();
        Review review = ModelUtils.createBlankTestReview("testreview");
        HibernateUtil.commitTransaction();
        HibernateUtil.beginTransaction();
        this.comment1 = this.commentManager.createComment("test comment 1", review, review.getAuthor());
        review.addComment(this.comment1);
        this.comment2 = this.commentManager.createComment("test comment 2", review, review.getAuthor());
        review.addComment(this.comment2);
        Assert.assertEquals((Object)false, (Object)this.comment1.equals(null));
        c1.setMessage("test comment 1");
        c1.setReview(review);
        c1.setUser(review.getAuthor());
        Assert.assertEquals((Object)false, (Object)this.comment1.equals((Object)c1));
        Assert.assertEquals((Object)false, (Object)c1.equals((Object)this.comment1));
        Assert.assertEquals((Object)true, (Object)this.comment2.equals((Object)this.comment2));
        Assert.assertEquals((Object)true, (Object)this.comment1.equals((Object)this.comment1));
        Assert.assertEquals((Object)false, (Object)this.comment1.equals((Object)this.comment2));
        Assert.assertEquals((Object)false, (Object)(this.comment1.hashCode() == this.comment2.hashCode() ? 1 : 0));
        HibernateUtil.commitTransaction();
        Fred t = new Fred();
        System.out.println("Starting thread");
        t.start();
        try {
            t.join();
        }
        catch (InterruptedException e) {
            System.err.println(e.getMessage());
        }
    }

    @Test
    public void testFlags() throws Exception {
        HibernateUtil.beginTransaction();
        Review review = ModelUtils.createBlankTestReview("testreview");
        HibernateUtil.commitTransaction();
        HibernateUtil.beginTransaction();
        Comment c = this.commentManager.createComment("test comment 1", review, review.getAuthor());
        review.addComment(c);
        Assert.assertEquals((Object)false, (Object)c.isDefectRaised());
        c.setDefectRaised(true);
        Assert.assertEquals((Object)true, (Object)c.isDefectRaised());
        Assert.assertEquals((Object)false, (Object)c.isDefectApproved());
        c.setDefectApproved(true);
        Assert.assertEquals((Object)true, (Object)c.isDefectApproved());
        Assert.assertEquals((Object)false, (Object)c.isDraft());
        c.setDraft(true);
        Assert.assertEquals((Object)true, (Object)c.isDraft());
        Assert.assertEquals((Object)false, (Object)c.isDeleted());
        c.setDeleted(true);
        Assert.assertEquals((Object)true, (Object)c.isDeleted());
        HibernateUtil.commitTransaction();
        HibernateUtil.beginTransaction();
        Assert.assertEquals((Object)true, (Object)c.isDefectRaised());
        Assert.assertEquals((Object)true, (Object)c.isDefectApproved());
        Assert.assertEquals((Object)true, (Object)c.isDraft());
        Assert.assertEquals((Object)true, (Object)c.isDeleted());
        c.setDefectRaised(false);
        c.setDefectApproved(false);
        c.setDraft(false);
        c.setDeleted(false);
        HibernateUtil.commitTransaction();
        HibernateUtil.beginTransaction();
        Assert.assertEquals((Object)false, (Object)c.isDefectRaised());
        Assert.assertEquals((Object)false, (Object)c.isDefectApproved());
        Assert.assertEquals((Object)false, (Object)c.isDraft());
        Assert.assertEquals((Object)false, (Object)c.isDeleted());
        HibernateUtil.commitTransaction();
        Assert.assertEquals((Object)true, (Object)c.isReviewComment());
        Assert.assertEquals((Object)false, (Object)c.isRevision());
        Assert.assertEquals((Object)false, (Object)c.isReply());
    }

    @Test
    public void testReadStatus() throws Exception {
        HibernateUtil.beginTransaction();
        Review review = ModelUtils.createBlankTestReview("testreview");
        HibernateUtil.commitTransaction();
        FecruUser user = review.getAuthor();
        HibernateUtil.beginTransaction();
        Comment c = this.commentManager.createComment("test comment 1", review, user);
        review.addComment(c);
        HibernateUtil.commitTransaction();
        Query q = HibernateUtil.currentSession().createQuery("select crs from CommentReadStatus crs where crs.comment = :comment");
        q.setEntity("comment", (Object)c);
        CommentReadStatus status = (CommentReadStatus)q.uniqueResult();
        Assert.assertNotNull((Object)status);
        Assert.assertEquals((Object)c.getId(), (Object)status.getComment().getId());
        Assert.assertEquals((Object)user.getId(), (Object)status.getUser().getId());
        Assert.assertEquals((Object)true, (Object)status.isRead());
        Assert.assertEquals((long)1L, (long)c.getCommentReadStatus().size());
        Assert.assertEquals((Object)status.getId(), (Object)((CommentReadStatus)c.getCommentReadStatus().iterator().next()).getId());
        HibernateUtil.closeSession();
        Comment c2 = this.commentManager.getById(c.getId());
        Assert.assertEquals((long)1L, (long)c2.getCommentReadStatus().size());
        CommentReadStatus status2 = (CommentReadStatus)c2.getCommentReadStatus().iterator().next();
        Assert.assertEquals((Object)status.getId(), (Object)status2.getId());
    }

    @Test
    public void testVisitor() {
        final LinkedList<Pair> expected = new LinkedList<Pair>();
        FecruUser user = new FecruUser("fred");
        Comment c1 = new Comment();
        c1.setId(Integer.valueOf(1));
        c1.setUser(user);
        Comment c11 = new Comment();
        c11.setId(Integer.valueOf(11));
        c11.setUser(user);
        Comment c111 = new Comment();
        c111.setId(Integer.valueOf(111));
        c111.setUser(user);
        Comment c1111 = new Comment();
        c1111.setId(Integer.valueOf(1111));
        c1111.setUser(user);
        Comment c1112 = new Comment();
        c1112.setId(Integer.valueOf(1112));
        c1112.setUser(user);
        Comment c112 = new Comment();
        c112.setId(Integer.valueOf(112));
        c112.setUser(user);
        Comment c12 = new Comment();
        c12.setId(Integer.valueOf(12));
        c12.setUser(user);
        c1.addComment(c11);
        c1.addComment(c12);
        c11.setReplyToComment(c1);
        c11.addComment(c111);
        c11.addComment(c112);
        c111.setReplyToComment(c11);
        c111.addComment(c1111);
        c111.addComment(c1112);
        expected.add(Pair.newInstance((Object)c1, (Object)0));
        expected.add(Pair.newInstance((Object)c11, (Object)1));
        expected.add(Pair.newInstance((Object)c111, (Object)2));
        expected.add(Pair.newInstance((Object)c1111, (Object)3));
        expected.add(Pair.newInstance((Object)c1112, (Object)3));
        expected.add(Pair.newInstance((Object)c112, (Object)2));
        expected.add(Pair.newInstance((Object)c12, (Object)1));
        c1.visit(new CommentVisitor(){

            public void visit(CommentVisitorContext ctx) {
                Pair pair = (Pair)expected.remove();
                Assert.assertEquals((Object)pair.getFirst(), (Object)ctx.getComment());
                Assert.assertEquals((long)((Integer)pair.getSecond()).intValue(), (long)ctx.getDepth());
                ctx.proceed();
            }
        });
    }

    @Test
    public void testNoNullMessages() {
        try {
            new Comment().setMessage(null);
            Assert.fail((String)"Null comment messages should not be allowed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testNoEmptyMessages() {
        try {
            new Comment().setMessage("");
            Assert.fail((String)"Empty comment messages should not be allowed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private class Fred
    extends Thread {
        private Fred() {
        }

        @Override
        public void run() {
            HibernateUtil.beginTransaction();
            Comment c1 = CommentTest.this.commentManager.getById(CommentTest.this.comment1.getId());
            Comment c2 = CommentTest.this.commentManager.getById(CommentTest.this.comment2.getId());
            Assert.assertEquals((Object)true, (Object)CommentTest.this.comment1.equals((Object)c1));
            Assert.assertEquals((Object)true, (Object)CommentTest.this.comment2.equals((Object)c2));
            Assert.assertEquals((Object)false, (Object)CommentTest.this.comment1.equals((Object)c2));
            HibernateUtil.commitTransaction();
            HibernateUtil.closeSession();
        }
    }
}

