/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.iterative;

import com.atlassian.crucible.explorers.CrucibleChangeSet;
import com.cenqua.crucible.iterative.IterativeReviewHelperTestBase;
import com.cenqua.crucible.iterative.ReviewByCommentFinder;
import com.cenqua.crucible.model.managers.ReviewManager;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;

public class ReviewByCommentFinderTest
extends IterativeReviewHelperTestBase {
    @Test
    public void testGetReviewsByCommitMessage() {
        CrucibleChangeSet cs = new CrucibleChangeSet("revid", "revid", null, "This is rework following from review " + this.review1.getPermaId() + " and " + this.review3.getPermaId() + " as well as non-existing review PR2-9999", new Date(), this.joe.getUsername(), null);
        ReviewByCommentFinder finder = new ReviewByCommentFinder((ReviewManager)this.reviewManager, cs, this.txTemplate.getEffectivePrincipal());
        List found = finder.find();
        Assert.assertEquals((long)1L, (long)found.size());
        Assert.assertTrue((boolean)found.contains(this.review1));
        Assert.assertFalse((boolean)found.contains(this.review3));
    }

    @Test
    public void testReviewIdMatcherSingleProject() {
        List<String> projectKeys = Collections.singletonList("CR");
        ReviewByCommentFinder finder = new ReviewByCommentFinder((ReviewManager)this.reviewManager, "", this.txTemplate.getEffectivePrincipal());
        Assert.assertEquals((long)0L, (long)finder.extractReviewIds("no match", projectKeys).size());
        this.assertIds(finder.extractReviewIds("find CR-1.", projectKeys), Collections.singleton("CR-1"));
        this.assertIds(finder.extractReviewIds("find CR-1 and CR-2 but not FE-3", projectKeys), new HashSet<String>(Arrays.asList("CR-1", "CR-2")));
    }

    @Test
    public void testReviewIdMatcherMultipleProjects() {
        List<String> projectKeys = Arrays.asList("FE", "CR", "CR-CRUC");
        ReviewByCommentFinder finder = new ReviewByCommentFinder((ReviewManager)this.reviewManager, "", this.txTemplate.getEffectivePrincipal());
        Assert.assertEquals((long)0L, (long)finder.extractReviewIds("no match", projectKeys).size());
        this.assertIds(finder.extractReviewIds("find CR-142 and FE-0 please", projectKeys), new HashSet<String>(Arrays.asList("CR-142", "FE-0")));
        this.assertIds(finder.extractReviewIds("find just FE-99 and not FE-blah", projectKeys), Collections.singleton("FE-99"));
        this.assertIds(finder.extractReviewIds("find CR-CRUC-99 ", projectKeys), Collections.singleton("CR-CRUC-99"));
    }

    private void assertIds(Set<String> result, Set<String> expected) {
        Assert.assertEquals((long)expected.size(), (long)result.size());
        Assert.assertTrue((boolean)expected.containsAll(result));
    }
}

