/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.iterative;

import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.model.CrucibleRevision;
import com.cenqua.crucible.model.FileRevisionExtraInfo;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.managers.FileRevisionManager;
import com.cenqua.crucible.model.managers.StateManager;
import com.cenqua.crucible.spi.ServiceTestBase;
import com.cenqua.dbutils.ModelUtils;
import java.util.Date;
import org.junit.Before;

public abstract class IterativeReviewHelperTestBase
extends ServiceTestBase {
    protected Review review1;
    protected Review review2;
    protected Review review3;
    protected Review review4;
    protected Project defaultProject;
    protected Project otherProject;

    @Before
    public final void setUp() throws Exception {
        StateManager stateManager = StateManager.INSTANCE;
        HibernateUtil.beginTransaction();
        this.defaultProject = ModelUtils.getProjectManager().getDefaultProject();
        this.otherProject = ModelUtils.getProjectManager().createProject("project 2", "PR2");
        this.review1 = this.reviewManager.createReview(ModelUtils.getProjectManager(), this.defaultProject, "review 1", this.joe);
        this.review2 = this.reviewManager.createReview(ModelUtils.getProjectManager(), this.defaultProject, "review 2", this.joe);
        this.review3 = this.reviewManager.createReview(ModelUtils.getProjectManager(), this.otherProject, "review 3", this.joe);
        this.review4 = this.reviewManager.createReview(ModelUtils.getProjectManager(), this.otherProject, "review 4", this.joe);
        this.review1.setState(stateManager.getReviewState());
        this.review2.setState(stateManager.getReviewState());
        this.review3.setState(stateManager.getClosedState());
        this.review4.setState(stateManager.getReviewState());
        this.review1.setAuthor(this.joe);
        this.review2.setAuthor(this.joe);
        this.review3.setAuthor(this.joe);
        this.review4.setAuthor(this.joe);
        CrucibleRevision cruFromRev = FileRevisionManager.createRevision((String)"fred", (String)"foo/bar.java", (String)"1.1", (String)"1.1", (Date)new Date());
        CrucibleRevision cruToRev = FileRevisionManager.createRevision((String)"fred", (String)"foo/bar.java", (String)"1.2", (String)"1.2", (Date)new Date());
        FileRevisionExtraInfo frx = this.review1.addRevision(cruFromRev);
        frx.addRevision(1, cruToRev);
        cruFromRev = FileRevisionManager.createRevision((String)"fred", (String)"foo/bar.java", (String)"1.3", (String)"1.3", (Date)new Date());
        this.review2.addRevision(cruFromRev);
        cruFromRev = FileRevisionManager.createRevision((String)"fred", (String)"foo/bar.java", (String)"1.1", (String)"1.1", (Date)new Date());
        cruToRev = FileRevisionManager.createRevision((String)"fred", (String)"foo/bar.java", (String)"1.2", (String)"1.2", (Date)new Date());
        frx = this.review3.addRevision(cruFromRev);
        frx.addRevision(1, cruToRev);
        cruFromRev = FileRevisionManager.createRevision((String)"fred", (String)"foox/bar.java", (String)"1.3", (String)"1.3", (Date)new Date());
        this.review2.addRevision(cruFromRev);
        HibernateUtil.commitTransaction();
    }
}

