/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate.upgrade.user;

import com.cenqua.crucible.hibernate.upgrade.user.FEUserEAV;
import com.cenqua.crucible.hibernate.upgrade.user.LegacyUser;
import com.cenqua.fisheye.FisheyeTestUtil;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.user.FEUser;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FEUserEAVTest {
    private InfinityDbHandle dbh;
    private File dbFile;

    @Before
    public void setUp() throws Exception {
        this.dbFile = FisheyeTestUtil.createTempDB("db").getAbsoluteFile();
        this.dbh = new InfinityDbHandle(this.dbFile);
    }

    @After
    public void tearDown() throws Exception {
        this.dbh.close();
        FileUtils.deleteQuietly((File)this.dbFile);
    }

    @Test
    public void testCRUD() {
        FEUserEAV eav = new FEUserEAV(this.dbh);
        FEUser user1 = new FEUser("matt");
        user1.setEmail("matt@cenqua.com");
        user1.setPasswordHash("pot");
        user1.setAuthType(LegacyUser.AuthType.LDAP);
        eav.update(user1);
        Assert.assertTrue((boolean)eav.usernameExists("matt"));
        Assert.assertEquals((Object)"matt", (Object)eav.getUsernameForEmail("matt@cenqua.com"));
        FEUser u = eav.load("matt");
        Assert.assertEquals((Object)"matt", (Object)u.getUsername());
        Assert.assertEquals((Object)"matt@cenqua.com", (Object)u.getEmail());
        Assert.assertEquals((Object)"pot", (Object)u.getPasswordHash());
        Assert.assertEquals((Object)LegacyUser.AuthType.LDAP, (Object)u.getAuthType());
        user1.setEmail("spud@cenqua.com");
        eav.update(user1);
        u = eav.load("matt");
        Assert.assertEquals((Object)"matt", (Object)u.getUsername());
        Assert.assertEquals((Object)"spud@cenqua.com", (Object)u.getEmail());
        Assert.assertEquals((Object)"matt", (Object)eav.getUsernameForEmail("spud@cenqua.com"));
        Assert.assertEquals(null, (Object)eav.getUsernameForEmail("matt@cenqua.com"));
    }

    @Test
    public void testUniqueness() {
        FEUserEAV eav = new FEUserEAV(this.dbh);
        FEUser user1 = new FEUser("matt");
        user1.setEmail("matt@cenqua.com");
        Assert.assertFalse((boolean)eav.usernameExists("matt"));
        eav.update(user1);
        Assert.assertTrue((boolean)eav.usernameExists("matt"));
        Assert.assertEquals((Object)"matt", (Object)eav.getUsernameForEmail("matt@cenqua.com"));
        user1.setEmail(null);
        eav.update(user1);
        Assert.assertTrue((boolean)eav.usernameExists("matt"));
        Assert.assertEquals(null, (Object)eav.getUsernameForEmail("matt@cenqua.com"));
        user1.setEmail("spud@cenqua.com");
        eav.update(user1);
        Assert.assertTrue((boolean)eav.usernameExists("matt"));
        Assert.assertEquals((Object)"matt", (Object)eav.getUsernameForEmail("spud@cenqua.com"));
    }

    @Test
    public void testEmptyEmailAddressIsNotUnique() {
        FEUserEAV eav = new FEUserEAV(this.dbh);
        FEUser user1 = new FEUser("matt");
        user1.setEmail("");
        Assert.assertEquals(null, (Object)eav.getUsernameForEmail(""));
        eav.update(user1);
        Assert.assertEquals(null, (Object)eav.getUsernameForEmail(""));
        FEUser user2 = new FEUser("matt2");
        user2.setEmail("");
        Assert.assertEquals(null, (Object)eav.getUsernameForEmail(""));
        eav.update(user2);
        Assert.assertEquals(null, (Object)eav.getUsernameForEmail(""));
        FEUser user3 = new FEUser("matt3");
        user3.setEmail(" ");
        Assert.assertEquals(null, (Object)eav.getUsernameForEmail(" "));
        eav.update(user3);
        Assert.assertEquals(null, (Object)eav.getUsernameForEmail(" "));
        Assert.assertEquals(null, (Object)eav.getUsernameForEmail(""));
    }

    @Test
    public void testList() {
        String[] expected;
        FEUserEAV eav = new FEUserEAV(this.dbh);
        for (String uname : expected = new String[]{"a", "aa", "aaa", "ab", "aba", "b0", "b00", "b01"}) {
            eav.update(new FEUser(uname));
        }
        List list = eav.listAllUserNames();
        Assert.assertEquals((Object)list, Arrays.asList(expected));
    }
}

