/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate.upgrade.user;

import com.cenqua.crucible.hibernate.upgrade.user.FEUserEAV;
import com.cenqua.crucible.hibernate.upgrade.user.LegacyUser;
import com.cenqua.crucible.model.CrucibleUser;
import com.cenqua.crucible.model.ModelTestUtils;
import com.cenqua.fisheye.FisheyeTestUtil;
import com.cenqua.fisheye.config.DB0EAV;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.infinitydb.InfinityDbUtil;
import com.cenqua.fisheye.user.FEUser;
import com.infinitydb.EntityClass;
import com.infinitydb.ItemSpace;
import java.io.File;
import java.util.List;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public final class CrucibleUserTest {
    private static final Class[] CTOR_SIGNATURE = new Class[]{String.class};
    private static final Object[] VALID_CTOR_ARGS = new Object[]{"matt"};
    private InfinityDbHandle dbh;

    @Before
    public void setUp() throws Exception {
        File f = FisheyeTestUtil.createTempDB("db");
        this.dbh = new InfinityDbHandle(f);
    }

    @After
    public void tearDown() throws Exception {
        this.dbh.close();
    }

    @Test
    public void testCrucibleFlag() throws Exception {
        FEUserEAV eav = new FEUserEAV(this.dbh);
        FEUser user1 = new FEUser("matt");
        user1.setEmail("matt@cenqua.com");
        user1.setPasswordHash("pot");
        user1.setAuthType(LegacyUser.AuthType.LDAP);
        eav.update(user1);
        FEUser u = eav.load("matt");
        Assert.assertEquals((boolean)false, (boolean)u.isCrucibleEnabled());
        user1.setEmail("spud@cenqua.com");
        user1.setCrucibleEnabled(true);
        eav.update(user1);
        u = eav.load("matt");
        Assert.assertEquals((boolean)false, (boolean)u.isCrucibleEnabled());
        Assert.assertEquals((int)0, (int)eav.countNumberOfCrucibleUsers());
        List l = eav.listAllCrucibleUserNames();
        Assert.assertEquals((int)0, (int)l.size());
        eav.setCrucibleEnabled("matt", true);
        Assert.assertEquals((int)1, (int)eav.countNumberOfCrucibleUsers());
        l = eav.listAllCrucibleUserNames();
        Assert.assertEquals((int)1, (int)l.size());
        Assert.assertTrue((boolean)l.contains("matt"));
        FEUser user2 = new FEUser("fred");
        user2.setEmail("fred@cenqua.com");
        user2.setPasswordHash("pot");
        user2.setAuthType(LegacyUser.AuthType.LDAP);
        eav.update(user2);
        Assert.assertEquals((int)1, (int)eav.countNumberOfCrucibleUsers());
        eav.setCrucibleEnabled("fred", true);
        Assert.assertEquals((int)2, (int)eav.countNumberOfCrucibleUsers());
        l = eav.listAllCrucibleUserNames();
        Assert.assertEquals((int)2, (int)l.size());
        Assert.assertTrue((boolean)l.contains("matt"));
        Assert.assertTrue((boolean)l.contains("fred"));
        eav.setCrucibleEnabled("matt", false);
        Assert.assertEquals((int)1, (int)eav.countNumberOfCrucibleUsers());
        eav.setCrucibleEnabled("fred", false);
        Assert.assertEquals((int)0, (int)eav.countNumberOfCrucibleUsers());
    }

    @Test
    public void testInitialUpgrade() throws Exception {
        FEUserEAV eav = new FEUserEAV(this.dbh);
        eav.update(new FEUser("fred"));
        eav.update(new FEUser("jane"));
        eav.update(new FEUser("joe"));
        eav.update(new FEUser("matt"));
        Assert.assertEquals((long)0L, (long)InfinityDbUtil.getLong((ItemSpace)this.dbh.get(), (EntityClass)DB0EAV.CONSTANTS, (String)"crucible.user.upgrade.performed"));
        Assert.assertEquals((int)0, (int)eav.countNumberOfCrucibleUsers());
        eav.updateInitialCrucibleUsers(3);
        Assert.assertEquals((long)1L, (long)InfinityDbUtil.getLong((ItemSpace)this.dbh.get(), (EntityClass)DB0EAV.CONSTANTS, (String)"crucible.user.upgrade.performed"));
        Assert.assertEquals((int)3, (int)eav.countNumberOfCrucibleUsers());
        Assert.assertTrue((boolean)eav.load("fred").isCrucibleEnabled());
        Assert.assertTrue((boolean)eav.load("jane").isCrucibleEnabled());
        Assert.assertTrue((boolean)eav.load("joe").isCrucibleEnabled());
        Assert.assertFalse((boolean)eav.load("matt").isCrucibleEnabled());
        eav.setCrucibleEnabled("joe", false);
        Assert.assertEquals((int)2, (int)eav.countNumberOfCrucibleUsers());
        eav.updateInitialCrucibleUsers(3);
        Assert.assertEquals((long)1L, (long)InfinityDbUtil.getLong((ItemSpace)this.dbh.get(), (EntityClass)DB0EAV.CONSTANTS, (String)"crucible.user.upgrade.performed"));
        Assert.assertEquals((int)2, (int)eav.countNumberOfCrucibleUsers());
    }

    @Test
    public void testNoNullUsernames() throws Exception {
        ModelTestUtils.assertPropertyValueNotAccepted("username", null, String.class, 0, CrucibleUser.class, CTOR_SIGNATURE, VALID_CTOR_ARGS);
    }

    @Test
    public void testNoEmptyUsernames() throws Exception {
        ModelTestUtils.assertPropertyValueNotAccepted("username", "", String.class, 0, CrucibleUser.class, CTOR_SIGNATURE, VALID_CTOR_ARGS);
    }
}

