/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate.upgrade.crowd;

import com.atlassian.fecru.utils.collectors.ImmutableCollectors;
import com.cenqua.crucible.hibernate.upgrade.crowd.RepositoryExternalPermissionCleanUpTask;
import com.cenqua.fisheye.RepositoryConfig;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.config.RootConfigRule;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.config1.GroupListType;
import com.cenqua.fisheye.config1.GroupType;
import com.cenqua.fisheye.config1.RepSecurityType;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;

public class RepositoryExternalPermissionCleanUpTaskTest {
    private static final String EMPTY_CONFIG = "configs/empty.xml";
    private static final String GROUP_NONE_PERMISSIONS = "configs/groupssecurity.xml";
    private static final String MIXED_NONE_PERMISSIONS = "configs/mixedsecurity.xml";
    @Rule
    public RootConfigRule rootConfigRule = new RootConfigRule();
    private Logger logger;

    @Before
    public void setUp() throws Exception {
        this.logger = (Logger)Mockito.mock(Logger.class);
    }

    @Test
    public void testWhenNoRepos() throws Exception {
        RootConfig rootConfig = this.rootConfigRule.loadRootConfigFile(EMPTY_CONFIG);
        new RepositoryExternalPermissionCleanUpTask(this.logger).perform();
        rootConfig.reload();
    }

    @Test
    public void testNoHostLdapAuth() throws Exception {
        RootConfig rootConfig = this.rootConfigRule.loadRootConfigFile(GROUP_NONE_PERMISSIONS);
        new RepositoryExternalPermissionCleanUpTask(this.logger).perform();
        rootConfig.reload();
        ConfigDocument.Config config = rootConfig.getConfig();
        RepSecurityType antlr = config.getRepositoryArray(0).getSecurity();
        RepositoryConfig antlrConfig = new RepositoryConfig(rootConfig, config.getRepositoryArray(0), null, null, null);
        RepSecurityType sanity = config.getRepositoryArray(1).getSecurity();
        RepositoryConfig sanityConfig = new RepositoryConfig(rootConfig, config.getRepositoryArray(1), null, null, null);
        GroupListType antlrRequiredGroups = antlr.getRequiredGroups();
        GroupListType sanityRequiredGroups = sanity.getRequiredGroups();
        Assert.assertFalse((boolean)antlr.isSetLdap());
        Assert.assertFalse((boolean)sanity.isSetLdap());
        Assert.assertFalse((boolean)antlr.isSetHostAuth());
        Assert.assertFalse((boolean)sanity.isSetHostAuth());
        Assert.assertFalse((boolean)antlr.isSetCustom());
        Assert.assertFalse((boolean)sanity.isSetCustom());
        Assert.assertFalse((boolean)antlrConfig.isAnonAccessAllowed());
        Assert.assertTrue((boolean)sanityConfig.isAnonAccessAllowed());
        Assert.assertFalse((boolean)antlrConfig.isLoggedInAccessAllowed());
        Assert.assertFalse((boolean)antlr.getUseDefaults());
        Assert.assertTrue((boolean)sanity.getUseDefaults());
        Assert.assertThat(this.toStrings(antlrRequiredGroups.getGroupArray()), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"team-2", "team-1"}));
        Assert.assertEquals((String)"must not have group restriction", (long)0L, (long)sanityRequiredGroups.sizeOfGroupArray());
    }

    @Test
    public void testAllTypes() throws Exception {
        RootConfig rootConfig = this.rootConfigRule.loadRootConfigFile(MIXED_NONE_PERMISSIONS);
        new RepositoryExternalPermissionCleanUpTask(this.logger).perform();
        rootConfig.reload();
        ConfigDocument.Config config = rootConfig.getConfig();
        RepSecurityType ldapRepo = config.getRepositoryArray(0).getSecurity();
        RepositoryConfig ldapRepoConfig = new RepositoryConfig(rootConfig, config.getRepositoryArray(0), null, null, null);
        RepSecurityType hostRepo = config.getRepositoryArray(1).getSecurity();
        RepositoryConfig hostRepoConfig = new RepositoryConfig(rootConfig, config.getRepositoryArray(1), null, null, null);
        RepSecurityType customRepo = config.getRepositoryArray(2).getSecurity();
        RepositoryConfig customRepoConfig = new RepositoryConfig(rootConfig, config.getRepositoryArray(2), null, null, null);
        RepSecurityType defaultRepo = config.getRepositoryArray(3).getSecurity();
        RepositoryConfig defaultRepoConfig = new RepositoryConfig(rootConfig, config.getRepositoryArray(3), null, null, null);
        RepSecurityType ldapNoGroups = config.getRepositoryArray(4).getSecurity();
        RepositoryConfig ldapNoGroupsConfig = new RepositoryConfig(rootConfig, config.getRepositoryArray(4), null, null, null);
        RepSecurityType noSecurity = config.getRepositoryArray(5).getSecurity();
        RepositoryConfig noSecurityConfig = new RepositoryConfig(rootConfig, config.getRepositoryArray(5), null, null, null);
        GroupListType ldapRepoGroups = ldapRepo.getRequiredGroups();
        GroupListType hostRepoGroups = hostRepo.getRequiredGroups();
        GroupListType customRepoGroups = customRepo.getRequiredGroups();
        GroupListType defaultRepoGroups = defaultRepo.getRequiredGroups();
        GroupListType ldapNoGroupsRepoGroups = ldapNoGroups.getRequiredGroups();
        GroupListType noSecurityRepoGroups = noSecurity.getRequiredGroups();
        Assert.assertFalse((boolean)ldapRepo.isSetLdap());
        Assert.assertFalse((boolean)hostRepo.isSetLdap());
        Assert.assertFalse((boolean)customRepo.isSetLdap());
        Assert.assertFalse((boolean)defaultRepo.isSetLdap());
        Assert.assertFalse((boolean)ldapNoGroups.isSetLdap());
        Assert.assertFalse((boolean)ldapNoGroups.isSetLdap());
        Assert.assertFalse((boolean)ldapRepo.isSetHostAuth());
        Assert.assertFalse((boolean)hostRepo.isSetHostAuth());
        Assert.assertFalse((boolean)customRepo.isSetHostAuth());
        Assert.assertFalse((boolean)defaultRepo.isSetHostAuth());
        Assert.assertFalse((boolean)ldapNoGroups.isSetHostAuth());
        Assert.assertFalse((boolean)ldapNoGroups.isSetHostAuth());
        Assert.assertFalse((boolean)ldapRepo.isSetCustom());
        Assert.assertFalse((boolean)hostRepo.isSetCustom());
        Assert.assertTrue((boolean)customRepo.isSetCustom());
        Assert.assertFalse((boolean)defaultRepo.isSetCustom());
        Assert.assertFalse((boolean)ldapNoGroups.isSetCustom());
        Assert.assertFalse((boolean)ldapNoGroups.isSetCustom());
        Assert.assertFalse((boolean)ldapRepoConfig.isAnonAccessAllowed());
        Assert.assertFalse((boolean)hostRepoConfig.isAnonAccessAllowed());
        Assert.assertFalse((boolean)customRepoConfig.isAnonAccessAllowed());
        Assert.assertFalse((boolean)defaultRepoConfig.isAnonAccessAllowed());
        Assert.assertFalse((boolean)ldapNoGroupsConfig.isAnonAccessAllowed());
        Assert.assertTrue((boolean)noSecurityConfig.isAnonAccessAllowed());
        Assert.assertFalse((boolean)ldapRepoConfig.isLoggedInAccessAllowed());
        Assert.assertFalse((boolean)hostRepoConfig.isLoggedInAccessAllowed());
        Assert.assertFalse((boolean)customRepoConfig.isLoggedInAccessAllowed());
        Assert.assertFalse((boolean)defaultRepoConfig.isLoggedInAccessAllowed());
        Assert.assertFalse((boolean)ldapNoGroupsConfig.isLoggedInAccessAllowed());
        Assert.assertTrue((boolean)noSecurityConfig.isLoggedInAccessAllowed());
        Assert.assertFalse((boolean)ldapRepo.getUseDefaults());
        Assert.assertFalse((boolean)hostRepo.getUseDefaults());
        Assert.assertFalse((boolean)customRepo.getUseDefaults());
        Assert.assertFalse((boolean)defaultRepo.getUseDefaults());
        Assert.assertFalse((boolean)ldapNoGroups.getUseDefaults());
        Assert.assertTrue((boolean)noSecurity.getUseDefaults());
        Assert.assertThat(this.toStrings(ldapRepoGroups.getGroupArray()), (Matcher)Matchers.contains((Object[])new String[]{"team-ldap"}));
        Assert.assertThat(this.toStrings(hostRepoGroups.getGroupArray()), (Matcher)Matchers.contains((Object[])new String[]{"team-host"}));
        Assert.assertThat(this.toStrings(customRepoGroups.getGroupArray()), (Matcher)Matchers.contains((Object[])new String[]{"team-custom"}));
        Assert.assertThat(this.toStrings(defaultRepoGroups.getGroupArray()), (Matcher)Matchers.contains((Object[])new String[]{"team-default"}));
        Assert.assertEquals((String)"must not have group restriction", (long)0L, (long)ldapNoGroupsRepoGroups.sizeOfGroupArray());
        Assert.assertEquals((String)"must not have group restriction", (long)0L, (long)noSecurityRepoGroups.sizeOfGroupArray());
    }

    private List<String> toStrings(GroupType[] groupArray) {
        return (List)Arrays.stream(groupArray).map(GroupType::getName).collect(ImmutableCollectors.toList());
    }
}

