/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate.upgrade.crowd;

import com.atlassian.fecru.util.CaptureLog4jLogsRule;
import com.cenqua.crucible.hibernate.upgrade.crowd.EmbeddedCrowdUpgradeTestBase;
import com.cenqua.crucible.hibernate.upgrade.crowd.EmbeddedCrowdUpgradeTestData;
import com.cenqua.crucible.hibernate.upgrade.crowd.LegacyAuthType;
import com.cenqua.crucible.hibernate.upgrade.crowd.MigrateUsersToCwdUsers;
import com.cenqua.crucible.hibernate.upgrade.crowd.MigratedUsersData;
import com.cenqua.fisheye.logging.Logs;
import java.util.Map;
import java.util.Optional;
import org.apache.log4j.Level;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.AllOf;
import org.junit.Before;
import org.junit.Test;

public class MigrateUsersToCwdUsersTest
extends EmbeddedCrowdUpgradeTestBase {
    @Before
    public void addUsers() throws Exception {
        this.preUpgrade();
        this.db.addLegacyUser(1, "user1", null, null, "{PKCS5S2}hash", LegacyAuthType.LDAP);
        this.db.addLegacyUser(2, "user2", null, null, "{PKCS5S2}hash", LegacyAuthType.BUILTIN);
        this.db.addLegacyUser(3, "user3", null, null, "{PKCS5S2}hash", LegacyAuthType.CROWD);
    }

    @Test
    public void shouldWarnAboutLdapUsersIfNoLdapDir() throws Exception {
        this.db.runUpgradeScript();
        MigrateUsersToCwdUsers migrateUsers = new MigrateUsersToCwdUsers(this.connection, Logs.APP_LOG, Optional.empty());
        migrateUsers.perform();
        Map migratedUsersData = migrateUsers.getMigratedUsersData();
        MatcherAssert.assertThat(this.db.getRows("cwd_user"), (Matcher)Matchers.containsInAnyOrder(EmbeddedCrowdUpgradeTestData.matchCwdUser(2, "user2", null, null, "{PKCS5S2}hash", 1)));
        MatcherAssert.assertThat(this.logs.getEvents(), (Matcher)Matchers.hasItem((Matcher)AllOf.allOf((Matcher)new CaptureLog4jLogsRule.LogWithLevel(Level.WARN), (Matcher)new CaptureLog4jLogsRule.LogWithMessage("The user user1 is defined as an LDAP user, but LDAP authentication wasn't configured. User will not be migrated."))));
        MatcherAssert.assertThat((Object)migratedUsersData.size(), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)migratedUsersData, (Matcher)Matchers.hasEntry((Object)2, (Object)new MigratedUsersData("user2", 1)));
    }

    @Test
    public void shouldMigrateLdapUsersToLdapDir() throws Exception {
        int ldapDirId = 2;
        this.db.runUpgradeScript();
        this.db.addDirectory(2, "LDAP LDAP", "java.lang.Object", "CONNECTOR");
        MigrateUsersToCwdUsers migrateUsers = new MigrateUsersToCwdUsers(this.connection, Logs.APP_LOG, Optional.of(2));
        migrateUsers.perform();
        Map migratedUsersData = migrateUsers.getMigratedUsersData();
        Matcher[] matcherArray = new Matcher[2];
        matcherArray[0] = EmbeddedCrowdUpgradeTestData.matchCwdUser(2, "user2", null, null, "{PKCS5S2}hash", 1);
        matcherArray[1] = EmbeddedCrowdUpgradeTestData.matchCwdUser(1, "user1", null, null, "nopass", 2);
        MatcherAssert.assertThat(this.db.getRows("cwd_user"), (Matcher)Matchers.containsInAnyOrder((Matcher[])matcherArray));
        MatcherAssert.assertThat((Object)migratedUsersData.size(), (Matcher)Matchers.equalTo((Object)2));
        MatcherAssert.assertThat((Object)migratedUsersData, (Matcher)AllOf.allOf((Matcher)Matchers.hasEntry((Object)1, (Object)new MigratedUsersData("user1", 2)), (Matcher)Matchers.hasEntry((Object)2, (Object)new MigratedUsersData("user2", 1))));
    }
}

