/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate.upgrade.crowd;

import com.cenqua.crucible.hibernate.upgrade.crowd.EmbeddedCrowdUpgradeTestBase;
import com.cenqua.crucible.hibernate.upgrade.crowd.EmbeddedCrowdUpgradeTestData;
import com.cenqua.crucible.hibernate.upgrade.crowd.LegacyAuthType;
import com.cenqua.crucible.hibernate.upgrade.crowd.MigrateGroupMembershipsToCwdMemberships;
import com.cenqua.crucible.hibernate.upgrade.crowd.MigratedGroupsData;
import com.cenqua.crucible.hibernate.upgrade.crowd.MigratedUsersData;
import com.cenqua.fisheye.logging.Logs;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class MigrateMembershipsToCwdMembershipsTest
extends EmbeddedCrowdUpgradeTestBase {
    @Test
    public void shouldMigrateToRightDirectories() throws Exception {
        this.preUpgrade();
        this.db.addLegacyUser(1, "builtin", LegacyAuthType.BUILTIN);
        this.db.addLegacyUser(2, "ldap", LegacyAuthType.LDAP);
        this.db.addGroup(1, "builtin");
        this.db.addGroup(2, "mixed");
        this.db.addGroupMembership(1, 1);
        this.db.addGroupMembership(1, 2);
        this.db.addGroupMembership(2, 2);
        this.db.runUpgradeScript();
        int ldapDirId = 2;
        this.db.addDirectory(2, "ldap", "ldap", "CONNECTOR");
        ImmutableMap users = ImmutableMap.of((Object)1, (Object)new MigratedUsersData("builtin", 1), (Object)2, (Object)new MigratedUsersData("ldap", 2));
        ImmutableMultimap groups = ImmutableMultimap.builder().put((Object)1, (Object)new MigratedGroupsData(100, 1, "builtin")).put((Object)2, (Object)new MigratedGroupsData(200, 1, "mixed")).put((Object)2, (Object)new MigratedGroupsData(300, 2, "mixed")).put((Object)3, (Object)new MigratedGroupsData(400, 1, "none")).build();
        new MigrateGroupMembershipsToCwdMemberships(this.connection, Logs.APP_LOG, (Map)users, (Multimap)groups).perform();
        MatcherAssert.assertThat(this.db.getRows("cwd_membership"), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{EmbeddedCrowdUpgradeTestData.matchGroupMembership(1, "builtin", 100, "builtin", 1), EmbeddedCrowdUpgradeTestData.matchGroupMembership(1, "builtin", 200, "mixed", 1), EmbeddedCrowdUpgradeTestData.matchGroupMembership(2, "ldap", 300, "mixed", 2)}));
    }
}

