/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate.upgrade.crowd;

import com.cenqua.crucible.hibernate.upgrade.crowd.EmbeddedCrowdUpgradeTestBase;
import com.cenqua.crucible.hibernate.upgrade.crowd.EmbeddedCrowdUpgradeTestData;
import com.cenqua.crucible.hibernate.upgrade.crowd.LegacyAuthType;
import com.cenqua.crucible.hibernate.upgrade.crowd.MigrateGroupsToCwdGroups;
import com.cenqua.crucible.hibernate.upgrade.crowd.MigratedGroupsData;
import com.cenqua.fisheye.logging.Logs;
import com.google.common.collect.Multimap;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class MigrateGroupsToCwdGroupsTest
extends EmbeddedCrowdUpgradeTestBase {
    @Test
    public void shouldAddGroupsToLdapDir() throws Exception {
        this.preUpgrade();
        this.db.addLegacyUser(1, "ldap", LegacyAuthType.LDAP);
        this.db.addLegacyUser(2, "builtin", LegacyAuthType.BUILTIN);
        this.db.addLegacyUser(3, "crowd", LegacyAuthType.CROWD);
        this.db.addGroup(1, "onlybuiltin");
        this.db.addGroup(2, "mixed");
        this.db.addGroupMembership(2, 1);
        this.db.addGroupMembership(1, 2);
        this.db.addGroupMembership(2, 2);
        this.db.addGroupMembership(3, 2);
        int ldapDirId = 2;
        this.db.runUpgradeScript();
        this.db.addDirectory(2, "LDAP LDAP", "java.lang.Object", "CONNECTOR");
        MigrateGroupsToCwdGroups migrateGroups = new MigrateGroupsToCwdGroups(this.connection, Logs.APP_LOG, Optional.of(2));
        migrateGroups.perform();
        Multimap migratedGroups = migrateGroups.getMigratedGroups();
        Assert.assertThat(this.db.getRows("cwd_group"), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{EmbeddedCrowdUpgradeTestData.matchCwdGroup(1, "onlybuiltin", 1, false), EmbeddedCrowdUpgradeTestData.matchCwdGroup(2, "onlybuiltin", 2, true), EmbeddedCrowdUpgradeTestData.matchCwdGroup(3, "mixed", 1, false), EmbeddedCrowdUpgradeTestData.matchCwdGroup(4, "mixed", 2, true)}));
        Assert.assertThat((Object)migratedGroups.size(), (Matcher)Matchers.equalTo((Object)4));
        Assert.assertThat((Object)migratedGroups.get((Object)1), (Matcher)Matchers.containsInAnyOrder((Object[])new MigratedGroupsData[]{new MigratedGroupsData(1, 1, "onlybuiltin"), new MigratedGroupsData(2, 2, "onlybuiltin")}));
        Assert.assertThat((Object)migratedGroups.get((Object)2), (Matcher)Matchers.containsInAnyOrder((Object[])new MigratedGroupsData[]{new MigratedGroupsData(3, 1, "mixed"), new MigratedGroupsData(4, 2, "mixed")}));
    }
}

