/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate.upgrade.crowd;

import com.atlassian.fecru.util.CaptureLog4jLogsRule;
import com.cenqua.crucible.hibernate.upgrade.crowd.EmbeddedCrowdUpgradeTestBase;
import com.cenqua.crucible.hibernate.upgrade.crowd.MigrateAuthenticationConfigurations;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.config.RootConfigRule;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.config1.CrowdAuthConfigType;
import com.cenqua.fisheye.config1.LdapConfigType;
import com.cenqua.fisheye.config1.SecurityType;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.util.PropertiesUtil;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.log4j.Level;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.AllOf;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNot;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;

public class MigrateAuthenticationConfigurationsTest
extends EmbeddedCrowdUpgradeTestBase {
    @Rule
    public RootConfigRule rootConfigRule = new RootConfigRule();
    private SecurityType securityConfig;
    private static final String LDAP_URL = "http://ldap.url";
    private static final String LDAP_SERVER_TIMEOUT = "15m";
    private static final String LDAP_USER_FILTER = "(uid=${USERNAME})";
    private static final String LDAP_BASE_DN = "o=sgi,c=us";
    private static final String LDAP_UID_ATTRIBUTE = "uid";
    private static final String LDAP_EMAIL_ATTRIBUTE = "email";
    private static final String LDAP_DISPLAY_NAME_ATTRIBUTE = "displayName";
    private static final String LDAP_SYNCHRONIZE_PERIOD = "4h";
    private static final String LDAP_BIND_DN = "foo";
    private static final String LDAP_PASSWORD = "secret_ldap_password";
    private static final String CROWD_APPLICATION_NAME = "fecru";
    private static final String CROWD_APPLICATION_PASSWORD = "secret_crowd_password";
    private static final String CROWD_SERVER_URL = "http://crowd.url";
    private static final String CROWD_RESYNC_PERIOD = "3 hours";
    private static final String CROWD_HTTP_TIMEOUT = "10000";
    private static final String CROWD_HTTP_MAX_CONNECTIONS = "40";
    private static final String CROWD_HTTP_PROXY_HOST = "httpProxyHost1";
    private static final String CROWD_HTTP_PROXY_PORT = "7777";
    private static final String CROWD_HTTP_PROXY_USERNAME = "andrzejduba";
    private static final String CROWD_HTTP_PROXY_PASSWORD = "tajemnicapoliszynela";

    @Before
    public void mockConfigXml() throws Exception {
        ConfigDocument config = ConfigDocument.Factory.newInstance();
        this.securityConfig = config.addNewConfig().addNewSecurity();
        Mockito.when((Object)this.rootConfigRule.getRootConfig().getConfig()).thenReturn((Object)config.getConfig());
    }

    @Test
    public void shouldLogIfNoLdapOrCrowdConfig() throws Exception {
        this.preUpgrade();
        this.db.runUpgradeScript();
        MigrateAuthenticationConfigurations migrateAuthenticationConfigurations = new MigrateAuthenticationConfigurations(this.connection, Logs.APP_LOG);
        migrateAuthenticationConfigurations.perform();
        MatcherAssert.assertThat(this.logs.getEvents(), (Matcher)Matchers.hasItem((Matcher)AllOf.allOf((Matcher)new CaptureLog4jLogsRule.LogWithLevel(Level.INFO), (Matcher)new CaptureLog4jLogsRule.LogWithMessage("Neither LDAP nor Crowd authentication configuration found in config.xml"))));
    }

    @Test
    public void shouldNotAlterDBIfNoLdapOrCrowdConfig() throws Exception {
        this.preUpgrade();
        this.db.runUpgradeScript();
        List<Map<String, Object>> crowdDirectoryTableRowsBefore = this.db.getRows("cwd_directory");
        List<Map<String, Object>> crowdDirectoryAttributeRowsBefore = this.db.getRows("cwd_directory_attribute");
        List<Map<String, Object>> crowdDirectoryOperationRowsBefore = this.db.getRows("cwd_directory_operation");
        List<Map<String, Object>> crowdDirectoryApplicationDirectoryMappingRowsBefore = this.db.getRows("cwd_app_dir_mapping");
        List<Map<String, Object>> crowdDirectoryApplicationOperationRowsBefore = this.db.getRows("cwd_app_dir_operation");
        MigrateAuthenticationConfigurations migrateAuthenticationConfigurations = new MigrateAuthenticationConfigurations(this.connection, Logs.APP_LOG);
        migrateAuthenticationConfigurations.perform();
        MatcherAssert.assertThat(this.db.getRows("cwd_directory"), (Matcher)Matchers.equalTo(crowdDirectoryTableRowsBefore));
        MatcherAssert.assertThat(this.db.getRows("cwd_directory_attribute"), (Matcher)Matchers.equalTo(crowdDirectoryAttributeRowsBefore));
        MatcherAssert.assertThat(this.db.getRows("cwd_directory_operation"), (Matcher)Matchers.equalTo(crowdDirectoryOperationRowsBefore));
        MatcherAssert.assertThat(this.db.getRows("cwd_app_dir_mapping"), (Matcher)Matchers.equalTo(crowdDirectoryApplicationDirectoryMappingRowsBefore));
        MatcherAssert.assertThat(this.db.getRows("cwd_app_dir_operation"), (Matcher)Matchers.equalTo(crowdDirectoryApplicationOperationRowsBefore));
    }

    @Test
    public void shouldNotAlterConfigInNoLdapOrCrowd() throws Exception {
        this.preUpgrade();
        this.db.runUpgradeScript();
        this.securityConfig.addNewCustom();
        String configBefore = this.securityConfig.toString();
        MigrateAuthenticationConfigurations migrateAuthenticationConfigurations = new MigrateAuthenticationConfigurations(this.connection, Logs.APP_LOG);
        migrateAuthenticationConfigurations.perform();
        MatcherAssert.assertThat((Object)this.securityConfig.toString(), (Matcher)Matchers.equalTo((Object)configBefore));
    }

    @Test
    public void shouldLogLdapConfigurationXML() throws Exception {
        this.preUpgrade();
        this.db.runUpgradeScript();
        this.createLdapAuthConfiguration();
        MigrateAuthenticationConfigurations migrateAuthenticationConfigurations = new MigrateAuthenticationConfigurations(this.connection, Logs.APP_LOG);
        migrateAuthenticationConfigurations.perform();
        MatcherAssert.assertThat(this.logs.getEvents(), (Matcher)Matchers.hasItem((Matcher)AllOf.allOf((Matcher)new CaptureLog4jLogsRule.LogWithLevel(Level.INFO), (Matcher)new CaptureLog4jLogsRule.LogWithMessage((Matcher<String>)Matchers.containsString((String)"Existing LDAP configuration")), (Matcher)new CaptureLog4jLogsRule.LogWithMessage((Matcher<String>)Matchers.containsString((String)"<ldap")), (Matcher)new CaptureLog4jLogsRule.LogWithMessage((Matcher<String>)Matchers.containsString((String)"url=\"http://ldap.url\" server-timeout=\"15m\" base-dn=\"o=sgi,c=us\" filter=\"(uid=${USERNAME})\" uid-attr=\"uid\" email-attr=\"email\" displayname-attr=\"displayName\" resyncPeriod=\"4h\" initial-dn=\"foo\"")), (Matcher)new CaptureLog4jLogsRule.LogWithMessage((Matcher<String>)Matchers.containsString((String)"initial-secret=\"***\"")))));
        MatcherAssert.assertThat(this.logs.getEvents(), (Matcher)IsNot.not((Matcher)Matchers.hasItem((Matcher)new CaptureLog4jLogsRule.LogWithMessage((Matcher<String>)Matchers.containsString((String)LDAP_PASSWORD)))));
    }

    @Test
    public void shouldLogCrowdConfigurationXML() throws Exception {
        this.preUpgrade();
        this.db.runUpgradeScript();
        this.createCrowdAuthConfiguration();
        MigrateAuthenticationConfigurations migrateAuthenticationConfigurations = new MigrateAuthenticationConfigurations(this.connection, Logs.APP_LOG);
        migrateAuthenticationConfigurations.perform();
        MatcherAssert.assertThat(this.logs.getEvents(), (Matcher)Matchers.hasItem((Matcher)AllOf.allOf((Matcher[])new Matcher[]{new CaptureLog4jLogsRule.LogWithLevel(Level.INFO), new CaptureLog4jLogsRule.LogWithMessage((Matcher<String>)Matchers.containsString((String)"Existing Crowd configuration: ")), new CaptureLog4jLogsRule.LogWithMessage((Matcher<String>)Matchers.containsString((String)"<crowd")), new CaptureLog4jLogsRule.LogWithMessage((Matcher<String>)Matchers.containsString((String)"resyncPeriod=\"3 hours\"")), new CaptureLog4jLogsRule.LogWithMessage((Matcher<String>)Matchers.containsString((String)"application.password=***")), new CaptureLog4jLogsRule.LogWithMessage((Matcher<String>)Matchers.containsString((String)"application.name=fecru")), new CaptureLog4jLogsRule.LogWithMessage((Matcher<String>)Matchers.containsString((String)"crowd.server.url=http\\://crowd.url"))})));
        MatcherAssert.assertThat(this.logs.getEvents(), (Matcher)IsNot.not((Matcher)Matchers.hasItem((Matcher)new CaptureLog4jLogsRule.LogWithMessage((Matcher<String>)Matchers.containsString((String)CROWD_APPLICATION_PASSWORD)))));
    }

    @Test
    public void shouldDefineLdapDirectory() throws Exception {
        this.preUpgrade();
        this.db.runUpgradeScript();
        this.createLdapAuthConfiguration();
        MigrateAuthenticationConfigurations migrateAuthenticationConfigurations = new MigrateAuthenticationConfigurations(this.connection, Logs.APP_LOG);
        migrateAuthenticationConfigurations.perform();
        MatcherAssert.assertThat(this.db.getRows("cwd_directory"), (Matcher)Matchers.hasItem((Matcher)Matchers.allOf((Matcher[])new Matcher[]{Matchers.hasEntry((Object)"id", (Object)2), Matchers.hasEntry((Object)"directory_name", (Object)"LDAP Directory"), Matchers.hasEntry((Object)"lower_directory_name", (Object)"ldap directory"), Matchers.hasEntry((Object)"active", (Object)"T"), Matchers.hasEntry((Object)"impl_class", (Object)"com.atlassian.crowd.directory.GenericLDAP"), Matchers.hasEntry((Object)"lower_impl_class", (Object)"com.atlassian.crowd.directory.genericldap"), Matchers.hasEntry((Object)"directory_type", (Object)"CONNECTOR")})));
    }

    @Test
    public void shouldDefineLdapDirectoryOperations() throws Exception {
        this.preUpgrade();
        this.db.runUpgradeScript();
        this.createLdapAuthConfiguration();
        MigrateAuthenticationConfigurations migrateAuthenticationConfigurations = new MigrateAuthenticationConfigurations(this.connection, Logs.APP_LOG);
        migrateAuthenticationConfigurations.perform();
        MatcherAssert.assertThat(this.db.getRows("cwd_directory_operation").stream().filter(row -> row.get("directory_id").equals(2)).collect(Collectors.toList()), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{this.matchesDirectoryOperation("CREATE_GROUP"), this.matchesDirectoryOperation("DELETE_GROUP"), this.matchesDirectoryOperation("UPDATE_GROUP"), this.matchesDirectoryOperation("UPDATE_GROUP_ATTRIBUTE"), this.matchesDirectoryOperation("UPDATE_USER_ATTRIBUTE")}));
    }

    @Test
    public void shouldDefineCrowdDirectory() throws Exception {
        this.preUpgrade();
        this.db.runUpgradeScript();
        this.createCrowdAuthConfiguration();
        MigrateAuthenticationConfigurations migrateAuthenticationConfigurations = new MigrateAuthenticationConfigurations(this.connection, Logs.APP_LOG);
        migrateAuthenticationConfigurations.perform();
        MatcherAssert.assertThat(this.db.getRows("cwd_directory"), (Matcher)Matchers.hasItem((Matcher)Matchers.allOf((Matcher[])new Matcher[]{Matchers.hasEntry((Object)"id", (Object)2), Matchers.hasEntry((Object)"directory_name", (Object)"Crowd Directory"), Matchers.hasEntry((Object)"lower_directory_name", (Object)"crowd directory"), Matchers.hasEntry((Object)"active", (Object)"T"), Matchers.hasEntry((Object)"impl_class", (Object)"com.atlassian.crowd.directory.RemoteCrowdDirectory"), Matchers.hasEntry((Object)"lower_impl_class", (Object)"com.atlassian.crowd.directory.remotecrowddirectory"), Matchers.hasEntry((Object)"directory_type", (Object)"CROWD")})));
    }

    @Test
    public void shouldDefineCrowdDirectoryOperations() throws Exception {
        this.preUpgrade();
        this.db.runUpgradeScript();
        this.createCrowdAuthConfiguration();
        MigrateAuthenticationConfigurations migrateAuthenticationConfigurations = new MigrateAuthenticationConfigurations(this.connection, Logs.APP_LOG);
        migrateAuthenticationConfigurations.perform();
        MatcherAssert.assertThat(this.db.getRows("cwd_directory_operation").stream().filter(row -> row.get("directory_id").equals(2)).collect(Collectors.toList()), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{this.matchesDirectoryOperation("UPDATE_GROUP_ATTRIBUTE"), this.matchesDirectoryOperation("UPDATE_USER_ATTRIBUTE")}));
    }

    @Test
    public void shouldOrderRemoteDirectoryBeforeInternalDirectory() throws Exception {
        this.preUpgrade();
        this.db.runUpgradeScript();
        this.createLdapAuthConfiguration();
        MigrateAuthenticationConfigurations migrateAuthenticationConfigurations = new MigrateAuthenticationConfigurations(this.connection, Logs.APP_LOG);
        migrateAuthenticationConfigurations.perform();
        MatcherAssert.assertThat(this.db.getRows("cwd_app_dir_mapping"), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{AllOf.allOf((Matcher)Matchers.hasEntry((Object)"directory_id", (Object)2), (Matcher)Matchers.hasEntry((Object)"list_index", (Object)0)), AllOf.allOf((Matcher)Matchers.hasEntry((Object)"directory_id", (Object)1), (Matcher)Matchers.hasEntry((Object)"list_index", (Object)1))}));
    }

    @Test
    public void shouldDefineLdapApplicationDirectoryMappingOperations() throws Exception {
        this.preUpgrade();
        this.db.runUpgradeScript();
        this.createLdapAuthConfiguration();
        MigrateAuthenticationConfigurations migrateAuthenticationConfigurations = new MigrateAuthenticationConfigurations(this.connection, Logs.APP_LOG);
        migrateAuthenticationConfigurations.perform();
        MatcherAssert.assertThat(this.db.getRows("cwd_app_dir_operation").stream().filter(row -> row.get("app_dir_mapping_id").equals(2)).collect(Collectors.toList()), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{this.matchesDirectoryOperation("CREATE_GROUP"), this.matchesDirectoryOperation("CREATE_ROLE"), this.matchesDirectoryOperation("CREATE_USER"), this.matchesDirectoryOperation("DELETE_GROUP"), this.matchesDirectoryOperation("DELETE_ROLE"), this.matchesDirectoryOperation("DELETE_USER"), this.matchesDirectoryOperation("UPDATE_GROUP"), this.matchesDirectoryOperation("UPDATE_GROUP_ATTRIBUTE"), this.matchesDirectoryOperation("UPDATE_ROLE"), this.matchesDirectoryOperation("UPDATE_ROLE_ATTRIBUTE"), this.matchesDirectoryOperation("UPDATE_USER"), this.matchesDirectoryOperation("UPDATE_USER_ATTRIBUTE")}));
    }

    @Test
    public void shouldDefineCrowdApplicationDirectoryMappingOperations() throws Exception {
        this.preUpgrade();
        this.db.runUpgradeScript();
        this.createCrowdAuthConfiguration();
        MigrateAuthenticationConfigurations migrateAuthenticationConfigurations = new MigrateAuthenticationConfigurations(this.connection, Logs.APP_LOG);
        migrateAuthenticationConfigurations.perform();
        MatcherAssert.assertThat(this.db.getRows("cwd_app_dir_operation").stream().filter(row -> row.get("app_dir_mapping_id").equals(2)).collect(Collectors.toList()), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{this.matchesDirectoryOperation("CREATE_GROUP"), this.matchesDirectoryOperation("CREATE_ROLE"), this.matchesDirectoryOperation("CREATE_USER"), this.matchesDirectoryOperation("DELETE_GROUP"), this.matchesDirectoryOperation("DELETE_ROLE"), this.matchesDirectoryOperation("DELETE_USER"), this.matchesDirectoryOperation("UPDATE_GROUP"), this.matchesDirectoryOperation("UPDATE_GROUP_ATTRIBUTE"), this.matchesDirectoryOperation("UPDATE_ROLE"), this.matchesDirectoryOperation("UPDATE_ROLE_ATTRIBUTE"), this.matchesDirectoryOperation("UPDATE_USER"), this.matchesDirectoryOperation("UPDATE_USER_ATTRIBUTE")}));
    }

    @Test
    public void shouldMigrateLdapAttributes() throws Exception {
        this.preUpgrade();
        this.db.runUpgradeScript();
        this.createLdapAuthConfiguration();
        MigrateAuthenticationConfigurations migrateAuthenticationConfigurations = new MigrateAuthenticationConfigurations(this.connection, Logs.APP_LOG);
        migrateAuthenticationConfigurations.perform();
        MatcherAssert.assertThat(this.db.getRows("cwd_directory_attribute").stream().filter(row -> row.get("directory_id").equals(2)).collect(Collectors.toList()), (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{this.matchesDirectoryAttribute("ldap.url", LDAP_URL), this.matchesDirectoryAttribute("ldap.basedn", LDAP_BASE_DN), this.matchesDirectoryAttribute("ldap.user.filter", "(uid=*)"), this.matchesDirectoryAttribute("ldap.user.username", LDAP_UID_ATTRIBUTE), this.matchesDirectoryAttribute("ldap.user.email", LDAP_EMAIL_ATTRIBUTE), this.matchesDirectoryAttribute("ldap.user.displayname", LDAP_DISPLAY_NAME_ATTRIBUTE), this.matchesDirectoryAttribute("ldap.read.timeout", "900000"), this.matchesDirectoryAttribute("directory.cache.synchronise.interval", "14400"), this.matchesDirectoryAttribute("ldap.userdn", LDAP_BIND_DN), this.matchesDirectoryAttribute("ldap.password", LDAP_PASSWORD), this.matchesDirectoryAttribute("ldap.pagedresults", "true"), this.matchesDirectoryAttribute("ldap.pagedresults.size", "1000")}));
    }

    @Test
    public void shouldMigrateCrowdAttributes() throws Exception {
        this.preUpgrade();
        this.db.runUpgradeScript();
        this.createCrowdAuthConfiguration();
        MigrateAuthenticationConfigurations migrateAuthenticationConfigurations = new MigrateAuthenticationConfigurations(this.connection, Logs.APP_LOG);
        migrateAuthenticationConfigurations.perform();
        MatcherAssert.assertThat(this.db.getRows("cwd_directory_attribute").stream().filter(row -> row.get("directory_id").equals(2)).collect(Collectors.toList()), (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{this.matchesDirectoryAttribute("application.name", CROWD_APPLICATION_NAME), this.matchesDirectoryAttribute("application.password", CROWD_APPLICATION_PASSWORD), this.matchesDirectoryAttribute("crowd.server.url", CROWD_SERVER_URL), this.matchesDirectoryAttribute("directory.cache.synchronise.interval", "10800")}));
    }

    @Test
    public void shouldMigrateCrowdOptionalAttributes() throws Exception {
        this.preUpgrade();
        this.db.runUpgradeScript();
        this.createCrowdAuthConfigurationWithOptionalAttributes(false);
        MigrateAuthenticationConfigurations migrateAuthenticationConfigurations = new MigrateAuthenticationConfigurations(this.connection, Logs.APP_LOG);
        migrateAuthenticationConfigurations.perform();
        MatcherAssert.assertThat(this.db.getRows("cwd_directory_attribute").stream().filter(row -> row.get("directory_id").equals(2)).collect(Collectors.toList()), (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{this.matchesDirectoryAttribute("crowd.server.http.timeout", CROWD_HTTP_TIMEOUT), this.matchesDirectoryAttribute("crowd.server.http.max.connections", CROWD_HTTP_MAX_CONNECTIONS), this.matchesDirectoryAttribute("crowd.server.http.proxy.host", CROWD_HTTP_PROXY_HOST), this.matchesDirectoryAttribute("crowd.server.http.proxy.port", CROWD_HTTP_PROXY_PORT), this.matchesDirectoryAttribute("crowd.server.http.proxy.username", CROWD_HTTP_PROXY_USERNAME), this.matchesDirectoryAttribute("crowd.server.http.proxy.port", CROWD_HTTP_PROXY_PORT)}));
    }

    @Test
    public void shouldCleanLdapConfiguration() throws Exception {
        this.preUpgrade();
        this.db.runUpgradeScript();
        this.createLdapAuthConfiguration();
        MigrateAuthenticationConfigurations migrateAuthenticationConfigurations = new MigrateAuthenticationConfigurations(this.connection, Logs.APP_LOG);
        migrateAuthenticationConfigurations.perform();
        migrateAuthenticationConfigurations.cleanupSecurityConfigXml();
        MatcherAssert.assertThat((Object)this.securityConfig.isSetLdap(), (Matcher)Is.is((Object)false));
        ((RootConfig)Mockito.verify((Object)this.rootConfigRule.getRootConfig())).saveConfig();
    }

    @Test
    public void shouldLeaveCrowdConfigurationIfNoSSOEnabled() throws Exception {
        this.preUpgrade();
        this.db.runUpgradeScript();
        this.createCrowdAuthConfigurationWithOptionalAttributes(null);
        MigrateAuthenticationConfigurations migrateAuthenticationConfigurations = new MigrateAuthenticationConfigurations(this.connection, Logs.APP_LOG);
        migrateAuthenticationConfigurations.perform();
        migrateAuthenticationConfigurations.cleanupSecurityConfigXml();
        MatcherAssert.assertThat((Object)this.securityConfig.isSetCrowd(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)this.securityConfig.getCrowd().getSsoEnabled(), (Matcher)Is.is((Object)false));
        ((RootConfig)Mockito.verify((Object)this.rootConfigRule.getRootConfig())).saveConfig();
    }

    @Test
    public void shouldLeaveCrowdConfigurationIfSSODisabled() throws Exception {
        this.preUpgrade();
        this.db.runUpgradeScript();
        this.createCrowdAuthConfigurationWithOptionalAttributes(true);
        MigrateAuthenticationConfigurations migrateAuthenticationConfigurations = new MigrateAuthenticationConfigurations(this.connection, Logs.APP_LOG);
        migrateAuthenticationConfigurations.perform();
        migrateAuthenticationConfigurations.cleanupSecurityConfigXml();
        MatcherAssert.assertThat((Object)this.securityConfig.isSetCrowd(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)this.securityConfig.getCrowd().getSsoEnabled(), (Matcher)Is.is((Object)true));
        ((RootConfig)Mockito.verify((Object)this.rootConfigRule.getRootConfig())).saveConfig();
    }

    @Test
    public void shouldLeaveCrowdConfigurationIfSSOEnabled() throws Exception {
        this.preUpgrade();
        this.db.runUpgradeScript();
        this.createCrowdAuthConfigurationWithOptionalAttributes(false);
        MigrateAuthenticationConfigurations migrateAuthenticationConfigurations = new MigrateAuthenticationConfigurations(this.connection, Logs.APP_LOG);
        migrateAuthenticationConfigurations.perform();
        migrateAuthenticationConfigurations.cleanupSecurityConfigXml();
        MatcherAssert.assertThat((Object)this.securityConfig.isSetCrowd(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)this.securityConfig.getCrowd().getSsoEnabled(), (Matcher)Is.is((Object)false));
        ((RootConfig)Mockito.verify((Object)this.rootConfigRule.getRootConfig())).saveConfig();
    }

    private void createLdapAuthConfiguration() {
        LdapConfigType ldapConfig = this.securityConfig.addNewLdap();
        ldapConfig.setUrl(LDAP_URL);
        ldapConfig.setServerTimeout(LDAP_SERVER_TIMEOUT);
        ldapConfig.setBaseDn(LDAP_BASE_DN);
        ldapConfig.setFilter(LDAP_USER_FILTER);
        ldapConfig.setUidAttr(LDAP_UID_ATTRIBUTE);
        ldapConfig.setEmailAttr(LDAP_EMAIL_ATTRIBUTE);
        ldapConfig.setDisplaynameAttr(LDAP_DISPLAY_NAME_ATTRIBUTE);
        ldapConfig.setResyncPeriod(LDAP_SYNCHRONIZE_PERIOD);
        ldapConfig.setInitialDn(LDAP_BIND_DN);
        ldapConfig.setInitialSecret(LDAP_PASSWORD);
    }

    private void createCrowdAuthConfiguration() {
        CrowdAuthConfigType crowdConfig = this.securityConfig.addNewCrowd();
        Properties properties = new Properties();
        properties.setProperty("application.name", CROWD_APPLICATION_NAME);
        properties.setProperty("application.password", CROWD_APPLICATION_PASSWORD);
        properties.setProperty("crowd.server.url", CROWD_SERVER_URL);
        crowdConfig.setCrowdProperties(PropertiesUtil.saveToString((Properties)properties));
        crowdConfig.setResyncPeriod(CROWD_RESYNC_PERIOD);
    }

    private void createCrowdAuthConfigurationWithOptionalAttributes(@Nullable Boolean ssoEnabled) {
        CrowdAuthConfigType crowdConfig = this.securityConfig.addNewCrowd();
        Properties properties = new Properties();
        properties.setProperty("application.name", CROWD_APPLICATION_NAME);
        properties.setProperty("application.password", CROWD_APPLICATION_PASSWORD);
        properties.setProperty("crowd.server.url", CROWD_SERVER_URL);
        properties.setProperty("http.timeout", CROWD_HTTP_TIMEOUT);
        properties.setProperty("http.max.connections", CROWD_HTTP_MAX_CONNECTIONS);
        properties.setProperty("http.proxy.host", CROWD_HTTP_PROXY_HOST);
        properties.setProperty("http.proxy.port", CROWD_HTTP_PROXY_PORT);
        properties.setProperty("http.proxy.username", CROWD_HTTP_PROXY_USERNAME);
        properties.setProperty("http.proxy.password", CROWD_HTTP_PROXY_PASSWORD);
        crowdConfig.setCrowdProperties(PropertiesUtil.saveToString((Properties)properties));
        crowdConfig.setResyncPeriod(CROWD_RESYNC_PERIOD);
        if (ssoEnabled != null) {
            crowdConfig.setSsoEnabled(ssoEnabled.booleanValue());
        }
    }

    private Matcher<Map<String, Object>> matchesDirectoryOperation(String operationType) {
        return Matchers.allOf((Matcher[])new Matcher[]{Matchers.hasEntry((Object)"operation_type", (Object)operationType)});
    }

    private Matcher<Map<String, Object>> matchesDirectoryAttribute(String attributeName, Object attributeValue) {
        return Matchers.allOf((Matcher)Matchers.hasEntry((Object)"attribute_name", (Object)attributeName), (Matcher)Matchers.hasEntry((Object)"attribute_value", (Object)attributeValue));
    }
}

