/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate.upgrade.crowd;

import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.cenqua.crucible.hibernate.CruDBException;
import com.cenqua.crucible.hibernate.DefaultDBControl;
import com.cenqua.crucible.hibernate.upgrade.crowd.LegacyAuthType;
import com.cenqua.fisheye.user.UserManager;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

class EmbeddedCrowdUpgradeTestData {
    static final String CROWD_USER_TABLE = "cwd_user";
    static final String CROWD_GROUP_TABLE = "cwd_group";
    static final String CROWD_APPLICATION_TABLE = "cwd_application";
    static final String CROWD_APPLICATION_ATTRIBUTE_TABLE = "cwd_application_attribute";
    static final String CROWD_DIRECTORY_TABLE = "cwd_directory";
    static final String CROWD_DIRECTORY_ATTRIBUTE_TABLE = "cwd_directory_attribute";
    static final String CROWD_DIRECTORY_OPERATION_TABLE = "cwd_directory_operation";
    static final String CROWD_MEMBERSHIP_TABLE = "cwd_membership";
    static final String CROWD_APPLICATION_DIRECTORY_MAPPING_TABLE = "cwd_app_dir_mapping";
    static final String CROWD_APPLICATION_DIRECTORY_OPERATION_TABLE = "cwd_app_dir_operation";
    static final String FECRU_GLOBAL_PERMISSIONS_TABLE = "cru_global_permission";
    private final Connection connection;
    private final DefaultDBControl dbControl;

    EmbeddedCrowdUpgradeTestData(DefaultDBControl dbControl, Connection connection) {
        this.dbControl = dbControl;
        this.connection = connection;
    }

    void addLegacyUser(int id, String username, LegacyAuthType authType) throws SQLException {
        this.addLegacyUser(id, username, null, null, null, authType);
    }

    void addLegacyUser(int id, String username, LegacyAuthType authType, boolean fishEye, boolean crucible) throws SQLException {
        this.addLegacyUser(id, username, null, null, null, authType, fishEye, crucible);
    }

    void addLegacyUser(int id, String username, String displayname, String email, String passwordHash, LegacyAuthType authType) throws SQLException {
        this.addLegacyUser(id, username, displayname, email, passwordHash, authType, true, true);
    }

    void addLegacyUser(int id, String username, String displayname, String email, String passwordHash, LegacyAuthType authType, boolean fishEye, boolean crucible) throws SQLException {
        try (PreparedStatement statement = this.connection.prepareStatement("INSERT INTO cru_user (cru_user_id, cru_user_name, cru_displayname, cru_email, cru_passwordhash, cru_authtype, cru_fisheye_enabled, cru_crucible_enabled) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");){
            statement.setInt(1, id);
            statement.setString(2, username);
            statement.setString(3, displayname);
            statement.setString(4, email);
            statement.setString(5, passwordHash);
            statement.setInt(6, authType.getKey());
            statement.setObject(7, this.booleanType(fishEye));
            statement.setObject(8, this.booleanType(crucible));
            statement.executeUpdate();
        }
        statement = this.connection.prepareStatement("INSERT INTO cru_user_profile (cru_user_id, cru_dont_send_me_my_notes, cru_state_change_email_note, cru_comment_email_note, cru_reply_email_note, cru_general_email_note, cru_complete_email_note, cru_uncomplete_email_note, cru_uncomplete_on_defect, cru_uncomplete_on_rev_added) VALUES (?, ?, 1, 1, 1, 1, 1, 2, ?, ?)");
        var10_10 = null;
        try {
            statement.setInt(1, id);
            statement.setObject(2, this.booleanType(true));
            statement.setObject(3, this.booleanType(true));
            statement.setObject(4, this.booleanType(true));
            statement.execute();
        }
        catch (Throwable throwable) {
            var10_10 = throwable;
            throw throwable;
        }
        finally {
            if (statement != null) {
                if (var10_10 != null) {
                    try {
                        statement.close();
                    }
                    catch (Throwable throwable) {
                        var10_10.addSuppressed(throwable);
                    }
                } else {
                    statement.close();
                }
            }
        }
    }

    List<Map<String, Object>> getRows(String tableName) throws SQLException, IOException {
        ImmutableList.Builder result = ImmutableList.builder();
        try (Statement statement = this.connection.createStatement();
             ResultSet resultSet = statement.executeQuery("SELECT * FROM " + tableName);){
            while (resultSet.next()) {
                HashMap rowData = Maps.newHashMap();
                ResultSetMetaData metaData = resultSet.getMetaData();
                for (int columnIdx = 1; columnIdx <= metaData.getColumnCount(); ++columnIdx) {
                    Object value = resultSet.getObject(columnIdx);
                    if (value instanceof Long) {
                        value = ((Long)value).intValue();
                    } else if (value instanceof BigDecimal) {
                        value = ((BigDecimal)value).intValue();
                    } else if (value instanceof Clob) {
                        value = IOUtils.toString((Reader)((Clob)value).getCharacterStream());
                    }
                    rowData.put(metaData.getColumnName(columnIdx).toLowerCase(Locale.US), value);
                }
                result.add((Object)rowData);
            }
        }
        return result.build();
    }

    private Object booleanType(boolean bool) {
        switch (this.dbControl.getType()) {
            case POSTGRESQL: {
                return bool;
            }
        }
        return bool ? 1 : 0;
    }

    void addGroup(int id, String groupName) throws SQLException {
        try (PreparedStatement addGroup = this.connection.prepareStatement("INSERT INTO cru_builtin_group (cru_builtin_group_id, cru_builtin_group_name) VALUES (?, ?)");){
            addGroup.setInt(1, id);
            addGroup.setString(2, groupName);
            addGroup.execute();
        }
    }

    void addGroupMembership(int userId, int groupId) throws SQLException {
        try (PreparedStatement addGroup = this.connection.prepareStatement("INSERT INTO cru_builtin_group_user (cru_user_id, cru_builtin_group_id) VALUES (?, ?)");){
            addGroup.setInt(1, userId);
            addGroup.setInt(2, groupId);
            addGroup.executeUpdate();
        }
    }

    void addDirectory(int id, String name, String implClass, String type) throws SQLException {
        try (PreparedStatement statement = this.connection.prepareStatement("INSERT INTO cwd_directory (id, directory_name, lower_directory_name, created_date, updated_date, active, impl_class, lower_impl_class, directory_type) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");){
            Date now = new Date(System.currentTimeMillis());
            statement.setInt(1, id);
            statement.setString(2, name);
            statement.setString(3, IdentifierUtils.toLowerCase((String)name));
            statement.setDate(4, now);
            statement.setDate(5, now);
            statement.setString(6, "T");
            statement.setString(7, implClass);
            statement.setString(8, IdentifierUtils.toLowerCase((String)implClass));
            statement.setString(9, type);
            statement.execute();
        }
    }

    void runUpgradeScript() throws IOException, CruDBException {
        try (BufferedReader upgrade = Files.newReader((File)this.dbControl.makeDBScriptFile(DefaultDBControl.DBScriptType.upgrade, 92), (Charset)Charsets.UTF_8);){
            this.dbControl.executeScript(upgrade);
        }
    }

    static Matcher<Map<String, Object>> matchCruUser(int id, String username) {
        return Matchers.allOf((Matcher)Matchers.hasEntry((Object)"cru_user_id", (Object)id), (Matcher)Matchers.hasEntry((Object)"cru_user_name", (Object)username));
    }

    static Matcher<Map<String, Object>> matchCwdUser(int id, String username) {
        return Matchers.allOf((Matcher)Matchers.hasEntry((Object)"id", (Object)id), (Matcher)Matchers.hasEntry((Object)"user_name", (Object)username));
    }

    static Matcher<Map<String, Object>> matchCwdUser(int id, String username, String displayname, String email, String credential, int directoryId) {
        return Matchers.allOf((Matcher[])new Matcher[]{Matchers.hasEntry((Object)"id", (Object)id), Matchers.hasEntry((Object)"user_name", (Object)username), Matchers.hasEntry((Object)"lower_user_name", (Object)IdentifierUtils.toLowerCase((String)username)), Matchers.hasEntry((Object)"active", (Object)"T"), Matchers.hasEntry((Object)"display_name", (Object)displayname), Matchers.hasEntry((Object)"lower_display_name", (Object)IdentifierUtils.toLowerCase((String)displayname)), Matchers.hasEntry((Object)"email_address", (Object)email), Matchers.hasEntry((Object)"lower_email_address", (Object)IdentifierUtils.toLowerCase((String)email)), Matchers.hasEntry((Object)"credential", (Object)credential), Matchers.hasEntry((Object)"directory_id", (Object)directoryId)});
    }

    static Matcher<Map<String, Object>> matchCwdGroup(String groupName, int directoryId) {
        return Matchers.allOf((Matcher)Matchers.hasEntry((Object)"group_name", (Object)groupName), (Matcher)Matchers.hasEntry((Object)"lower_group_name", UserManager.GROUPNAME_NORMALIZATION.apply(groupName)), (Matcher)Matchers.hasEntry((Object)"active", (Object)"T"), (Matcher)Matchers.hasEntry((Object)"is_local", (Object)(directoryId != 1 ? "T" : "F")), (Matcher)Matchers.hasEntry((Object)"group_type", (Object)"GROUP"), (Matcher)Matchers.hasEntry((Object)"directory_id", (Object)directoryId));
    }

    static Matcher<Map<String, Object>> matchCwdGroup(int id, String groupName) {
        return EmbeddedCrowdUpgradeTestData.matchCwdGroup(id, groupName, 1);
    }

    static Matcher<Map<String, Object>> matchCwdGroup(int id, String groupName, int directoryId) {
        return EmbeddedCrowdUpgradeTestData.matchCwdGroup(id, groupName, directoryId, false);
    }

    static Matcher<Map<String, Object>> matchCwdGroup(int id, String groupName, int directoryId, boolean isLocal) {
        return Matchers.allOf((Matcher[])new Matcher[]{Matchers.hasEntry((Object)"id", (Object)id), Matchers.hasEntry((Object)"group_name", (Object)groupName), Matchers.hasEntry((Object)"lower_group_name", UserManager.GROUPNAME_NORMALIZATION.apply(groupName)), Matchers.hasEntry((Object)"active", (Object)"T"), Matchers.hasEntry((Object)"is_local", (Object)(isLocal ? "T" : "F")), Matchers.hasEntry((Object)"group_type", (Object)"GROUP"), Matchers.hasEntry((Object)"directory_id", (Object)directoryId)});
    }

    static Matcher<Map<String, Object>> matchGlobalPermission(String groupName, boolean fisheye, boolean crucible) {
        return Matchers.allOf((Matcher)Matchers.hasEntry((Object)"cru_group", (Object)groupName), (Matcher)Matchers.hasEntry((Matcher)Matchers.equalTo((Object)"cru_fisheye_user"), (Matcher)Matchers.anyOf((Matcher)Matchers.equalTo((Object)fisheye), (Matcher)Matchers.equalTo((Object)(fisheye ? 1 : 0)))), (Matcher)Matchers.hasEntry((Matcher)Matchers.equalTo((Object)"cru_crucible_user"), (Matcher)Matchers.anyOf((Matcher)Matchers.equalTo((Object)crucible), (Matcher)Matchers.equalTo((Object)(crucible ? 1 : 0)))));
    }

    static Matcher<Map<String, Object>> matchGroupMembership(int userId, String username, int groupId, String groupName, int directoryId) {
        return Matchers.allOf((Matcher[])new Matcher[]{Matchers.hasEntry((Object)"parent_id", (Object)groupId), Matchers.hasEntry((Object)"parent_name", (Object)groupName), Matchers.hasEntry((Object)"lower_parent_name", UserManager.GROUPNAME_NORMALIZATION.apply(groupName)), Matchers.hasEntry((Object)"child_id", (Object)userId), Matchers.hasEntry((Object)"child_name", (Object)username), Matchers.hasEntry((Object)"lower_child_name", UserManager.USERNAME_NORMALIZATION.apply(username)), Matchers.hasEntry((Object)"directory_id", (Object)directoryId), Matchers.hasEntry((Object)"group_type", (Object)"GROUP"), Matchers.hasEntry((Object)"membership_type", (Object)"GROUP_USER")});
    }

    static Matcher<Map<String, Object>> matchGroupMembership(String username, String groupName, int directoryId) {
        return Matchers.allOf((Matcher)Matchers.hasEntry((Object)"parent_name", (Object)groupName), (Matcher)Matchers.hasEntry((Object)"child_name", (Object)username), (Matcher)Matchers.hasEntry((Object)"directory_id", (Object)directoryId), (Matcher)Matchers.hasEntry((Object)"group_type", (Object)"GROUP"), (Matcher)Matchers.hasEntry((Object)"membership_type", (Object)"GROUP_USER"));
    }
}

